/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import java.math.BigInteger;
import java.util.Vector;

public class Prime {
    static Vector<BigInteger> a = new Vector();
    protected static BigInteger nMax = new BigInteger("-1");

    public Prime() {
        if (a.size() == 0) {
            a.add(new BigInteger("2"));
            a.add(new BigInteger("3"));
            a.add(new BigInteger("5"));
            a.add(new BigInteger("7"));
            a.add(new BigInteger("11"));
            a.add(new BigInteger("13"));
            a.add(new BigInteger("17"));
        }
        nMax = a.lastElement();
    }

    public boolean contains(BigInteger n) {
        switch (this.millerRabin(n)) {
            case -1: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        this.growto(n);
        return a.contains(n);
    }

    public boolean isSPP(BigInteger n, BigInteger a) {
        int s;
        BigInteger two = new BigInteger("2");
        if (n.compareTo(two) == -1) {
            return false;
        }
        if (n.compareTo(two) == 0) {
            return true;
        }
        if (n.remainder(two).compareTo(BigInteger.ZERO) == 0) {
            return false;
        }
        BigInteger q = n.subtract(BigInteger.ONE);
        BigInteger d = q.shiftRight(s = q.getLowestSetBit());
        if (a.modPow(d, n).compareTo(BigInteger.ONE) == 0) {
            return true;
        }
        for (int r = 0; r < s; ++r) {
            if (a.modPow(d.shiftLeft(r), n).compareTo(q) != 0) continue;
            return true;
        }
        return false;
    }

    public int millerRabin(BigInteger n) {
        int l;
        int mrLim;
        String[] mr = new String[]{"2047", "1373653", "25326001", "3215031751", "2152302898747", "3474749660383", "341550071728321"};
        for (mrLim = 0; mrLim < mr.length && (l = n.compareTo(new BigInteger(mr[mrLim]))) >= 0; ++mrLim) {
            if (l != 0) continue;
            return -1;
        }
        if (mrLim == mr.length) {
            return 0;
        }
        for (int p = 0; p <= mrLim; ++p) {
            if (this.isSPP(n, this.at(p))) continue;
            return -1;
        }
        return 1;
    }

    public BigInteger at(int i) {
        while (i >= a.size()) {
            this.growto(nMax.add(new BigInteger("5")));
        }
        return a.elementAt(i);
    }

    public BigInteger pi(BigInteger n) {
        this.growto(n);
        BigInteger r = new BigInteger("0");
        for (int i = 0; i < a.size(); ++i) {
            if (a.elementAt(i).compareTo(n) > 0) continue;
            r = r.add(BigInteger.ONE);
        }
        return r;
    }

    public BigInteger nextprime(BigInteger n) {
        if (n.compareTo(BigInteger.ONE) <= 0) {
            return a.elementAt(0);
        }
        while (a.lastElement().compareTo(n) <= 0) {
            this.growto(nMax.add(new BigInteger("5")));
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.elementAt(i).compareTo(n) != 1) continue;
            return a.elementAt(i);
        }
        return a.lastElement();
    }

    public BigInteger prevprime(BigInteger n) {
        if (n.compareTo(BigInteger.ONE) <= 0) {
            return BigInteger.ZERO;
        }
        while (a.lastElement().compareTo(n) < 0) {
            this.growto(nMax.add(new BigInteger("5")));
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.elementAt(i).compareTo(n) < 0) continue;
            return a.elementAt(i - 1);
        }
        return a.lastElement();
    }

    protected void growto(BigInteger n) {
        while (nMax.compareTo(n) == -1) {
            nMax = nMax.add(BigInteger.ONE);
            boolean isp = true;
            for (int p = 0; p < a.size() && a.get(p).multiply(a.get(p)).compareTo(nMax) != 1; ++p) {
                if (nMax.remainder(a.get(p)).compareTo(BigInteger.ZERO) != 0) continue;
                isp = false;
                break;
            }
            if (!isp) continue;
            a.add(nMax);
        }
    }

    public static void main(String[] args) {
        Prime a = new Prime();
        int n = new Integer(args[0]);
        if (n >= 1) {
            if (n >= 2) {
                System.out.println("prime(" + (n - 1) + ") = " + a.at(n - 1));
            }
            System.out.println("prime(" + n + ") = " + a.at(n));
            System.out.println("prime(" + (n + 1) + ") = " + a.at(n + 1));
            System.out.println("pi(" + n + ") = " + a.pi(new BigInteger("" + n)));
        }
    }
}

