/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.converter.StringToMethodNameConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractHandler
extends DefaultHandler {
    private static final Logger log = LogManager.getLogger(AbstractHandler.class);
    protected LinkedList currentElement;

    @Override
    public void startDocument() throws SAXException {
        this.currentElement = new LinkedList();
    }

    public Object startElement(Object target, String uri, String localName, String qName, Attributes attributes) throws Throwable {
        String tagName = this.getElementName(localName, qName);
        this.currentElement.addLast(tagName);
        String methodName = this.toMethodName("start-" + tagName);
        try {
            Method method = target.getClass().getMethod(methodName, Properties.class);
            return method.invoke(target, this.attributesToProperties(attributes));
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalAccessException ex) {
            throw new SAXException("No esta permitido invocar el metodo " + methodName + " sobre el handler", ex);
        }
        catch (NoSuchMethodException ex) {
            throw ex;
        }
    }

    public Object endElement(Object target, String uri, String localName, String qName) throws Throwable {
        String methodName = this.toMethodName("end-" + this.getElementName(localName, qName));
        try {
            Method method = target.getClass().getMethod(methodName, new Class[0]);
            Object object = method.invoke(target, new Object[0]);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalAccessException ex) {
            throw new SAXException("No esta permitido invocar el metodo " + methodName + " sobre el handler", ex);
        }
        catch (NoSuchMethodException ex) {
            throw ex;
        }
        finally {
            this.currentElement.removeLast();
        }
    }

    public Object characters(Object target, char[] chars, int start, int length) throws Throwable {
        String localName = (String)this.currentElement.getLast();
        String text = new String(chars, start, length);
        String methodName = this.toMethodName("text-" + localName);
        try {
            Method method = target.getClass().getMethod(methodName, String.class);
            return method.invoke(target, text);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalAccessException ex) {
            throw new SAXException("No esta permitido invocar el metodo " + methodName + " sobre el handler", ex);
        }
        catch (NoSuchMethodException ex) {
            throw ex;
        }
    }

    @Override
    public void warning(SAXParseException p0) throws SAXException {
        log.warn("", (Throwable)p0);
    }

    @Override
    public void error(SAXParseException p0) throws SAXException {
        this.error("", p0);
    }

    @Override
    public void fatalError(SAXParseException p0) throws SAXException {
        this.fatalError("", p0);
        throw p0;
    }

    protected void warning(String msg) {
        log.warn(msg);
    }

    protected void error(String string, Throwable ex) {
        log.error(string, ex);
    }

    protected void fatalError(String msg, Throwable ex) {
        log.fatal(msg, ex);
    }

    protected String toMethodName(String t) {
        return StringToMethodNameConverter.convertTo(t);
    }

    protected String getElementName(String localName, String qName) {
        return localName.trim().length() > 0 ? localName : qName;
    }

    protected Properties attributesToProperties(Attributes att) {
        int count = att.getLength();
        Properties prop = new Properties();
        for (int i = 0; i < count; ++i) {
            String name = this.getElementName(att.getLocalName(i), att.getQName(i));
            String value = att.getValue(i);
            prop.setProperty(name, value);
        }
        return prop;
    }
}

