package ar.com.sdd.commons.util.converter;

//import ar.com.sdd.ebf.bo.instance.Instance;
//import ar.com.sdd.ebf.configuration.EBFConfiguration;

import javax.validation.constraints.NotNull;
import java.text.NumberFormat;
import java.text.ParseException;

/**
 * Parsea Doubles a String (con un formato standard)
 *
 * @author esteban@sdd
 * @date 28/08/2001
 * @deprecated Usar AmountToDoubleConverter (quizas)
 */
@Deprecated
public class StringToDoubleConverter implements DataConverter {
    static private StringToDoubleConverter instance = null;

    static private final int DIGITS = 2;
    static private final NumberFormat formater = NumberFormat.getNumberInstance();

    protected static StringToDoubleConverter getInstance() {
        if (instance == null) {
            instance = new StringToDoubleConverter();
        }
        return instance;
    }

    /*
    PARA IMPLEMENTAR @EBF
    public StringToDoubleConverter(@NotNull Instance instance) {
        this(EBFConfiguration.getInstance().getDecimalFormat(instance.getIdAsLong()) != null ? EBFConfiguration.getInstance().getDecimalFormat(instance.getIdAsLong()).getMaximumFractionDigits() : DIGITS);
    }
   */

    public StringToDoubleConverter() {
        this(DIGITS);
    }

    public StringToDoubleConverter(int scale) {
        formater.setMinimumFractionDigits(scale);
        formater.setMaximumFractionDigits(scale);
    }

    public static Double convertTo(String o) {
        return (Double) getInstance().convertDataTo(o);
    }

    public static String convertFrom(Double o) {
        return (String) getInstance().convertFromData(o);
    }

    public static String convertFrom(double o) {
        return (String) getInstance().convertFromData(new Double(o));
    }

    public Object convertDataTo(Object o) {
        return convertDataTo(o, null);
    }

    public Object convertDataTo(Object o, NumberFormat customPattern) {
        if ((o == null) || ((String) o).equals("")) {
            return null;
        }

        if (!(o instanceof String)) {
            throw new IllegalArgumentException("El objeto no es String");
        }

        String sNum = (String) o;
        Double num = null;
        try {
            num = new Double(customPattern != null ?
                    customPattern.parse(sNum).doubleValue() : formater.parse(sNum).doubleValue());
        } catch (ParseException ex) {
            throw new IllegalArgumentException("Formato del string invalido: [" + ex.getMessage() + "]");
        }

        return num;
    }

    public Object convertFromData(Object o) {
        if (o == null) {
            return null;
        }

        if (!(o instanceof Double)) {
            throw new IllegalArgumentException("El objeto a convertir no es Double: [" + o + "]");
        }

        Double num = (Double) o;
        return formater.format(num.doubleValue());
    }
}