/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.SynchronizedSimpleDateFormat;
import ar.com.sdd.commons.util.converter.DateToTimestampConverter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateUtil
implements Serializable {
    public static final Timestamp LOWER_TIMESTAMP = Timestamp.valueOf("1900-01-01 00:00:00.0");
    public static final Timestamp UPPER_TIMESTAMP = Timestamp.valueOf("3000-01-01 00:00:00.0");
    public static final String DATE_FORMAT_STRING = "dd/MM/yyyy";
    private static final String ORACLE_DATE_FORMAT_STRING = "dd/MM/yyyy";
    private static final String DATE_FORMAT_WITH_WEEKDAY_STRING = "EEEE dd/MM/yyyy";
    private static final String HOUR_FORMAT_STRING = "HH:mm:ss";
    private static final String ORACLE_HOUR_FORMAT_STRING = "HH24:MI:SS";
    public static final String ORACLE_DATEHOUR_FORMAT_STRING = "dd/MM/yyyy HH24:MI:SS";
    private static final Logger log = LogManager.getLogger(DateUtil.class);
    public static final String FORMAT_TIMESTAMP = "dd/MM/yyyy HH:mm:ss";
    public static final String FORMAT_TIMESTAMP_NO_SECONDS = "dd/MM/yyyy HH:mm";
    public static final String FORMAT_TIMESTAMP_NOSPACES = "yyyyMMddhhmmss";
    public static final String FORMAT_DATE_NOSPACES = "yyyyMMdd";
    public static final String DIAS_STRING = "dias";
    public static final String HORAS_STRING = "horas";
    public static final String HORASACUM_STRING = "horasAcum";
    public static final String MINUTOS_STRING = "minutos";
    public static final String MINUTOSACUM_STRING = "minutosAcum";
    public static final String SEGUNDOS_STRING = "segundos";
    public static final String SEGUNDOSACUM_STRING = "segundosAcum";
    public static final SimpleDateFormat sdf8601OnlyMinutes = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    public static final SimpleDateFormat sdf8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final SimpleDateFormat sdf8601NoTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String DATE_JSON_FORMAT_STRING = "yyyy-MM-dd";
    private static final String DATE_JSON_FORMAT_STRING_NODASH = "yyyyMMdd";
    public static final String DRT_ISSUE_DATE_RANGE_DAYS_MTD = "01/MM";
    public static final String DRT_ISSUE_DATE_RANGE_DAYS_YTD = "01/YYYY";
    public static final String DRT_ISSUE_DATE_RANGE_DAYS_MONTHS = "M:";

    public static java.util.Date incrDateDays(java.util.Date d, int numDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(5, numDays);
        return calendar.getTime();
    }

    public static java.util.Date incrDateDaysLaV(java.util.Date d, int numDays) {
        Calendar calend = Calendar.getInstance();
        calend.setTime(d);
        int delta = 1;
        if (numDays < 0) {
            delta = -1;
            numDays = -numDays;
        }
        int dayCounter = 0;
        while (numDays > dayCounter) {
            calend.add(5, delta);
            if (calend.get(7) == 7 || calend.get(7) == 1) continue;
            ++dayCounter;
        }
        return calend.getTime();
    }

    public static java.util.Date incrDateDays(String date, String numDays) {
        if (StringUtil.isEmpty(date)) {
            return null;
        }
        Date d = DateUtil.parseDate(date);
        if (StringUtil.isEmpty(numDays)) {
            return d;
        }
        Integer days = Integer.parseInt(numDays);
        return DateUtil.incrDateDays(d, days);
    }

    public static java.util.Date subsDateDays(String date, String numDays) {
        if (StringUtil.isEmpty(date)) {
            return null;
        }
        Date d = DateUtil.parseDate(date);
        if (StringUtil.isEmpty(numDays)) {
            return d;
        }
        Integer days = Integer.parseInt(numDays);
        return DateUtil.incrDateDays(d, -days.intValue());
    }

    public static java.util.Date truncDateTime(java.util.Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date truncDateTimeToHour(java.util.Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date lastSecondOf(java.util.Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date truncDateTime(Timestamp t) {
        if (t == null) {
            return null;
        }
        return DateUtil.truncDateTime(DateToTimestampConverter.convertFrom(t));
    }

    public static java.util.Date truncDateToQuarter(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) / 3 * 3);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static java.util.Date truncDateToSemester(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) / 6 * 6);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static boolean isEmpty(java.util.Date o) {
        return o == null;
    }

    public static String getFormat() {
        return "dd/MM/yyyy";
    }

    public static String getOracleDateFormat() {
        return "dd/MM/yyyy";
    }

    public static String getHourFormat() {
        return HOUR_FORMAT_STRING;
    }

    public static String getOracleHourFormat() {
        return ORACLE_HOUR_FORMAT_STRING;
    }

    public static String getDateFormatWithWeekday() {
        return DATE_FORMAT_WITH_WEEKDAY_STRING;
    }

    public static String dateToString(Date d) {
        SynchronizedSimpleDateFormat formatDate = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
        String strDate = null;
        if (d != null) {
            strDate = formatDate.format(d);
        }
        return strDate;
    }

    public static String dateToString(java.util.Date d) {
        SynchronizedSimpleDateFormat formatDate = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
        String strDate = d != null ? formatDate.format(d) : null;
        return strDate;
    }

    public static String dateToString(java.util.Date d, String dateFormat) {
        return DateUtil.dateToString(d, dateFormat, null);
    }

    public static String dateToString(java.util.Date d, String dateFormat, Locale locale) {
        SynchronizedSimpleDateFormat df = locale != null ? new SynchronizedSimpleDateFormat(dateFormat, locale) : new SynchronizedSimpleDateFormat(dateFormat);
        return d != null ? df.format(d) : null;
    }

    public static String format(java.util.Date date, String format) {
        return DateUtil.dateToString(date, format);
    }

    public static String format(java.util.Date date) {
        return DateUtil.dateToString(date, DateUtil.getFormat());
    }

    public static String format(java.util.Date date, String format, Locale locale) {
        return DateUtil.dateToString(date, format, locale);
    }

    public static Date parseDate(String strDate) {
        if (StringUtil.isEmpty((String)strDate)) {
            return null;
        }
        if (((String)(strDate = ((String)strDate).replace('.', '/').replace('-', '/'))).length() - ((String)strDate).lastIndexOf(47) == 3) {
            strDate = ((String)strDate).substring(0, ((String)strDate).lastIndexOf(47)) + "/20" + ((String)strDate).substring(((String)strDate).lastIndexOf(47) + 1);
        }
        SynchronizedSimpleDateFormat formatDate = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
        Date d = null;
        try {
            java.util.Date auxDate = formatDate.parse((String)strDate);
            d = new Date(auxDate.getTime());
        }
        catch (ParseException pe) {
            log.error("parseDate() - ParseException: " + pe.getMessage());
        }
        catch (Exception e) {
            log.error("parseDate() - Exception: " + e.getMessage());
        }
        return d;
    }

    public static java.util.Date parseDate(String strDate, String pattern) {
        return DateUtil.parseDate(strDate, pattern, null);
    }

    public static java.util.Date parseDate(String strDate, String pattern, Locale locale) {
        if (strDate == null || strDate.trim().equals("")) {
            return null;
        }
        if (StringUtil.isEmpty(pattern)) {
            pattern = "dd/MM/yyyy";
        }
        java.util.Date result = null;
        try {
            if (pattern.equals("E dd/MM/yyyy")) {
                pattern = "dd/MM/yyyy";
                strDate = StringUtil.fromToParser(strDate, "-10:0");
            }
            SynchronizedSimpleDateFormat sdf = null;
            sdf = locale != null ? new SynchronizedSimpleDateFormat(pattern, locale) : new SynchronizedSimpleDateFormat(pattern);
            result = sdf.parse(strDate);
        }
        catch (ParseException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return result;
    }

    public static String toQueryDate(java.util.Date d) {
        return DateUtil.toQueryDate(new Date(d.getTime()));
    }

    public static String toQueryDate(Date d) {
        String dateStr = "TO_DATE('" + DateUtil.dateToString(d) + "', '" + DateUtil.getFormat() + "')";
        return dateStr;
    }

    public static java.util.Date add(java.util.Date d, int days, boolean skipSaturday, boolean skipSunday) {
        Calendar calend = Calendar.getInstance();
        calend.setTime(d);
        if (skipSaturday || skipSunday) {
            int delta = 1;
            if (days < 0) {
                delta = -1;
                days = -days;
            }
            while (days > 0) {
                calend.add(5, delta);
                if (skipSaturday && calend.get(7) == 7 || skipSunday && calend.get(7) == 1) continue;
                --days;
            }
        } else {
            calend.add(5, days);
        }
        java.util.Date newDate = calend.getTime();
        return newDate;
    }

    public static java.util.Date add(java.util.Date d, int days, boolean skipWeekends) {
        return DateUtil.add(d, days, skipWeekends, skipWeekends);
    }

    public static java.util.Date add(java.util.Date d, int days) {
        return DateUtil.add(d, days, false, false);
    }

    public static java.util.Date addMonth(java.util.Date d, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static java.util.Date addYear(java.util.Date d, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static java.util.Date addHours(java.util.Date d, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static java.util.Date addMinutes(java.util.Date d, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(12, minutes);
        return calendar.getTime();
    }

    public static java.util.Date addSeconds(java.util.Date d, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static int daysDiference(java.util.Date d1, java.util.Date d2) {
        if (d1 == null || d2 == null) {
            throw new ApplicationException("Alguna de las fechas es nula d1=" + d1 + " d2=" + d2);
        }
        long fechaInicialMs = d1.getTime();
        long fechaFinalMs = d2.getTime();
        long diferencia = fechaInicialMs - fechaFinalMs;
        double dias = Math.floor(diferencia / 86400000L);
        return (int)dias;
    }

    public static int daysBetween(java.util.Date d1, java.util.Date d2, boolean skipSaturday, boolean skipSunday) {
        if (d1.after(d2)) {
            return -DateUtil.daysBetween(d2, d1, skipSaturday, skipSunday);
        }
        int result = 0;
        if (skipSunday || skipSaturday) {
            while (d1.before(d2)) {
                d1 = DateUtil.add(d1, 1, skipSaturday, skipSunday);
                ++result;
            }
        } else {
            result = DateUtil.daysDiference(d2, d1);
        }
        return result;
    }

    public static int daysBetween(java.util.Date d1, java.util.Date d2) {
        return DateUtil.daysBetween(d1, d2, false, false);
    }

    public static int daysDue(java.util.Date d1, java.util.Date d2) {
        if (d1.after(d2)) {
            return 0;
        }
        return DateUtil.daysBetween(d1, d2, false, false);
    }

    public static java.util.Date applyTimeZone(java.util.Date source, String sourceTzId, String targetTzId) {
        Calendar sourceCal = Calendar.getInstance(TimeZone.getTimeZone(sourceTzId));
        GregorianCalendar targetCal = new GregorianCalendar(TimeZone.getTimeZone(targetTzId));
        targetCal.setTime(source);
        long offsetDif = sourceCal.getTimeZone().getRawOffset() - targetCal.getTimeZone().getRawOffset();
        targetCal.setTimeInMillis(targetCal.getTimeInMillis() - offsetDif);
        return targetCal.getTime();
    }

    public static String formatByTimeZone(java.util.Date source, String sourceTzId, String targetTzId, String pattern) {
        java.util.Date result = DateUtil.applyTimeZone(source, sourceTzId, targetTzId);
        return DateUtil.dateToString(result, pattern);
    }

    public static String formatByTimeZone(String source, String sourceTzId, String targetTzId, String pattern) {
        java.util.Date result = DateUtil.applyTimeZone(DateUtil.parseDate(source, pattern), sourceTzId, targetTzId);
        return DateUtil.dateToString(result, pattern);
    }

    public static Map<String, Long> getDiferencia(java.util.Date fechaMayor, java.util.Date fechaMenor) {
        HashMap<String, Long> resultadoMap = new HashMap<String, Long>();
        long dias = 0L;
        if (fechaMayor.before(fechaMenor)) {
            java.util.Date temp = new java.util.Date(fechaMenor.getTime());
            fechaMenor = new java.util.Date(fechaMayor.getTime());
            fechaMayor = new java.util.Date(temp.getTime());
        }
        long diferenciaMils = fechaMayor.getTime() - fechaMenor.getTime();
        long segundos = diferenciaMils / 1000L;
        resultadoMap.put(SEGUNDOSACUM_STRING, segundos);
        long minutos = segundos / 60L;
        resultadoMap.put(MINUTOSACUM_STRING, minutos);
        long horas = segundos / 3600L;
        resultadoMap.put(HORASACUM_STRING, horas);
        minutos = (segundos -= horas * 3600L) / 60L;
        segundos -= minutos * 60L;
        if (horas > 24L) {
            dias = (int)Math.floor(horas / 24L);
            horas -= dias * 24L;
        }
        resultadoMap.put(DIAS_STRING, dias);
        resultadoMap.put(HORAS_STRING, horas);
        resultadoMap.put(MINUTOS_STRING, minutos);
        resultadoMap.put(SEGUNDOS_STRING, segundos);
        return resultadoMap;
    }

    public static Long getDiferenciaMinutos(java.util.Date fechaMayor, java.util.Date fechaMenor) {
        return DateUtil.getDiferencia(fechaMayor, fechaMenor).get(MINUTOSACUM_STRING);
    }

    public static Long getDiferenciaSegundos(java.util.Date fechaMenor) {
        return DateUtil.getDiferencia(new java.util.Date(), fechaMenor).get(SEGUNDOSACUM_STRING);
    }

    public static Long getElapsedMillis(java.util.Date fechaReferencia) {
        return DateUtil.now().getTime() - fechaReferencia.getTime();
    }

    public static Long getElapsedSegundos(java.util.Date fechaReferencia) {
        return DateUtil.getElapsedMillis(fechaReferencia) / 1000L;
    }

    public static Long getElapsedMinutos(java.util.Date fechaReferencia) {
        return DateUtil.getElapsedMillis(fechaReferencia) / 1000L / 60L;
    }

    public static java.util.Date getPrimerDiaDelMes(java.util.Date date) {
        return DateUtil.getPrimerDiaDelMes(date, false);
    }

    public static java.util.Date getPrimerDiaDelMes(java.util.Date date, boolean onlyHabil) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(DateUtil.truncDateTime(date));
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (onlyHabil) {
            int dow = cal.get(7);
            if (dow == 7) {
                cal.set(5, 3);
            } else if (dow == 1) {
                cal.set(5, 2);
            }
        }
        return cal.getTime();
    }

    public static java.util.Date getPrimerDiaDelMesActual() {
        return DateUtil.getPrimerDiaDelMes(new java.util.Date());
    }

    public static java.util.Date getPrimerDiaDelMesActual(boolean onlyHabil) {
        return DateUtil.getPrimerDiaDelMes(new java.util.Date(), onlyHabil);
    }

    public static java.util.Date getPrimerDiaDelMes(int cantMeses) {
        return DateUtil.getPrimerDiaDelMes(DateUtil.addMonth(new java.util.Date(), cantMeses));
    }

    public static java.util.Date getPrimerDiaDelMes(int cantMeses, boolean onlyHabil) {
        return DateUtil.getPrimerDiaDelMes(DateUtil.addMonth(new java.util.Date(), cantMeses), onlyHabil);
    }

    public static java.util.Date getUltimoDiaDelMes(java.util.Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1), cal.get(2), cal.getActualMaximum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getUltimoDiaDelMesActual() {
        return DateUtil.getUltimoDiaDelMes(new java.util.Date());
    }

    public static java.util.Date getUltimoDiaDelMes(int cantMeses) {
        return DateUtil.getUltimoDiaDelMes(DateUtil.addMonth(new java.util.Date(), cantMeses));
    }

    public static java.util.Date getUltimoDiaDelMesPrevio(java.util.Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getUltimoSegundoDelDia() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.today());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getUltimoDiaDelMesPrevio() {
        return DateUtil.getUltimoDiaDelMesPrevio(new java.util.Date());
    }

    public static int getMes(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal.get(2);
    }

    public static int getMesActual() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2);
    }

    public static int getYearActual() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static java.util.Date getPrimerDiaDelAnio(java.util.Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(DateUtil.truncDateTime(date));
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getUltimoDiaDelAnio(java.util.Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(DateUtil.truncDateTime(date));
        cal.set(5, 31);
        cal.set(2, 11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getPrimerDiaDelAnioActual() {
        return DateUtil.getPrimerDiaDelAnio(new java.util.Date());
    }

    public static java.util.Date getUltimoDiaDelAnioActual() {
        return DateUtil.getUltimoDiaDelAnio(new java.util.Date());
    }

    public static int safeCompareTo(java.util.Date d1, java.util.Date d2) {
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        return d1.compareTo(d2);
    }

    public static boolean between(java.util.Date dateToEval, java.util.Date dateFrom, java.util.Date dateTo) {
        return DateUtil.after(dateToEval, dateFrom) && DateUtil.before(dateToEval, dateTo);
    }

    public static boolean betweenOrEquals(java.util.Date dateToEval, java.util.Date dateFrom, java.util.Date dateTo) {
        return DateUtil.afterOrEquals(dateToEval, dateFrom) && DateUtil.beforeOrEquals(dateToEval, dateTo);
    }

    public static boolean before(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = fecha1.before(fecha2);
        }
        return result;
    }

    public static boolean before(java.util.Date fecha1, String fecha2_DATE_FORMAT_STRING) {
        return DateUtil.before(fecha1, DateUtil.parseDate(fecha2_DATE_FORMAT_STRING));
    }

    public static boolean beforeOrEquals(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = fecha1.before(fecha2) || fecha1.equals(fecha2);
        }
        return result;
    }

    public static boolean beforeOrEquals(java.util.Date fecha1, String fecha2_DATE_FORMAT_STRING) {
        return DateUtil.beforeOrEquals(fecha1, DateUtil.parseDate(fecha2_DATE_FORMAT_STRING));
    }

    public static boolean equals(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = DateUtils.isSameDay((java.util.Date)fecha1, (java.util.Date)fecha2);
        }
        return result;
    }

    public static boolean after(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = fecha1.after(fecha2);
        }
        return result;
    }

    public static boolean afterN(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = fecha1.after(fecha2);
        } else if (fecha1 != null) {
            return true;
        }
        return result;
    }

    public static boolean after(java.util.Date fecha1, String fecha2_DATE_FORMAT_STRING) {
        return DateUtil.after(fecha1, DateUtil.parseDate(fecha2_DATE_FORMAT_STRING));
    }

    public static boolean afterOrEquals(java.util.Date fecha1, java.util.Date fecha2) {
        boolean result = false;
        if (fecha1 != null && fecha2 != null) {
            result = fecha1.after(fecha2) || fecha1.equals(fecha2);
        }
        return result;
    }

    public static boolean afterOrEquals(java.util.Date fecha1, String fecha2_DATE_FORMAT_STRING) {
        return DateUtil.afterOrEquals(fecha1, DateUtil.parseDate(fecha2_DATE_FORMAT_STRING));
    }

    public static java.util.Date menorFecha(java.util.Date ... fechas) {
        java.util.Date menor = null;
        if (fechas != null) {
            for (java.util.Date fecha : fechas) {
                if (fecha == null || menor != null && !menor.after(fecha)) continue;
                menor = fecha;
            }
        }
        return menor;
    }

    public static java.util.Date notAfterToday(java.util.Date fecha) {
        return DateUtil.menorFecha(fecha, DateUtil.today());
    }

    public static java.util.Date notBeforeToday(java.util.Date fecha) {
        return DateUtil.mayorFecha(fecha, DateUtil.today());
    }

    public static java.util.Date mayorFecha(java.util.Date ... fechas) {
        java.util.Date mayor = null;
        if (fechas != null) {
            for (java.util.Date fecha : fechas) {
                if (fecha == null || mayor != null && !mayor.before(fecha)) continue;
                mayor = fecha;
            }
        }
        return mayor;
    }

    public static java.util.Date nvl(java.util.Date ... fechas) {
        if (fechas != null) {
            for (java.util.Date fecha : fechas) {
                if (fecha == null) continue;
                return fecha;
            }
        }
        return null;
    }

    public static String secondsToTime(long seconds) {
        return DateUtil.millisecondsToTime(seconds * 1000L);
    }

    public static String millisecondsToTime(long milliseconds) {
        SynchronizedSimpleDateFormat sdf = new SynchronizedSimpleDateFormat(HOUR_FORMAT_STRING);
        try {
            java.util.Date baseTime = sdf.parse("00:00:00");
            java.util.Date time = new java.util.Date(baseTime.getTime() + milliseconds);
            return sdf.format(time);
        }
        catch (ParseException e) {
            return "00:00:00";
        }
    }

    public static String getTimeDifferenceBucket(java.util.Date startDate, java.util.Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        long diffMillis = Math.abs(endDate.getTime() - startDate.getTime());
        if (diffMillis < 3600000L) {
            long mi = TimeUnit.MILLISECONDS.toMinutes(diffMillis);
            return mi + " min.";
        }
        if (diffMillis < 86400000L) {
            long hs;
            return hs + ((hs = TimeUnit.MILLISECONDS.toHours(diffMillis)) == 1L ? "h." : " hs.");
        }
        if (diffMillis < 604800000L) {
            long dd;
            return dd + ((dd = TimeUnit.MILLISECONDS.toDays(diffMillis)) == 1L ? " dia" : " dias");
        }
        SynchronizedSimpleDateFormat formatDate = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
        return formatDate.format(startDate);
    }

    public static java.util.Date buildDate(int year, int month, int date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(year, month, date, 0, 0, 0);
        return cal.getTime();
    }

    public static java.util.Date someFutureDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.set(5, 31);
        calendar.set(2, 11);
        calendar.add(1, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date someFarFutureDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.set(5, 31);
        calendar.set(2, 11);
        calendar.add(1, 10);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date someFarPastDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.add(1, -10);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date dueDateOrNextMonth(java.util.Date dueDate) {
        if (dueDate == null || DateUtil.before(dueDate, DateUtil.today())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.today());
            calendar.add(2, 1);
            return calendar.getTime();
        }
        return DateUtil.truncDateTime(dueDate);
    }

    public static java.util.Date yesterday() {
        return DateUtil.truncDateTime(DateUtil.add(new java.util.Date(), -1));
    }

    public static java.util.Date today() {
        return DateUtil.truncDateTime(new java.util.Date());
    }

    public static java.util.Date tomorrow() {
        return DateUtil.truncDateTime(DateUtil.add(new java.util.Date(), 1));
    }

    public static java.util.Date now() {
        return new java.util.Date();
    }

    public static java.util.Date parseDateSimple(String date) {
        return DateUtil.parseDateSimple(date, "dd/MM/yyyy");
    }

    public static java.util.Date parseDateSimple(String date, String format) {
        SynchronizedSimpleDateFormat sdf = new SynchronizedSimpleDateFormat(format);
        java.util.Date result = null;
        try {
            result = sdf.parse(date);
        }
        catch (ParseException e) {
            log.error("Error al parsear la fecha [" + date + "]", (Throwable)e);
        }
        return result;
    }

    public static String formatDateSimple(java.util.Date date) {
        return DateUtil.format(date, "dd/MM/yyyy");
    }

    public static java.util.Date iso8601OnlyMinutesToDate(String iso8601string) throws ParseException {
        String s = iso8601string.replace("Z", "+0000");
        return sdf8601OnlyMinutes.parse(s);
    }

    public static java.util.Date iso8601OnlyMinutesToDate(String iso8601string, String gmtHHshift) throws ParseException {
        String s = iso8601string.replace("Z", gmtHHshift + "00");
        return sdf8601OnlyMinutes.parse(s);
    }

    public static boolean isValidDate(String date) {
        return DateUtil.isValidDate(date, "dd/MM/yyyy");
    }

    public static boolean isValidDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        try {
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static java.util.Date getValidDate(String date) {
        return DateUtil.getValidDate(date, "dd/MM/yyyy");
    }

    public static java.util.Date getValidDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatJsonDate(java.util.Date date) {
        return DateUtil.format(date, DATE_JSON_FORMAT_STRING);
    }

    public static java.util.Date parseJsonDate(String date) {
        if (date == null) {
            return null;
        }
        if (date.length() == 8) {
            return DateUtil.parseDate(date, "yyyyMMdd");
        }
        return DateUtil.parseDate(date, DATE_JSON_FORMAT_STRING);
    }

    public static int monthsBetweenDates(java.util.Date startDate, java.util.Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        int monthsBetween = 0;
        int dateDiff = end.get(5) - start.get(5);
        if (dateDiff < 0) {
            int borrrow = end.getActualMaximum(5);
            dateDiff = end.get(5) + borrrow - start.get(5);
            --monthsBetween;
            if (dateDiff > 0) {
                ++monthsBetween;
            }
        } else {
            ++monthsBetween;
        }
        monthsBetween += end.get(2) - start.get(2);
        return monthsBetween += (end.get(1) - start.get(1)) * 12;
    }

    public static int yearsBetweenDates(java.util.Date startDate, java.util.Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        int diff = end.get(1) - start.get(1);
        if (start.get(2) > end.get(2) || start.get(2) == end.get(2) && start.get(5) > end.get(5)) {
            --diff;
        }
        return diff;
    }

    public static LocalDate parseToLocalDate(java.util.Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public LocalDate parseToLocalDateViaSqlDate(java.util.Date dateToConvert) {
        return new Date(dateToConvert.getTime()).toLocalDate();
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(formatter);
    }

    public static String formatLocalDate(LocalDate localDate) {
        return DateUtil.formatLocalDate(localDate, "dd/MM/yyyy");
    }

    public static LocalDateTime toLocalDateTime(java.util.Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static java.util.Date convertLocalDateToDate(LocalDate dateToConvert) {
        return java.util.Date.from(dateToConvert.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static List<Pair<java.util.Date, java.util.Date>> getDateInBatches(java.util.Date fromDate, java.util.Date toDate, Integer batchSizeDays) {
        ArrayList<Pair<java.util.Date, java.util.Date>> result = new ArrayList<Pair<java.util.Date, java.util.Date>>();
        if (batchSizeDays != null && batchSizeDays > 0 && fromDate != null && toDate != null) {
            int daysBetween = DateUtil.daysBetween(fromDate, toDate);
            if (daysBetween > batchSizeDays) {
                java.util.Date startDate = new java.util.Date(fromDate.getTime());
                while (daysBetween > batchSizeDays) {
                    result.add((Pair<java.util.Date, java.util.Date>)new ImmutablePair((Object)startDate, (Object)DateUtils.addDays((java.util.Date)startDate, (int)(batchSizeDays - 1))));
                    daysBetween -= batchSizeDays.intValue();
                    startDate = DateUtils.addDays((java.util.Date)startDate, (int)batchSizeDays);
                }
                result.add((Pair<java.util.Date, java.util.Date>)new ImmutablePair((Object)startDate, (Object)toDate));
            } else {
                result.add((Pair<java.util.Date, java.util.Date>)new ImmutablePair((Object)fromDate, (Object)toDate));
            }
        } else {
            result.add((Pair<java.util.Date, java.util.Date>)new ImmutablePair((Object)fromDate, (Object)toDate));
        }
        return result;
    }

    public static String getMesComoLetra(java.util.Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return Character.toString(65 + month);
    }

    public static String getMesComoNumeroYLetra(java.util.Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2) + 1;
        if (month <= 9) {
            return "" + month;
        }
        return Character.toString(65 + (month - 10));
    }

    public static boolean nowIsAfter(String time) {
        return !StringUtil.isEmptyNull(time) && LocalTime.now().isAfter(LocalTime.parse(time));
    }

    public static boolean nowIsBefore(String time) {
        return !StringUtil.isEmptyNull(time) && LocalTime.now().isBefore(LocalTime.parse(time));
    }

    public static java.util.Date fixToPeriodoSAP(java.util.Date date) {
        return DateUtil.fixToPeriodoSAP(date, true);
    }

    public static java.util.Date fixToPeriodoSAP(java.util.Date date, boolean useOnlyDiasHabiles) {
        if (date == null) {
            return null;
        }
        java.util.Date today = DateUtil.today();
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        if (DateUtil.afterOrEquals(DateUtil.getPrimerDiaDelMes(date, false), DateUtil.getPrimerDiaDelMesActual(false))) {
            return date;
        }
        if (DateUtil.beforeOrEquals(today, DateUtil.getPrimerDiaDelMesActual(useOnlyDiasHabiles)) && currentHour < 12) {
            return DateUtil.getUltimoDiaDelMesPrevio(new java.util.Date());
        }
        return DateUtil.getPrimerDiaDelMesActual(useOnlyDiasHabiles);
    }
}

