/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimerUtil {
    private static final Logger log = LogManager.getLogger(TimerUtil.class);
    private long timeStart;
    private Level level;
    private Map<String, TimerUtil> times = new HashMap<String, TimerUtil>();

    public TimerUtil() {
        this.timeStart = System.currentTimeMillis();
    }

    public TimerUtil(Level level) {
        this.timeStart = System.currentTimeMillis();
        this.level = level;
    }

    public void start(String key) {
        this.times.put(key, new TimerUtil());
    }

    public void stopAndLog(String key) {
        TimerUtil timer = this.times.get(key);
        String logString = "Tiempo transcurrido para " + key + "=" + timer.timerElapsed() + "ms";
        if (this.level.equals((Object)Level.DEBUG)) {
            log.debug(logString);
        } else if (this.level.equals((Object)Level.TRACE)) {
            log.trace(logString);
        } else if (this.level.equals((Object)Level.INFO)) {
            log.info(logString);
        } else {
            log.error("Level invalido:" + this.level);
        }
        this.times.remove(key);
    }

    public void timerStart() {
        this.timeStart = System.currentTimeMillis();
    }

    public long timerElapsed() {
        return System.currentTimeMillis() - this.timeStart;
    }

    public void showTimestamp(String label) {
    }
}

