/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.lineparser;

import ar.com.sdd.commons.util.lineparser.LineParser;
import ar.com.sdd.commons.util.lineparser.LineParserException;

public class FixedLineParser
extends LineParser {
    protected int recordLength;
    protected int[] fieldOffsets;

    public FixedLineParser(String[] fieldNames, int recordLength, int[] fieldOffsets) {
        super(fieldNames);
        this.recordLength = recordLength;
        this.fieldOffsets = fieldOffsets;
        if (fieldNames.length != fieldOffsets.length) {
            throw new RuntimeException("Error durante creacion del FixedLineParser: ambos arrays deben tener la misma longitud!");
        }
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getFieldOffset(int i) {
        int offset = 0 <= i && i < this.getNumOfFields() ? this.fieldOffsets[i] : -1;
        return offset;
    }

    public int getFieldOffset(String fieldName) {
        int idx = this.getFieldIndex(fieldName);
        int offset = idx != -1 ? this.fieldOffsets[idx] : -1;
        return offset;
    }

    @Override
    public void parse(String lineBuffer) throws LineParserException {
        int lastField = this.getNumOfFields() - 1;
        for (int i = 0; i < this.getNumOfFields(); ++i) {
            int offset = this.fieldOffsets[i];
            int nextOffset = i < lastField ? this.fieldOffsets[i + 1] : this.recordLength;
            int fieldLength = nextOffset - offset;
            String fieldValue = lineBuffer.substring(offset, offset + fieldLength);
            this.fieldValues[i] = fieldValue.trim();
        }
    }
}

