/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesUtil {
    private static final Logger log = LogManager.getLogger(PropertiesUtil.class);
    public static final String DEFAULT_SEPARATOR = "\r\n";
    Properties prop = new Properties();

    public PropertiesUtil() {
    }

    public PropertiesUtil(String serializedProperties) {
        this.readProperties(serializedProperties);
    }

    public String getProperty(String name) {
        return this.prop.getProperty(name);
    }

    public String getStringProperty(String name) {
        return this.getProperty(name);
    }

    public boolean getBooleanProperty(String name) {
        String value = this.getProperty(name);
        return !StringUtil.isEmpty(value) && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("verdadero"));
    }

    public boolean getBooleanProperty(String name, boolean defaultIfUndefined) {
        String value = this.getProperty(name);
        if (StringUtil.isEmptyNull(value)) {
            return defaultIfUndefined;
        }
        return value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("verdadero");
    }

    public void setProperty(String name, String value) {
        this.prop.setProperty(name, value);
        this.storeProperties();
    }

    public void readProperties(String serializedProperties) {
        if (serializedProperties != null && !serializedProperties.equals("")) {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedProperties.getBytes());
            try {
                this.prop.load(bais);
            }
            catch (IOException ex) {
                log.debug("EXCEP  ---- PropertiesUtil.getProperties: IOException");
                throw new ApplicationException(ex);
            }
        }
    }

    public String storeProperties() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.prop.store(baos, "");
        }
        catch (Exception e) {
            log.error("Ocurrio un error al intentar convertir las properties en un string", (Throwable)e);
        }
        String result = baos.toString();
        try {
            baos.close();
        }
        catch (IOException e) {
            log.error("Error al cerrar el stream", (Throwable)e);
        }
        return result;
    }

    public static String getProperty(String properties, String propertyKey) {
        Collection<String> propertiesVec = StringUtil.parseString(properties, ",");
        for (String prop : propertiesVec) {
            ArrayList components = (ArrayList)StringUtil.parseString(prop, "=");
            String key = (String)components.get(0);
            if (!key.equals(propertyKey) || components.size() <= 1) continue;
            return (String)components.get(1);
        }
        return null;
    }

    public static Collection<String> getPropertiesName(String properties) {
        ArrayList<String> propertiesName = new ArrayList<String>();
        Collection<String> propertiesVec = StringUtil.parseString(properties, ",");
        for (String prop : propertiesVec) {
            Collection<String> components = StringUtil.parseString(prop, "=");
            propertiesName.add((String)components.toArray()[0]);
        }
        return propertiesName;
    }

    public boolean isEmpty() {
        return this.prop == null || this.prop.isEmpty();
    }

    public Collection<String> keys() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.prop != null) {
            Enumeration<Object> e = this.prop.keys();
            while (e.hasMoreElements()) {
                String value = (String)e.nextElement();
                ret.add(value);
            }
        }
        return ret;
    }

    public void merge(Properties propToMerge) {
        Enumeration<Object> keys = propToMerge.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.prop.setProperty(key, propToMerge.getProperty(key));
        }
    }

    public static String encodeEnters(String propertyValue) {
        if (StringUtil.isEmptyNull(propertyValue)) {
            return propertyValue;
        }
        return propertyValue.replaceAll("\\n", "_ESCPENTER_").replaceAll("\\r", "");
    }

    public static String decodeEnters(String propertyValue) {
        if (StringUtil.isEmptyNull(propertyValue)) {
            return propertyValue;
        }
        return propertyValue.replaceAll("_ESCPENTER_", "\n");
    }

    public Properties getProps() {
        return this.prop;
    }
}

