package ar.com.sdd.commons.util.file;


/**
 * Condicion de aceptacion para filtro para FileNameFilter.
 * Nota: solo es obligatorio aceptar *una* de estas.
 * @author Andres Ferrari
 */
public class FilterOptionCondition extends FilterCondition {

	private String filterString;
	private int matchType;
	private boolean ignoreCase = true;

	//-----------------------------------------------------------------------------//


	/**
	 * Crea una condicion de filtro.
	 *
	 * @param filterString String que se quiere matchear.
	 * @param matchType Tipo de matcheo: { MATCH_START, MATCH_END, MATCH_CONTAINS }
	 * @param ignoreCase
	 */
	public FilterOptionCondition(String filterString, int matchType, boolean ignoreCase) {
		this.filterString = filterString;
		this.matchType    = matchType;
		this.ignoreCase	  = ignoreCase;
	}

	/**
	 * Crea una condicion de filtro.
	 *
	 * @param filterString String que se quiere matchear.
	 * @param matchType Tipo de matcheo: { MATCH_START, MATCH_END, MATCH_CONTAINS }
	 */
	public FilterOptionCondition(String filterString, int matchType) {
		this(filterString, matchType, true); //por default no es case sensitive
	}

	public String getFilterString() { return filterString; }
	
	public int getMatchType() { return matchType; }

	public boolean getIgnoreCase() { return ignoreCase; }

	public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
	}

	
}
