package ar.com.sdd.commons.util.id;

import java.math.BigDecimal;

/**
 * Primary key generica para beans que tienen como clave un campo <b>id</b>
 * de tipo Long (SUN_ONE_7: previamente era "entero").
 * <p>
 * Esta clase permite convertir PK de y hacia <b>long</b>, <code>Long</code>,
 * <code>ar.com.sdd.ebpp.bo.type.Id</code> y <code>java.math.BigDecimal</code>
 *
 * 28/03/2003: modificado por Andres Ferrari para compatibilidad con Sun ONE AppServer7.
 *				Se eliminaron la variable id y todas sus referencias, y se agregaron
 *				getters y setters abstractos que asumen que id es de tipo Long.
 *				Por un conflicto de nombres con IdPK, se llaman getLongId() y setLongId().
 */
public abstract class NumberIdPK implements java.io.Serializable {

	private static final long serialVersionUID = 9118737011361309243L;

	// SUN_ONE_7
    //public long id;
    public abstract Long getLongId();
    public abstract void setLongId(long id);
    public abstract void setLongId(Long id);

    public NumberIdPK() {}

    public NumberIdPK(long id) {
    	// SUN_ONE_7
    	//this.id = id;
        setLongId(id);
    }

    /**
     * Construye una primary key a partir de un Id. Si el Id es <b>null</b> se
     * arroja una IllegalArgumentException
     * @param id Representa el valor que debe tener la primary key (no puede ser <b>null</b>).
     */
    public NumberIdPK(NumberId id) {
        if (id != null) {
            // SUN_ONE_7
            //this.id = id.longValue();
            setLongId(id.longValue());
        } else {
            throw new IllegalArgumentException("No se puede construir una " + this.getClass().getName() + " a partir de [" + id +"]");
        }
    }


    /**
     * Construye una primary key a partir de un Long. Si es <b>null</b> se
     * arroja una IllegalArgumentException
     * @param id Representa el valor que debe tener la primary key (no puede ser <b>null</b>).
     */
    public NumberIdPK(Long id) {
        if (id != null) {
			// SUN_ONE_7        	
            //this.id = id.longValue();
            setLongId(id.longValue());
        } else {
            throw new IllegalArgumentException("No se puede construir una " + this.getClass().getName() + " a partir de [" + id +"]");
        }

    }

    /**
     * Construye una primary key a partir de un BigDecimal. Si es <b>null</b> se
     * arroja una IllegalArgumentException
     * @param id Representa el valor que debe tener la primary key (no puede ser <b>null</b>).
     */
    public NumberIdPK(BigDecimal id) {
        if (id != null) {
   			// SUN_ONE_7        	
            //this.id = id.longValue();
            setLongId(id.longValue());
        } else {
            throw new IllegalArgumentException("No se puede construir una " + this.getClass().getName() + " a partir de [" + id +"]");
        }

    }


    /**
     * Devuelve un Long con el mismo valor que esta primary key
     */
    public Long getLong() {
    	// SUN_ONE_7
        //return new Long(id);
        return getLongId();
    }

    /**
     * Devuelve un BigDecimal con el mismo valor que esta primary key
     */
    public BigDecimal getBigDecimal() {
    	// SUN_ONE_7
        //return new BigDecimal(id);
        return new BigDecimal(getLongId().longValue());
    }

    public int hashCode() {
    	// SUN_ONE_7
        //return new Long(id).hashCode();
        return getLongId().hashCode();
    }

    /**
     * Compara si el presente NumberIdPK es igual a <b>otroId</b>.
     * @return <b>true</b> si y solo si <b>otroId</b> es un <code>NumberIdPK</code>
     *          y ademas el campo <b>id</b> coincide con el de esta instancia
     */
    public boolean equals( Object obj) {
    	
    	boolean eq = (obj != null) &&
    				 (obj instanceof NumberIdPK) &&
                	 // SUN_ONE_7
                	 //(id == ((NumberIdPK)otroId).id);
                	 ( getLongId().equals( ((NumberIdPK) obj).getLongId() ) );
    				 
    	return eq;

    }

    public String toString(){
    	// SUN_ONE_7
        //return String.valueOf(id);
        return String.valueOf(getLongId().longValue());
    }
    
}
