/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.NestedException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractException
extends Exception
implements NestedException,
Serializable {
    private static final Logger log = LogManager.getLogger(AbstractException.class);
    private static final long serialVersionUID = 5546497497565700547L;
    static ResourceBundle resource = null;
    private Object[] params = null;
    private Throwable detail = null;

    @Deprecated
    public static void initialize(String errorFileName) {
        if (errorFileName != null) {
            try {
                resource = new PropertyResourceBundle(new FileInputStream(errorFileName));
            }
            catch (IOException e) {
                log.error("Ha ocurrido un error", (Throwable)e);
            }
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resource;
    }

    public AbstractException() {
    }

    public AbstractException(String msg) {
        this(msg, null, null);
    }

    public AbstractException(String msg, Object[] params) {
        this(msg, params, null);
    }

    public AbstractException(Throwable detail) {
        this(detail.getMessage(), null, detail);
    }

    public AbstractException(String msg, Throwable detail) {
        this(msg, null, detail);
    }

    public AbstractException(String msg, Object[] params, Throwable detail) {
        super(msg);
        this.detail = detail;
        this.params = params;
        this.initCause(detail);
        if (this.getLoggeable()) {
            this.dump();
        }
    }

    protected boolean getLoggeable() {
        return false;
    }

    protected boolean getFatal() {
        return false;
    }

    @Override
    public Throwable getDetail() {
        return this.detail;
    }

    public Throwable getRootDetail() {
        Throwable ret;
        Throwable aux = ret = this.getDetail();
        while (aux != null) {
            if (aux instanceof NestedException) {
                aux = ((NestedException)((Object)aux)).getDetail();
            }
            if (aux == null) continue;
            ret = aux;
        }
        return ret;
    }

    @Override
    @Deprecated
    public String getLocalizedMessage() {
        String ret;
        block5: {
            ret = null;
            String key = super.getMessage();
            ResourceBundle resource = AbstractException.getResourceBundle();
            if (resource != null) {
                try {
                    if (key != null) {
                        String msg = resource.getString(key);
                        ret = msg != null ? msg : key;
                        break block5;
                    }
                    ret = key;
                }
                catch (MissingResourceException ex) {
                    ret = key;
                    log.error("Ha ocurrido un error", (Throwable)ex);
                }
            } else {
                ret = super.getMessage();
            }
        }
        return ret;
    }

    private void dump() {
        Logger log = LogManager.getLogger(this.getClass());
        if (!this.getFatal()) {
            log.error(this.getMessage(), (Throwable)this);
            if (this.detail != null) {
                log.error(this.detail.getMessage(), (Throwable)this);
            }
        } else {
            log.fatal(this.getMessage(), (Throwable)this);
            if (this.detail != null) {
                log.fatal(this.detail.getMessage(), (Throwable)this);
            }
        }
    }
}

