/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.SimpleCacheManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleCache {
    private static final Logger log = LogManager.getLogger(SimpleCache.class);
    public static final int ONE_DAY = 86400;
    public static final int ONE_HOUR = 3600;
    private static final long SAFE_GAP = 1000L;
    private final Map<String, SimpleCacheEntry> cache = new HashMap<String, SimpleCacheEntry>();
    private final SimpleCacheManager.SimpleCacheLevel cacheLevel;
    private final String cacheName;

    public SimpleCache(String cacheName, SimpleCacheManager.SimpleCacheLevel cacheLevel) {
        if (cacheLevel == null) {
            cacheLevel = SimpleCacheManager.SimpleCacheLevel.WEAK;
        }
        this.cacheLevel = cacheLevel;
        this.cacheName = cacheName;
    }

    public synchronized void put(String key, Object value) {
        this.cache.put(key, new SimpleCacheEntry(value));
    }

    public synchronized void put(String key, Object value, Integer timeToLiveInSeconds) {
        this.cache.put(key, new SimpleCacheEntry(value).setTimeout(timeToLiveInSeconds != null ? Long.valueOf(timeToLiveInSeconds.longValue()) : null));
    }

    public Object get(String key) {
        return this.get(key, 0L, null);
    }

    public Object get(String key, Long newTimeout) {
        return this.get(key, 0L, newTimeout);
    }

    private Object get(String key, long gap, Long newTimeout) {
        SimpleCacheEntry entry = this.cache.get(key);
        if (entry != null) {
            if (entry.isExpired(gap)) {
                this.cache.remove(key);
                log.debug("[" + this.cacheName + "] Se remueve la key [" + key + "] por expirada");
                return null;
            }
            if (newTimeout != null) {
                entry.setTimeout(newTimeout);
            }
            return entry.getValue();
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean containsKey(String key) {
        return this.get(key, 1000L, null) != null;
    }

    public Long getCreationTimestamp(String key) {
        SimpleCacheEntry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getCreationTimestamp();
    }

    public Long getRemainigTime(String key) {
        SimpleCacheEntry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getRemainigTime();
    }

    public synchronized Object remove(String key) {
        SimpleCacheEntry entry = this.cache.remove(key);
        if (entry != null && !entry.isExpired(0L)) {
            return entry.getValue();
        }
        return null;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        ArrayList<String> entriesKeyToRemove = new ArrayList<String>();
        for (Map.Entry<String, SimpleCacheEntry> entry : this.cache.entrySet()) {
            SimpleCacheEntry simpleCacheEntry = this.cache.get(entry.getKey());
            if (simpleCacheEntry != null && !simpleCacheEntry.isExpired(0L)) {
                result.add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), simpleCacheEntry.getValue()));
                continue;
            }
            entriesKeyToRemove.add(entry.getKey());
        }
        if (!CollectionUtils.isEmpty(entriesKeyToRemove)) {
            for (String entryKey : entriesKeyToRemove) {
                this.cache.remove(entryKey);
            }
        }
        return result;
    }

    public SimpleCacheManager.SimpleCacheLevel getCacheLevel() {
        return this.cacheLevel;
    }

    public String toString() {
        return "SimpleCache [" + (String)(this.cache != null ? "cache=" + this.cache + ", " : "") + (String)(this.cacheLevel != null ? "cacheLevel=" + this.cacheLevel + ", " : "") + (String)(this.cacheName != null ? "cacheName=" + this.cacheName : "") + "]";
    }

    private static class SimpleCacheEntry {
        private Object value;
        private Long timeToLive;
        private Long creationTimestamp = System.currentTimeMillis();

        public SimpleCacheEntry(Object value) {
            this(value, null);
        }

        public SimpleCacheEntry(Object value, Long timeToLive) {
            this.value = value;
            this.timeToLive = timeToLive;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Long getTimeToLive() {
            return this.timeToLive;
        }

        public Long getRemainigTime() {
            return this.timeToLive - System.currentTimeMillis();
        }

        public Long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public SimpleCacheEntry setTimeToLive(Long timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public SimpleCacheEntry setTimeout(Long timeoutFromNow) {
            this.timeToLive = System.currentTimeMillis() + timeoutFromNow * 1000L;
            return this;
        }

        private boolean isExpired(long gap) {
            return this.getTimeToLive() != null && System.currentTimeMillis() > this.getTimeToLive() + gap;
        }

        public String toString() {
            return "SimpleCacheEntry [" + (String)(this.value != null ? "value=" + this.value + ", " : "") + (String)(this.timeToLive != null ? "timeToLive=" + this.timeToLive : "") + "]";
        }
    }
}

