/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.converter;

import ar.com.sdd.commons.util.SynchronizedSimpleDateFormat;
import ar.com.sdd.commons.util.converter.DataConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;

public class StringToTimestampConverter
implements DataConverter {
    static StringToTimestampConverter instancia = null;
    static final SynchronizedSimpleDateFormat formater = new SynchronizedSimpleDateFormat("dd/M/yyyy hh:mm:ss");

    protected static StringToTimestampConverter getInstance() {
        if (instancia == null) {
            instancia = new StringToTimestampConverter();
        }
        return instancia;
    }

    public static Timestamp convertTo(String o) {
        return (Timestamp)StringToTimestampConverter.getInstance().convertDataTo(o);
    }

    public static String convertFrom(Date o) {
        return (String)StringToTimestampConverter.getInstance().convertFromData(o);
    }

    public static String convertFrom(Timestamp o) {
        return (String)StringToTimestampConverter.getInstance().convertFromData(o);
    }

    @Override
    public Object convertDataTo(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("El objeto no es String");
        }
        Timestamp ts = null;
        try {
            ts = new Timestamp(formater.parse((String)o).getTime());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Formato del string invalido: [" + ex.getMessage() + "]");
        }
        return ts;
    }

    @Override
    public Object convertFromData(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            return formater.format(new java.sql.Date(ts.getTime()));
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            return formater.format(d);
        }
        throw new IllegalArgumentException("El objeto a convertir no es un tipo permitido: [" + o + "]");
    }
}

