package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.StringUtil;

import java.util.ArrayList;
import java.util.Iterator;

public class SubstringMapper extends ValueMapper {
    
    private ArrayList mapSpecs;
    
    private class MapSpec {
        String valueSpec;
        String valueCompare;
        String resultSpec;
        
        public MapSpec( String spec ) {
            String term[] = spec.split("[|]");
            String condition = term[ 0 ];
            resultSpec = term[ 1 ];
            if ( condition.equals( "*" ) ) {
                valueSpec = valueCompare = null;
            } else {
                String conditionTerms[] = condition.split( "=" );
                valueSpec = conditionTerms[ 0 ];
                valueCompare = conditionTerms[ 1 ];
            }
        }
        
        public boolean matches( String value ) {
            if ( valueSpec == null ) {
                return true;
            } else {
                String valueTest = StringUtil.fromToParser( value, valueSpec );
                return valueTest.equals( valueCompare );
            }
        }
        
        public String map( String value ) {
            return StringUtil.fromToParser( value, resultSpec );
        }
    }

    /**
     * Permite tomar distintas partes de un string de acuerdo a valores que contiene el mismo string<br/>
     * Por ejemplo el decode "1:5=D506|5:21;*|21:33" se lee como:
     * <ul>
     * * Si los caracteres 1 a 4 del valor es "D506" mapear a los caracteres 5 a 20 del valor
     * * En cualquier otro caso mapear a los caracteres 21 a 32 del valor
     * </ul> 
     * @param decode tiene la especificacion del mapeo
     */
    public SubstringMapper( String decode ) {
        mapSpecs = new ArrayList(); 
        String terms[] = decode.split(";");
        for (int i=0;i<terms.length;i++)
            mapSpecs.add( new MapSpec( terms[ i ] ) );
    }

    public String map( String source ) {
        Iterator i = mapSpecs.iterator();
        while ( i.hasNext() ) {
            MapSpec spec = (MapSpec) i.next();
            if ( spec.matches( source ) ) 
                return spec.map( source );
        }
        return null;
    }

}
