/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.db;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.db.QueryBuilder;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RangeExpresion {
    private static final Logger log = LogManager.getLogger(RangeExpresion.class);
    public static final int RANGE_NONE = 0;
    public static final int RANGE_LIKE = 1;
    public static final int RANGE_STARTSWITH = 2;
    public static final int RANGE_FROMTO = 3;
    public static final int RANGE_FROM = 4;
    public static final int RANGE_TO = 5;
    public static final int RANGE_ENDSWITH = 6;
    public static final int RANGE_LIST = 7;
    public int rangeFormat = 0;
    public boolean negate = false;
    public boolean useLikeInList = true;
    public String rangeValue = null;
    public String rangeFrom = null;
    public String rangeTo = null;
    public String[] rangeList = null;
    private static final String DEBUG_PARAM_SEP = "|";

    public RangeExpresion(String rangeExp) {
        if (rangeExp != null) {
            if (rangeExp.startsWith("!!")) {
                this.negate = true;
                rangeExp = rangeExp.substring(2);
            } else if (rangeExp.startsWith("!")) {
                this.negate = true;
                rangeExp = rangeExp.substring(1);
            }
            if (rangeExp.startsWith("=")) {
                this.useLikeInList = false;
                rangeExp = rangeExp.substring(1);
            }
        }
        this.rangeValue = rangeExp;
        if (StringUtil.isEmpty(rangeExp)) {
            this.rangeFormat = 0;
        } else if (rangeExp.contains(";")) {
            this.rangeFormat = 7;
            this.rangeList = StringUtil.splitNotEmpty(rangeExp, ';');
        } else if (rangeExp.contains(DEBUG_PARAM_SEP)) {
            this.rangeFormat = 7;
            this.rangeList = StringUtil.splitNotEmpty(rangeExp, '|');
        } else {
            this.rangeFormat = 1;
            if (rangeExp.startsWith("/")) {
                int dashIndex = rangeExp.indexOf(45);
                if (dashIndex == -1) {
                    this.rangeFormat = 2;
                    this.rangeValue = rangeExp.substring(1).trim().toUpperCase();
                    if (StringUtil.isEmpty(this.rangeValue)) {
                        this.rangeFormat = 1;
                        this.rangeValue = "/";
                    }
                } else {
                    this.rangeFormat = 3;
                    this.rangeFrom = rangeExp.substring(1, dashIndex).trim().toUpperCase();
                    this.rangeTo = rangeExp.substring(dashIndex + 1).trim().toUpperCase();
                    if (StringUtil.isEmpty(this.rangeFrom)) {
                        this.rangeFormat = 5;
                    }
                    if (StringUtil.isEmpty(this.rangeTo)) {
                        this.rangeFormat = 4;
                    }
                }
            } else if (rangeExp.startsWith("\\")) {
                this.rangeFormat = 6;
                this.rangeValue = rangeExp.substring(1).trim().toUpperCase();
                if (StringUtil.isEmpty(this.rangeValue)) {
                    this.rangeFormat = 1;
                    this.rangeValue = "\\";
                }
            } else {
                this.rangeValue = rangeExp.trim();
            }
        }
    }

    public StringBuilder appendToQuery(StringBuilder query, String fieldName) {
        String AND = " AND ";
        if (this.negate) {
            AND = " AND NOT ";
        }
        Object nvlFieldName = this.negate ? "nvl(" + fieldName + ",'$$NULL')" : fieldName;
        switch (this.rangeFormat) {
            case 1: 
            case 2: 
            case 6: {
                query.append(AND).append("(UPPER(").append((String)nvlFieldName).append(") like ? escape '!')");
                break;
            }
            case 3: {
                query.append(AND).append("(UPPER(TRIM(leading '0' from ").append((String)nvlFieldName).append(")) between ? and ? )");
                break;
            }
            case 4: {
                query.append(AND).append("(UPPER(TRIM(leading '0' from ").append((String)nvlFieldName).append(")) >= ? )");
                break;
            }
            case 5: {
                query.append(AND).append("(UPPER(TRIM(leading '0' from ").append((String)nvlFieldName).append(")) <= ? )");
                break;
            }
            case 7: {
                if (this.rangeList.length <= 0) break;
                query.append(AND).append("(");
                for (int j = 0; j < this.rangeList.length; ++j) {
                    if (j != 0) {
                        query.append(" OR ");
                    }
                    if (this.useLikeInList) {
                        query.append(" (UPPER(").append((String)nvlFieldName).append(") like ? escape '!')");
                        continue;
                    }
                    query.append("(UPPER(TRIM(leading '0' from ").append((String)nvlFieldName).append(")) = ? )");
                }
                query.append(" )");
                break;
            }
            case 0: {
                if (!this.negate) break;
                query.append(AND).append("(").append(fieldName).append(" IS NULL)");
                break;
            }
            default: {
                log.error("Range format invalido para field[" + fieldName + "]:" + this.rangeFormat);
            }
        }
        return query;
    }

    public StringBuilder appendToQueryWithValues(StringBuilder query, String fieldName) {
        StringBuilder localQuery = this.appendToQuery(new StringBuilder(), fieldName);
        for (String value : this.getSQLValues()) {
            int firstParam = localQuery.indexOf("?");
            localQuery.replace(firstParam, firstParam + 1, "'" + value + "'");
        }
        query.append((CharSequence)localQuery);
        return query;
    }

    @Deprecated
    public int appendParams(PreparedStatement stmt, int i, boolean debugAll, StringBuilder debugParameters) throws SQLException {
        return this.appendParams(stmt, i, debugAll, debugParameters, 1);
    }

    public int appendParams(PreparedStatement stmt, int i, boolean debugAll, List<Pair<String, Class<?>>> debugParameters) throws SQLException {
        return this.appendParams(stmt, i, debugAll, debugParameters, 1);
    }

    @Deprecated
    public int appendParams(PreparedStatement stmt, int i, boolean debugAll, StringBuilder debugParameters, int veces) throws SQLException {
        switch (this.rangeFormat) {
            case 1: {
                String likeParam = "%" + QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase()) + "%";
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(likeParam);
                }
                break;
            }
            case 2: {
                String likeParam = QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase()) + "%";
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(likeParam);
                }
                break;
            }
            case 6: {
                String likeParam = "%" + QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase());
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(likeParam);
                }
                break;
            }
            case 3: {
                this.rangeFrom = StringUtil.trimLeading(this.rangeFrom, '0');
                this.rangeTo = StringUtil.trimLeading(this.rangeTo, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeFrom);
                    if (debugAll) {
                        debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(this.rangeFrom);
                    }
                    stmt.setString(i++, this.rangeTo);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(this.rangeTo);
                }
                break;
            }
            case 4: {
                this.rangeFrom = StringUtil.trimLeading(this.rangeFrom, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeFrom);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(this.rangeFrom);
                }
                break;
            }
            case 5: {
                this.rangeTo = StringUtil.trimLeading(this.rangeTo, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeTo);
                    if (!debugAll) continue;
                    debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append(this.rangeTo);
                }
                break;
            }
            case 7: {
                for (int j = 0; j < this.rangeList.length; ++j) {
                    for (int vez = 0; vez < veces; ++vez) {
                        Object likeParam = this.rangeList[j].trim().toUpperCase();
                        if (this.useLikeInList) {
                            likeParam = "%" + QueryBuilder.getEscapedLike((String)likeParam) + "%";
                        }
                        stmt.setString(i++, (String)likeParam);
                        if (!debugAll) continue;
                        debugParameters.append(DEBUG_PARAM_SEP).append(i - 1).append(": ").append((String)likeParam);
                    }
                }
                break;
            }
        }
        return i;
    }

    public int appendParams(PreparedStatement stmt, int i, boolean debugAll, List<Pair<String, Class<?>>> debugParameters, int veces) throws SQLException {
        switch (this.rangeFormat) {
            case 1: {
                String likeParam = "%" + QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase()) + "%";
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)likeParam, String.class));
                }
                break;
            }
            case 2: {
                String likeParam = QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase()) + "%";
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)likeParam, String.class));
                }
                break;
            }
            case 6: {
                String likeParam = "%" + QueryBuilder.getEscapedLike(this.rangeValue.toUpperCase());
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, likeParam);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)likeParam, String.class));
                }
                break;
            }
            case 3: {
                this.rangeFrom = StringUtil.trimLeading(this.rangeFrom, '0');
                this.rangeTo = StringUtil.trimLeading(this.rangeTo, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeFrom);
                    if (debugAll) {
                        debugParameters.add(Pair.of((Object)this.rangeFrom, String.class));
                    }
                    stmt.setString(i++, this.rangeTo);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)this.rangeTo, String.class));
                }
                break;
            }
            case 4: {
                this.rangeFrom = StringUtil.trimLeading(this.rangeFrom, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeFrom);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)this.rangeFrom, String.class));
                }
                break;
            }
            case 5: {
                this.rangeTo = StringUtil.trimLeading(this.rangeTo, '0');
                for (int vez = 0; vez < veces; ++vez) {
                    stmt.setString(i++, this.rangeTo);
                    if (!debugAll) continue;
                    debugParameters.add(Pair.of((Object)this.rangeTo, String.class));
                }
                break;
            }
            case 7: {
                for (int j = 0; j < this.rangeList.length; ++j) {
                    for (int vez = 0; vez < veces; ++vez) {
                        Object likeParam = this.rangeList[j].trim().toUpperCase();
                        if (this.useLikeInList) {
                            likeParam = "%" + QueryBuilder.getEscapedLike((String)likeParam) + "%";
                        }
                        stmt.setString(i++, (String)likeParam);
                        if (!debugAll) continue;
                        debugParameters.add(Pair.of((Object)likeParam, String.class));
                    }
                }
                break;
            }
        }
        return i;
    }

    public String getSQLFilter(String tableField) {
        return this.getSQLFilter(tableField, true);
    }

    public RangeExpresion fillSQLDebugParameters(List<Pair<String, Class<?>>> debugParameters) {
        for (String value : this.getSQLValues()) {
            debugParameters.add(Pair.of((Object)value, String.class));
        }
        return this;
    }

    public ArrayList<String> getSQLValues() {
        ArrayList<String> returnRangeList = new ArrayList<String>();
        switch (this.rangeFormat) {
            case 1: {
                returnRangeList.add("%" + QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase() + "%");
                break;
            }
            case 2: {
                returnRangeList.add(QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase() + "%");
                break;
            }
            case 6: {
                returnRangeList.add("%" + QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase());
                break;
            }
            case 3: {
                returnRangeList.add(this.rangeFrom);
                returnRangeList.add(this.rangeTo);
                break;
            }
            case 4: {
                returnRangeList.add(this.rangeFrom);
                break;
            }
            case 5: {
                returnRangeList.add(this.rangeTo);
                break;
            }
            case 7: {
                for (int n = 0; n < this.rangeList.length; ++n) {
                    Object likeParam = this.rangeList[n].toUpperCase();
                    if (this.useLikeInList) {
                        likeParam = "%" + QueryBuilder.getEscapedString((String)likeParam) + "%";
                    }
                    returnRangeList.add((String)likeParam);
                }
                break;
            }
        }
        return returnRangeList;
    }

    public String getSQLFilter(String tableField, boolean withValues) {
        Object condition = "";
        switch (this.rangeFormat) {
            case 1: {
                String likeParam = withValues ? "'%" + QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase() + "%'" : "?";
                condition = "(UPPER(" + tableField + ") like " + likeParam + " escape '!')";
                break;
            }
            case 2: {
                String likeParam = withValues ? "'" + QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase() + "%'" : "?";
                condition = "(UPPER(" + tableField + ") like " + likeParam + " escape '!')";
                break;
            }
            case 6: {
                String likeParam = withValues ? "'%" + QueryBuilder.getEscapedString(QueryBuilder.getEscapedLike(this.rangeValue)).toUpperCase() + "'" : "?";
                condition = "(UPPER(" + tableField + ") like " + likeParam + " escape '!')";
                break;
            }
            case 3: {
                condition = "(UPPER(" + tableField + ") between " + (String)(withValues ? "'" + this.rangeFrom + "'" : "?") + " AND " + (String)(withValues ? "'" + this.rangeTo + "'" : "?") + ")";
                break;
            }
            case 4: {
                condition = "(UPPER(" + tableField + ") >= " + (String)(withValues ? "'" + this.rangeFrom + "'" : "?") + ")";
                break;
            }
            case 5: {
                condition = "(UPPER(" + tableField + ") <= " + (String)(withValues ? "'" + this.rangeTo + "'" : "?") + ")";
                break;
            }
            case 7: {
                condition = (String)condition + "(";
                for (int j = 0; j < this.rangeList.length; ++j) {
                    Object likeParam;
                    Object object = likeParam = withValues ? this.rangeList[j].toUpperCase() : "?";
                    if (withValues && this.useLikeInList) {
                        likeParam = "%" + QueryBuilder.getEscapedString((String)likeParam) + "%";
                    }
                    if (j != 0) {
                        condition = (String)condition + " OR ";
                    }
                    condition = this.useLikeInList ? (String)condition + "(UPPER(" + tableField + ") like '" + (String)likeParam + "' escape '!')" : (String)condition + "(UPPER(" + tableField + ") =   '" + (String)likeParam + "')";
                }
                condition = (String)condition + ")";
            }
        }
        if (this.negate) {
            condition = this.rangeFormat == 0 ? "( NOT " + tableField + " IS NULL )" : "(NOT " + (String)condition + ")";
        }
        return condition;
    }
}

