/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.xml;

import ar.com.sdd.commons.util.InvalidArgumentException;
import ar.com.sdd.commons.util.ObjectUtil;
import ar.com.sdd.commons.util.xml.XMLDataException;
import ar.com.sdd.commons.util.xml.XMLTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLData {
    private static final Logger log = LogManager.getLogger(XMLData.class);
    private static final String PREFIX_XMLI = "xmli";
    private static final String NS_XMLI = "http://sdd.com.ar/xmlinclude/1.0";
    private XMLTag data = null;
    private boolean useNamespaces = false;
    private File resourcesUrl = null;

    public void parseFromString(String data) throws XMLDataException {
        ByteArrayInputStream dataStr = new ByteArrayInputStream(data.getBytes());
        this.parse(dataStr);
    }

    private void parse(InputStream inStream) throws XMLDataException {
        this.data = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            Reader reader = new Reader();
            try {
                saxParser.parse(inStream, (DefaultHandler)reader);
                this.data = reader.getTop();
            }
            catch (SAXException e) {
                throw new XMLDataException("Error al parsear el stream", e, false);
            }
            catch (IOException e) {
                throw new XMLDataException("Error al leer el stream", e, false);
            }
        }
        catch (ParserConfigurationException e) {
            throw new XMLDataException("Error de configuracion del parser", e, true);
        }
        catch (SAXException e) {
            throw new XMLDataException("Error al inicializar el parser", e, true);
        }
    }

    public void parse(String xmlDocument) throws XMLDataException {
        this.parse(xmlDocument, true, 0);
    }

    public void parse(String xmlDocument, boolean doIncludes) throws XMLDataException {
        this.parse(xmlDocument, doIncludes, 0);
    }

    public void parse(String xmlDocument, boolean doIncludes, Integer skipLines) throws XMLDataException {
        this.data = null;
        File parentFile = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            Reader reader = new Reader();
            try {
                File xmlDocumentFile = new File(xmlDocument);
                parentFile = xmlDocumentFile.getParentFile();
                if (skipLines != null && skipLines > 0) {
                    FileInputStream is = new FileInputStream(xmlDocumentFile);
                    saxParser.parse((InputStream)is, (DefaultHandler)reader);
                } else {
                    saxParser.parse(xmlDocumentFile, (DefaultHandler)reader);
                }
            }
            catch (SAXException e) {
                throw new XMLDataException("Error al parsear el documento [" + xmlDocument + "]", e, false);
            }
            catch (IOException e) {
                throw new XMLDataException("Error al leer el documento [" + xmlDocument + "]", e, false);
            }
            this.data = reader.getTop();
        }
        catch (SAXException ex) {
            throw new XMLDataException("Error al inicializar el parser para el documento [" + xmlDocument + "]", ex, true);
        }
        catch (ParserConfigurationException ex) {
            throw new XMLDataException("Error de configuracion en el parser para el documento [" + xmlDocument + "]", ex, true);
        }
        if (doIncludes) {
            try {
                this.resolveIncludes(parentFile, true);
            }
            catch (Exception ex) {
                throw new XMLDataException("Error de resolucion de includes en el parser para el documento [" + xmlDocument + "]", ex, true);
            }
        }
    }

    public void resolveIncludes(File parentFile, boolean doCleanupImportTags) throws XMLDataException {
        XMLData model = this.getIncludedModel(parentFile);
        if (model != null) {
            HashMap includeMatchKeys = new HashMap();
            this.addIncludeKeys(includeMatchKeys, model.getRoot());
            this.addIncludeKeys(includeMatchKeys, this.getRoot());
            this.applyIncludeEdits(includeMatchKeys, model, null, this.getRoot(), null, new HashSet());
            this.data = model.getRoot();
            if (doCleanupImportTags) {
                this.cleanupImportTags(this.data);
            }
        }
    }

    private void cleanupImportTags(XMLTag tag) {
        ArrayList<XMLTag> toCleanup = new ArrayList<XMLTag>();
        Enumeration<TreeNode> childrenEnum = tag.breadthFirstEnumeration();
        while (childrenEnum.hasMoreElements()) {
            XMLTag childTag = (XMLTag)childrenEnum.nextElement();
            if (childTag.getNsUri() != null && childTag.getNsUri().equals(NS_XMLI)) {
                toCleanup.add(childTag);
                continue;
            }
            for (String string : new ArrayList<Object>(childTag.getProperties().keySet())) {
                if (!NS_XMLI.equals(childTag.getPropertyNsUri(string))) continue;
                childTag.removeProperty(string);
            }
        }
        for (XMLTag element : toCleanup) {
            element.removeFromParent();
        }
    }

    private void addIncludeKeys(Map includeKeys, XMLTag tag) {
        String key = this.getXmliTagNameResolvingNamespaces("key");
        ArrayList<XMLTag> keys = tag.getItems(NS_XMLI, key, true);
        for (XMLTag keyTag : keys) {
            String keyElement = keyTag.getProperty("element");
            String keyAttributes = keyTag.getProperty("attributes");
            if (keyElement == null) {
                throw new InvalidArgumentException("Falta atributo 'element' para comparar tags");
            }
            if (keyAttributes == null) {
                throw new InvalidArgumentException("Falta atributo 'attributes' para comparar tags");
            }
            HashSet<String> attributesSet = new HashSet<String>();
            String[] attributes = keyAttributes.split(",");
            for (int i = 0; i < attributes.length; ++i) {
                attributesSet.add(attributes[i]);
            }
            includeKeys.put(keyElement, attributesSet);
        }
    }

    private XMLData loadIncludedModel(File parentFile, XMLTag includeTag) throws XMLDataException {
        String includeResourceUri = includeTag.getProperty("href");
        if (includeResourceUri == null) {
            throw new InvalidArgumentException("Falta atributo 'href' para incluir modelo");
        }
        XMLData result = new XMLData();
        result.setUseNamespaces(this.isUseNamespaces());
        File includedFile = new File(parentFile, includeResourceUri);
        result.parse(includedFile.getAbsolutePath(), false);
        result.resolveIncludes(includedFile.getParentFile(), false);
        return result;
    }

    private XMLData getIncludedModel(File parentFile) throws XMLDataException {
        XMLData result = null;
        XMLTag root = this.getRoot();
        String include = this.getXmliTagNameResolvingNamespaces("include");
        ArrayList<XMLTag> includeTags = root.getItems(NS_XMLI, include, true);
        while (includeTags != null && !includeTags.isEmpty()) {
            XMLTag includeTag = (XMLTag)includeTags.get(0);
            if (result == null) {
                result = this.loadIncludedModel(parentFile, includeTag);
            } else {
                XMLTag newInclude = new XMLTag(include, includeTag.getProperties());
                newInclude.setNsUri(NS_XMLI);
                result.getRoot().add(newInclude);
                result.resolveIncludes(parentFile, false);
            }
            includeTags.remove(includeTag);
            includeTag.removeFromParent();
        }
        return result;
    }

    private String getIncludeProperty(XMLTag tag, String propertyName) {
        String property = tag.getProperty(propertyName);
        if (property != null && !NS_XMLI.equals(tag.getPropertyNsUri(propertyName))) {
            property = null;
        }
        return property;
    }

    private void applyIncludeEdits(Map includeKeys, XMLData model, XMLTag modelContext, XMLTag tag, String defaultOverride, Set alreadyEdited) throws XMLDataException {
        String tagOverride = this.getIncludeProperty(tag, "override");
        if (tagOverride == null) {
            tagOverride = defaultOverride == null ? "declared" : defaultOverride;
        }
        List<XMLTag> editPoints = this.getIncludeEditPoints(includeKeys, model, modelContext, tag, tagOverride, alreadyEdited);
        if (tagOverride.equals("delete")) {
            for (XMLTag deleteTag : editPoints) {
                deleteTag.removeFromParent();
            }
        } else {
            if (editPoints.size() > 1) {
                String msg = "Se selecciono mas de un tag para modificar '" + tag.getNamePath();
                log.error(msg);
                log.error("Verificar en cada archivo incluido que esta clave no esta mas de una vez declarada.");
                log.error(editPoints);
                throw new InvalidArgumentException(msg);
            }
            if (!editPoints.isEmpty()) {
                XMLTag newContext = editPoints.get(0);
                if (tagOverride.equals("all")) {
                    newContext.removeAllChildren();
                    defaultOverride = "all";
                }
                for (String string : tag.getProperties().keySet()) {
                    newContext.setProperty(tag.getPropertyNsUri(string), string, tag.getProperty(string));
                }
                newContext.setData(tag.getData());
                HashSet hashSet = new HashSet();
                Enumeration<TreeNode> e = tag.children();
                while (e.hasMoreElements()) {
                    XMLTag child = (XMLTag)e.nextElement();
                    this.applyIncludeEdits(includeKeys, model, newContext, child, defaultOverride, hashSet);
                }
                alreadyEdited.add(newContext);
            }
        }
    }

    private List<XMLTag> getIncludeEditPoints(Map includeKeys, XMLData model, XMLTag modelContext, XMLTag tag, String tagOverride, Set alreadyEdited) throws XMLDataException {
        ArrayList<XMLTag> result = new ArrayList<XMLTag>();
        if (modelContext != null) {
            ArrayList<XMLTag> candidates;
            if (!tagOverride.equals("add")) {
                String forcedMatch = this.getIncludeProperty(tag, "match");
                candidates = modelContext.getItems(tag.getName(), false);
                if (forcedMatch != null) {
                    XMLTag xMLTag = this.matchSiblingNode(tag, candidates, "match");
                    result.add(xMLTag);
                } else {
                    for (XMLTag candidate : candidates) {
                        if (!this.matchIncluded(includeKeys, candidate, tag, alreadyEdited)) continue;
                        result.add(candidate);
                    }
                }
            }
            if (result.isEmpty() && !tagOverride.equals("delete")) {
                XMLTag xMLTag;
                XMLTag clonedTag = null;
                if (tagOverride.equals("duplicate") && (xMLTag = this.matchSiblingNode(tag, candidates = modelContext.getItems(tag.getName(), false), "duplicate")) != null) {
                    clonedTag = xMLTag.deepClone();
                }
                if (clonedTag == null) {
                    clonedTag = new XMLTag(tag.getName());
                    clonedTag.setNsUri(tag.getNsUri());
                    for (String string : tag.getProperties().keySet()) {
                        clonedTag.setProperty(tag.getPropertyNsUri(string), string, tag.getProperty(string));
                    }
                }
                this.addIncludeEditPoint(modelContext, clonedTag);
                result.add(clonedTag);
            }
        } else {
            if (!tag.getName().equals(model.getRoot().getName())) {
                throw new InvalidArgumentException("El tag raiz del XML incluido debe ser el mismo");
            }
            result.add(model.getRoot());
        }
        return result;
    }

    private void addIncludeEditPoint(XMLTag modelContext, XMLTag tag) throws XMLDataException {
        int insertBeforeIndex;
        ArrayList<XMLTag> mismoNombre = modelContext.getItems(tag.getName(), false);
        XMLTag insertBefore = this.matchSiblingNode(tag, mismoNombre, "before");
        int n = insertBefore != null ? modelContext.getIndex(insertBefore) : (insertBeforeIndex = !mismoNombre.isEmpty() ? modelContext.getIndex((XMLTag)mismoNombre.get(mismoNombre.size() - 1)) + 1 : -1);
        if (insertBeforeIndex < 0) {
            modelContext.add(tag);
        } else {
            modelContext.insert(tag, insertBeforeIndex);
        }
    }

    private XMLTag matchSiblingNode(XMLTag tag, List mismoNombre, String keyProperty) throws XMLDataException {
        XMLTag result = null;
        String tagBefore = this.getIncludeProperty(tag, keyProperty);
        if (tagBefore != null) {
            int i;
            String[] terms = tagBefore.split(",");
            String[][] attrValuePairs = new String[terms.length][];
            for (i = 0; i < terms.length; ++i) {
                attrValuePairs[i] = terms[i].split("=");
                if (attrValuePairs[i].length == 2) continue;
                throw new XMLDataException("xmli:" + keyProperty + " invalido '" + tagBefore + "', debe ser 'attr=value,attr=value...'", true);
            }
            Iterator tags = mismoNombre.iterator();
            while (tags.hasNext() && result == null) {
                XMLTag item = (XMLTag)tags.next();
                boolean found = true;
                for (i = 0; found && i < terms.length; ++i) {
                    found = ObjectUtil.safeEquals(item.getProperty(attrValuePairs[i][0]), attrValuePairs[i][1]);
                }
                if (!found) continue;
                result = item;
            }
        }
        return result;
    }

    private boolean matchIncluded(Map includeKeys, XMLTag editCandidate, XMLTag tag, Set alreadyEdited) {
        boolean result;
        boolean bl = result = !alreadyEdited.contains(editCandidate);
        if (result) {
            String attr;
            HashSet<Object> attrs = (HashSet<Object>)includeKeys.get(tag.getName());
            if (attrs == null) {
                attrs = new HashSet<Object>(tag.getProperties().keySet());
                Iterator j = attrs.iterator();
                while (j.hasNext()) {
                    attr = (String)j.next();
                    if (!NS_XMLI.equals(tag.getPropertyNsUri(attr))) continue;
                    j.remove();
                }
            }
            Iterator i = attrs.iterator();
            while (result && i.hasNext()) {
                attr = (String)i.next();
                String candidateValue = editCandidate.getProperty(attr);
                String tagValue = tag.getProperty(attr);
                result = candidateValue == null && tagValue == null || candidateValue != null && tagValue != null && candidateValue.equals(tagValue);
            }
        }
        return result;
    }

    public InputStream toInputStream(boolean header) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.saveToStream(out, header);
        ByteArrayInputStream retr = new ByteArrayInputStream(out.toByteArray());
        return retr;
    }

    public InputStream toInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.saveToStream(out);
        ByteArrayInputStream retr = new ByteArrayInputStream(out.toByteArray());
        return retr;
    }

    public void saveToStream(OutputStream outStream, boolean header) {
        if (!this.isEmpty()) {
            PrintWriter out = new PrintWriter(outStream);
            if (header) {
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            }
            if (this.data != null) {
                this.data.saveToStream(out);
            }
            out.flush();
            try {
                outStream.close();
            }
            catch (IOException e) {
                Logger log = LogManager.getLogger(this.getClass());
                log.warn("No se pudo cerrar correctamente el stream", (Throwable)e);
            }
        }
    }

    public void saveToStream(OutputStream outStream) {
        this.saveToStream(outStream, true);
    }

    public boolean isEmpty() {
        return this.data == null || this.data.getChildCount() == 0;
    }

    public XMLTag getRoot() {
        return this.data;
    }

    public List<XMLTag> getItems(String name) {
        return this.getItems(name, true);
    }

    public List<XMLTag> getItems(String name, boolean recursive) {
        ArrayList<XMLTag> ret = this.data != null ? this.data.getItems(name, recursive) : new ArrayList<XMLTag>();
        return ret;
    }

    public HashMap<String, String> getItemsAsMap(String name, boolean recursive) {
        XMLTag tag = this.getItem(name, recursive);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        Enumeration<TreeNode> childrenEnum = tag.children();
        while (childrenEnum.hasMoreElements()) {
            XMLTag item = (XMLTag)childrenEnum.nextElement();
            tagMap.put(item.getName(), item.getData());
        }
        return tagMap;
    }

    public String getItemData(String name) {
        XMLTag tag = this.getItem(name);
        return tag == null ? null : tag.getData();
    }

    public XMLTag getItem(String name) {
        return this.getItem(name, true);
    }

    public XMLTag getItem(String name, boolean recursive) {
        List<XMLTag> v = this.getItems(name, recursive);
        return v.size() > 0 ? v.get(0) : null;
    }

    public String getXMLString() throws XMLDataException {
        return this.getXMLString(true);
    }

    public String getXMLString(boolean header) throws XMLDataException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.saveToStream(outStream, header);
        return outStream.toString();
    }

    public boolean isUseNamespaces() {
        return this.useNamespaces;
    }

    public void setUseNamespaces(boolean namespaceAware) {
        this.useNamespaces = namespaceAware;
    }

    public File getResourcesUrl() {
        return this.resourcesUrl;
    }

    public void setResourcesUrl(File resourcesUrl) {
        this.resourcesUrl = resourcesUrl;
    }

    private String getXmliTagNameResolvingNamespaces(String tagName) {
        Object tagResolved = this.isUseNamespaces() ? "xmli:" + tagName : tagName;
        return tagResolved;
    }

    class XMLErrorHandler
    implements ErrorHandler {
        XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLData.class);
            log.error("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")", (Throwable)e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLData.class);
            log.fatal("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")", (Throwable)e);
        }

        @Override
        public void warning(SAXParseException e) {
            Logger log = LogManager.getLogger(XMLData.class);
            log.warn("Error en XML parser en " + e.getPublicId() + " (" + e.getLineNumber() + ", " + e.getColumnNumber() + ")");
        }
    }

    public class Reader
    extends DefaultHandler {
        private XMLTag current = null;
        private List<String> nsDeclarations = new ArrayList<String>();

        public XMLTag getTop() {
            return this.current;
        }

        public void addNsDeclaration(String prefix, String uri) {
            this.nsDeclarations.add("\n xmlns:" + prefix + "=\"" + uri + "\" ");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.addNsDeclaration(prefix, uri);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) {
            boolean useNS = XMLData.this.isUseNamespaces();
            String useName = useNS ? name : localName;
            XMLTag item = new XMLTag(useName);
            item.setNsUri(uri);
            for (int i = 0; i < attrs.getLength(); ++i) {
                item.setProperty(attrs.getURI(i), useNS ? attrs.getQName(i) : attrs.getLocalName(i), attrs.getValue(i));
            }
            if (this.current != null) {
                this.current.add(item);
            }
            this.current = item;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            char[] data = new char[length];
            System.arraycopy(ch, start, data, 0, length);
            String itemData = new String(data);
            if (itemData.length() > 0) {
                String prevData = this.current.getData();
                if (prevData != null) {
                    this.current.setData(prevData + itemData);
                } else {
                    this.current.setData(itemData);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (this.current.getParent() != null) {
                this.current = (XMLTag)this.current.getParent();
                if (XMLData.this.isUseNamespaces()) {
                    this.current.getNsDeclarations().addAll(this.nsDeclarations);
                }
                this.nsDeclarations.clear();
            }
        }
    }
}

