/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.commons.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileToolkit {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger log = LogManager.getLogger(FileToolkit.class);
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String SCRIPT_BARCODE_GENERATOR_FILENAME = "barcodegenerator.sh";
    public static final String FILE_TYPE_XLSX = "xlsx";
    public static final String FILE_EXTENSION_XLSX = ".xlsx";
    public static final String FILE_TYPE_PDF = "pdf";
    public static final String FILE_EXTENSION_PDF = ".pdf";
    public static final String FILE_TYPE_CSV = "csv";
    public static final String FILE_EXTENSION_CSV = ".csv";
    public static final String FILE_TYPE_JSON = "json";
    public static final String FILE_EXTENSION_JSON = ".json";
    public static final String FILE_TYPE_ZIP = "zip";
    public static final String FILE_EXTENSION_ZIP = ".zip";
    public static final String FILE_TYPE_TAR_GZ = "tar.gz";
    public static final String FILE_EXTENSION_TAR_GZ = ".tar.gz";
    public static final String FILE_TYPE_TGZ = "tgz";
    public static final String FILE_EXTENSION_TGZ = ".tgz";
    public static final String FILE_TYPE_GZIP = "gz";
    public static final String FILE_EXTENSION_GZIP = ".gz";
    public static final String FILE_TYPE_TXT = "txt";
    public static final String FILE_EXTENSION_TXT = ".txt";

    public static void createFile(String filepath) throws IOException {
        FileToolkit.createFile(filepath, "");
    }

    public static void createFile(String filepath, String content) throws IOException {
        File theFile = new File(filepath);
        if (theFile.exists()) {
            theFile.delete();
        } else {
            FileToolkit.checkDirectory(filepath);
        }
        theFile.createNewFile();
        FileWriter writer = new FileWriter(theFile);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    public static void appendToFile(String filepath, String content) throws IOException {
        File theFile = new File(filepath);
        FileWriter writer = new FileWriter(theFile, true);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    public static String readFile(String directory, String fileName) throws IOException {
        File theFile = new File(directory, fileName);
        FileReader reader = new FileReader(theFile);
        char[] buff = new char[65535];
        int leidos = reader.read(buff);
        Object datosLeidos = "";
        while (leidos > 0) {
            datosLeidos = (String)datosLeidos + new String(buff, 0, leidos);
            leidos = reader.read(buff);
        }
        return datosLeidos;
    }

    public static String readFileUTF8(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF8"));
        char[] buff = new char[65535];
        int leidos = reader.read(buff);
        Object datosLeidos = "";
        while (leidos > 0) {
            datosLeidos = (String)datosLeidos + new String(buff, 0, leidos);
            leidos = reader.read(buff);
        }
        reader.close();
        return datosLeidos;
    }

    public static File[] getDirectory(String dir, boolean includeDirectories) throws IOException {
        return FileToolkit.getDirectory(dir, "", "", includeDirectories);
    }

    public static void checkDirectory(String fullFileName) {
        boolean success;
        File pathFileName = new File(FileToolkit.getPathOnly(fullFileName));
        if (!pathFileName.exists() && !(success = pathFileName.mkdirs())) {
            throw new ApplicationException("No se pudo crear la estructura de directorios para [" + fullFileName + "]");
        }
    }

    public static void sortFileObjetList(List<FileObject> sibList, String readOrder) {
        if (readOrder.equalsIgnoreCase("LIFO")) {
            Collections.sort(sibList, new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    return o2.getName().getBaseName().compareTo(o1.getName().getBaseName());
                }
            });
        } else {
            Collections.sort(sibList, new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    return o1.getName().getBaseName().compareTo(o2.getName().getBaseName());
                }
            });
        }
    }

    public static void sortFileList(List<File> sibList, String readOrder) {
        if (readOrder.equalsIgnoreCase("LIFO")) {
            Collections.sort(sibList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
        } else {
            Collections.sort(sibList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    public static boolean matchWildcard(String wildcard, String fileBaseName) {
        String wildRegExp = "^" + wildcard.replaceAll("\\.", "\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".") + "$";
        return fileBaseName.matches(wildRegExp);
    }

    public static File getFileByPattern(String pathWithPatern, String readOrder) {
        File file = new File(pathWithPatern);
        String fileDir = file.getParent();
        final String searchPattern = file.getName();
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileToolkit.matchWildcard(searchPattern, pathname.getName());
            }
        };
        File f = new File(fileDir);
        File result = null;
        File[] listFiles = f.listFiles(ff);
        if (listFiles != null) {
            List<File> files = Arrays.asList(listFiles);
            FileToolkit.sortFileList(files, readOrder);
            Iterator<File> filesIter = files.iterator();
            while (filesIter.hasNext() && result == null) {
                result = filesIter.next();
                String baseName = result.getName();
                log.info("initializeStream: probando el matching con: " + baseName);
            }
        }
        return result;
    }

    public static File[] getDirectory(String dir, final String startsWith, final String endsWith, final boolean includeDirectories) throws IOException {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                if (includeDirectories || !includeDirectories && !pathname.isDirectory()) {
                    return filename.startsWith(startsWith) && filename.endsWith(endsWith);
                }
                return false;
            }
        };
        File f = new File(dir);
        return f.listFiles(ff);
    }

    public static long copyStream(InputStream is, OutputStream os) throws IOException {
        long written = 0L;
        byte[] buff = new byte[0x100000];
        int leidos = is.read(buff);
        while (leidos > 0) {
            os.write(buff, 0, leidos);
            written += (long)leidos;
            leidos = is.read(buff);
        }
        return written;
    }

    public static boolean copyFile(File file, String toFullPath, String contentPrefix, String contentSufix, boolean deleteOnSuccess, boolean compressOnSuccess) throws IOException {
        FileToolkit.checkDirectory(toFullPath);
        File toFile = new File(toFullPath);
        toFile.createNewFile();
        FileOutputStream writer = new FileOutputStream(toFile);
        long contentLength = 0L;
        if (contentPrefix != null) {
            byte[] fixBuff = contentPrefix.getBytes();
            writer.write(fixBuff);
            contentLength += (long)fixBuff.length;
        }
        FileInputStream reader = new FileInputStream(file);
        FileToolkit.copyStream(reader, writer);
        if (contentSufix != null) {
            byte[] fixBuff = contentSufix.getBytes();
            writer.write(fixBuff);
            contentLength += (long)fixBuff.length;
        }
        writer.flush();
        writer.close();
        reader.close();
        if (toFile.exists() && file.length() + contentLength == toFile.length()) {
            if (deleteOnSuccess) {
                file.delete();
            }
            if (compressOnSuccess) {
                ArrayList<File> filesToAdd = new ArrayList<File>();
                filesToAdd.add(toFile);
                FileToolkit.compressFiles(toFullPath, filesToAdd, true);
            }
            return true;
        }
        return false;
    }

    public static boolean copyFile(File file, String toFullPath, String contentPrefix, String contentSufix, boolean deleteOnSuccess) throws IOException {
        return FileToolkit.copyFile(file, toFullPath, contentPrefix, contentSufix, deleteOnSuccess, false);
    }

    public static boolean copyFile(String fromFullPath, String toFullPath, String contentPrefix, String contentSufix, boolean deleteOnSuccess, boolean compressOnSuccess) throws IOException {
        return FileToolkit.copyFile(new File(fromFullPath), toFullPath, contentPrefix, contentSufix, deleteOnSuccess, compressOnSuccess);
    }

    public static boolean copyFile(String fromFullPath, String toFullPath, String contentPrefix, String contentSufix, boolean deleteOnSuccess) throws IOException {
        return FileToolkit.copyFile(new File(fromFullPath), toFullPath, contentPrefix, contentSufix, deleteOnSuccess, false);
    }

    public static boolean moveFile(String fromFullPath, String toFullPath, boolean compressTarget) throws IOException {
        return FileToolkit.moveFile(new File(fromFullPath), toFullPath, compressTarget);
    }

    public static boolean moveFile(String fromFullPath, String toFullPath) throws IOException {
        return FileToolkit.moveFile(new File(fromFullPath), toFullPath, false);
    }

    public static boolean moveFile(File file, String toFullPath, boolean compressTarget) throws IOException {
        return FileToolkit.copyFile(file, toFullPath, null, null, true, compressTarget);
    }

    public static boolean moveFile(File file, String toFullPath) throws IOException {
        return FileToolkit.copyFile(file, toFullPath, null, null, true, false);
    }

    public static boolean copyFileReplaceBytes(String fromFullPath, String toFullPath, String contentPrefix, String contentSufix, char[] origChars, char[] replChars, String encoding, boolean deleteOnSuccess) throws IOException {
        boolean copySuccess = true;
        File fromFile = new File(fromFullPath);
        File toFile = new File(toFullPath);
        FileToolkit.checkDirectory(toFullPath);
        toFile.createNewFile();
        FileOutputStream writer = new FileOutputStream(toFile);
        if (contentPrefix != null) {
            byte[] fixBuff = contentPrefix.getBytes();
            writer.write(fixBuff);
        }
        FileInputStream reader = new FileInputStream(fromFile);
        byte[] buff = new byte[0x100000];
        int leidos = reader.read(buff);
        while (leidos > 0) {
            FileToolkit.replaceBytesAndWrite(writer, buff, leidos, origChars, replChars, encoding);
            leidos = reader.read(buff);
        }
        if (contentSufix != null) {
            byte[] fixBuff = contentSufix.getBytes();
            writer.write(fixBuff);
        }
        writer.flush();
        writer.close();
        reader.close();
        if (toFile.exists()) {
            if (deleteOnSuccess) {
                fromFile.delete();
            }
            copySuccess = true;
        } else {
            copySuccess = false;
        }
        return copySuccess;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastSep = fileName.lastIndexOf(".");
        if (lastSep != -1) {
            return fileName.substring(lastSep + 1);
        }
        return "";
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastSep = fileName.replace('\\', '/').lastIndexOf("/");
        if (lastSep != -1) {
            return fileName.substring(lastSep + 1);
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        return FileToolkit.getFileNameWithoutExtension(fileName, true);
    }

    public static String getFileNameWithoutExtension(String fileName, boolean removePath) {
        if (removePath) {
            fileName = FileToolkit.getFileName(fileName);
        }
        if (fileName.lastIndexOf(46) > -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static String getPathOnly(String fileName) {
        return FileToolkit.getPathOnly(fileName, false);
    }

    public static String getPathOnly(String fullPath, boolean addLastBar) {
        if (fullPath == null) {
            return null;
        }
        int lastSep = fullPath.replace('\\', '/').lastIndexOf("/");
        if (lastSep != -1) {
            if (addLastBar) {
                ++lastSep;
            }
            return fullPath.substring(0, lastSep);
        }
        return fullPath;
    }

    public static String changeExtension(String fileName, String targetExtension) {
        if (fileName.lastIndexOf(46) > -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName + "." + targetExtension;
    }

    private static long replaceBytesAndWrite(FileOutputStream writer, byte[] bytesRead, int leidos, char[] origChars, char[] replChars, String encoding) throws IOException {
        String st = StringUtil.replaceChars(new String(bytesRead, 0, leidos, encoding), origChars, replChars);
        byte[] bytesToWrite = st.getBytes(encoding);
        writer.write(bytesToWrite);
        return bytesToWrite.length;
    }

    public static File compressFiles(String fileToCreate, Collection filesToAdd, boolean deleteAddedFiles) {
        return FileToolkit.compressFiles(fileToCreate, filesToAdd, deleteAddedFiles, true);
    }

    public static File compressFiles(String fileToCreate, Collection filesToAdd, boolean deleteAddedFiles, boolean addZipExtension) {
        String extension = "";
        if (addZipExtension) {
            extension = fileToCreate.endsWith(".") ? FILE_TYPE_ZIP : FILE_EXTENSION_ZIP;
        }
        File zipFileToCreate = new File(fileToCreate + extension);
        try {
            FileOutputStream dest = new FileOutputStream(zipFileToCreate);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            BufferedInputStream origin = null;
            byte[] data = new byte[0x100000];
            for (File actualFile : filesToAdd) {
                int count;
                log.debug("Agregando al zip: " + actualFile);
                FileInputStream fi = new FileInputStream(actualFile);
                origin = new BufferedInputStream(fi, 0x100000);
                ZipEntry entry = new ZipEntry(actualFile.getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 0x100000)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                if (!deleteAddedFiles) continue;
                actualFile.delete();
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return zipFileToCreate;
    }

    public static String expandOneFile(String compressedFile) throws IOException, ArchiveException {
        return FileToolkit.expandOneFile(compressedFile, null, CompressionFormat.ZIP);
    }

    public static String expandOneFile(String compressedFile, String expandedFile) throws IOException, ArchiveException {
        return FileToolkit.expandOneFile(compressedFile, expandedFile, CompressionFormat.ZIP);
    }

    public static String expandOneFile(String compressedFile, String expandedFile, CompressionFormat compressionFormat) throws IOException, ArchiveException {
        String extractedFileName = null;
        if (compressedFile.endsWith(FILE_EXTENSION_GZIP)) {
            int buffer = 20480;
            if (StringUtil.isEmpty(expandedFile)) {
                expandedFile = FileToolkit.getFileNameWithoutExtension(compressedFile, false);
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(expandedFile), 20480);
            GZIPInputStream in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(compressedFile)));
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)20480);
            out.close();
            in.close();
            extractedFileName = expandedFile;
        } else {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(compressedFile));
                 ArchiveInputStream archiveInputStream = FileToolkit.createArchiveInputStream(bufferedInputStream, FileToolkit.getFileExtension(compressedFile));){
                ArchiveEntry entry;
                while ((entry = archiveInputStream.getNextEntry()) != null && extractedFileName == null) {
                    if (!archiveInputStream.canReadEntryData(entry) || entry.isDirectory()) continue;
                    File entryFile = StringUtil.isNotEmpty(expandedFile) ? new File(expandedFile) : new File(Path.of(compressedFile, new String[0]).toAbsolutePath().getParent().toString(), entry.getName());
                    try (FileOutputStream out = new FileOutputStream(entryFile);){
                        IOUtils.copy((InputStream)archiveInputStream, (OutputStream)out);
                    }
                    extractedFileName = entryFile.getAbsolutePath();
                }
            }
        }
        return extractedFileName;
    }

    private static ArchiveInputStream createArchiveInputStream(InputStream inputStream, String fileExtension) throws IOException, ArchiveException {
        if (fileExtension.equals(FILE_EXTENSION_TAR_GZ) || fileExtension.equals(FILE_EXTENSION_TGZ)) {
            return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
        }
        return new ArchiveStreamFactory().createArchiveInputStream(fileExtension, inputStream);
    }

    public static byte[] gzipBytes(byte[] bytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream zipStream = new GZIPOutputStream(bos);
        zipStream.write(bytes);
        zipStream.close();
        return bos.toByteArray();
    }

    public static List<File> expandFiles(String compressedFile, boolean deleteOnSuccess) throws IOException, ArchiveException {
        ArrayList<File> expandedFiles = new ArrayList<File>();
        if (StringUtil.isEmpty(compressedFile) || !compressedFile.endsWith(FILE_EXTENSION_ZIP)) {
            log.warn("No es posible extraer los archivos de [" + compressedFile + "]");
            return expandedFiles;
        }
        log.debug("[expandFiles] Por extraer los archivos de [" + compressedFile + "]");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(compressedFile));
             ArchiveInputStream archiveInputStream = FileToolkit.createArchiveInputStream(bufferedInputStream, FileToolkit.getFileExtension(compressedFile));){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!archiveInputStream.canReadEntryData(entry) || entry.isDirectory()) continue;
                File entryFile = new File(Path.of(compressedFile, new String[0]).toAbsolutePath().getParent().toString(), entry.getName());
                try (FileOutputStream out = new FileOutputStream(entryFile);){
                    IOUtils.copy((InputStream)archiveInputStream, (OutputStream)out);
                }
                log.debug("[expandFiles] Archivo [" + entryFile.getName() + "] extraido correctamente");
                expandedFiles.add(entryFile);
            }
        }
        log.debug("[expandFiles] Se extrajeron " + expandedFiles.size() + " archivos. Fin de la extracion. " + (deleteOnSuccess ? "Procedo a eliminar el archivo comprimido" : "No se borra el archivo comprimido"));
        if (deleteOnSuccess && !new File(compressedFile).delete()) {
            log.warn("[expandFiles] No se pudo eliminar el archivo [" + compressedFile + "]");
        }
        return expandedFiles;
    }

    public static boolean isEmptyFile(String directory, String fileName) {
        File theFile = new File(directory, fileName);
        return theFile.length() == 0L;
    }

    public static StringBuilder cleanNamespaceProps(String filePath) {
        File file = new File(filePath);
        StringBuilder sb = new StringBuilder();
        FileReader fr = null;
        BufferedReader br = null;
        String line = null;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        try {
            while ((line = br.readLine()) != null) {
                if (line.contains("xmlns=")) {
                    Object out = "";
                    int init = line.indexOf("xmlns=");
                    out = (String)out + line.substring(0, init);
                    int end = line.indexOf("\"", init + 7) + 1;
                    out = (String)out + line.substring(end);
                    sb.append((String)out);
                    continue;
                }
                sb.append(line);
            }
            fr.close();
        }
        catch (IOException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return sb;
    }

    public static String concatPathKey(String path, String key) {
        String keyAux;
        String pathAux = path.substring(path.length() - 1, path.length());
        if (pathAux.equalsIgnoreCase(keyAux = key.substring(0, 1))) {
            if (!pathAux.equalsIgnoreCase("/")) {
                return path + "/" + key;
            }
            return path.substring(0, path.length() - 1) + key;
        }
        if (!pathAux.equalsIgnoreCase("/") && !keyAux.equalsIgnoreCase("/")) {
            return path + "/" + key;
        }
        return path + key;
    }

    public static String getFullPath(String path, String file, String dirSeparator) {
        return !path.endsWith(dirSeparator) ? path + dirSeparator + file : path + file;
    }

    public static String appendDirSeparator(String path, String dirSeparator) {
        return !path.endsWith(dirSeparator) ? path + dirSeparator : path;
    }

    public static File[] getDirectoryWithWildcard(String filePathWithWildcards, boolean includeDirectories) {
        String pathOnly = FileToolkit.getPathOnly(filePathWithWildcards);
        String fileName = FileToolkit.getFileName(filePathWithWildcards);
        File dir = new File(pathOnly);
        String pattern = fileName.replace("*", ".*").replace("?", ".");
        final Pattern compiledPattern = Pattern.compile(pattern);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return compiledPattern.matcher(pathname.getName()).find();
            }
        };
        return dir.listFiles(ff);
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindowsOS() {
        return FileToolkit.getOSName().startsWith("win");
    }

    public static boolean isLinuxOS() {
        return FileToolkit.getOSName().startsWith("lin");
    }

    public static String sanitizeFilename(String filename) {
        if (filename == null) {
            return null;
        }
        return StringUtil.sanitizeASCII(filename, false).replaceAll("[^\\p{ASCII}]", "_").replaceAll("[&]", "Y").replaceAll("[\"'`,+!@#$%^*()]", "").replaceAll("[\\\\/\\*\\? ]", "_");
    }

    public static String sanitizeFilenameFromFullPath(String fullPath) {
        if (FileToolkit.hasPathBars(fullPath)) {
            return FileToolkit.getPathOnly(fullPath, true) + FileToolkit.sanitizeFilename(FileToolkit.getFileName(fullPath));
        }
        return FileToolkit.sanitizeFilename(FileToolkit.getFileName(fullPath));
    }

    public static boolean hasPathBars(String fullPath) {
        return fullPath != null && (fullPath.indexOf("/") != -1 || fullPath.indexOf("\\") != -1);
    }

    public static void saveImage64ToFile(String image64, String imageType, File file) throws IOException {
        BufferedImage image = null;
        byte[] imageByte = Base64.getDecoder().decode(image64);
        ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
        image = ImageIO.read(bis);
        bis.close();
        ImageIO.write((RenderedImage)image, imageType, file);
    }

    public static boolean rename(String oldName, String newName) {
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        return oldFile.renameTo(newFile);
    }

    public static int executeScript(String[] args) {
        int exitValue = -1;
        log.debug("Por ejecutar script con parametros " + Arrays.toString(args).replace(',', ' '));
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            OutputExecToBuffer outputExecToBuffer = new OutputExecToBuffer();
            outputExecToBuffer.setProcessRunning(true);
            Process p = pb.start();
            outputExecToBuffer.setInputStream(p.getInputStream());
            outputExecToBuffer.start();
            p.waitFor();
            outputExecToBuffer.setProcessRunning(false);
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            log.error("Error en ejecucion de script", (Throwable)e);
        }
        return exitValue;
    }

    public static BigInteger toBytes(Long size, FileSizeUnits fileSizeUnits) {
        if (fileSizeUnits == null) {
            fileSizeUnits = FileSizeUnits.KB;
        }
        switch (fileSizeUnits) {
            case KB: {
                return BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(size));
            }
            case MB: {
                return BigInteger.valueOf(0x100000L).multiply(BigInteger.valueOf(size));
            }
            case GB: {
                return BigInteger.valueOf(0x40000000L).multiply(BigInteger.valueOf(size));
            }
            case TB: {
                return BigInteger.valueOf(0x10000000000L).multiply(BigInteger.valueOf(size));
            }
        }
        log.warn("[toBytes] No se pudo convertir el valor " + size + fileSizeUnits.name() + "a bytes. Devuelvo " + size);
        return BigInteger.valueOf(size);
    }

    public static BigDecimal bytesTo(long bytes, FileSizeUnits fileSizeUnitsTo) {
        if (fileSizeUnitsTo == null) {
            return NumberUtil.ZERO_SCALED;
        }
        switch (fileSizeUnitsTo) {
            case KB: {
                return BigDecimal.valueOf(bytes).divide(BigDecimal.valueOf(1024L), 2, RoundingMode.HALF_UP);
            }
            case MB: {
                return BigDecimal.valueOf(bytes).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.HALF_UP);
            }
            case GB: {
                return BigDecimal.valueOf(bytes).divide(BigDecimal.valueOf(0x40000000L), 2, RoundingMode.HALF_UP);
            }
            case TB: {
                return BigDecimal.valueOf(bytes).divide(BigDecimal.valueOf(0x10000000000L), 2, RoundingMode.HALF_UP);
            }
        }
        log.warn("[toBytes] No se pudo convertir el valor " + bytes + " bytes a " + fileSizeUnitsTo.name() + ". Devuelvo " + bytes);
        return BigDecimal.valueOf(bytes);
    }

    public static String encodeFileToBase64(String fileName) throws IOException {
        File file = new File(fileName);
        return Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)file));
    }

    public static File zipFile(File fileToZip) throws IOException {
        log.debug("[zipFile] Por zippear el archivo [" + fileToZip.getAbsolutePath() + "] a [" + fileToZip.getName() + ".zip]");
        byte[] buffer = new byte[1024];
        File zipFile = new File(fileToZip.getParentFile(), fileToZip.getName() + FILE_EXTENSION_ZIP);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);
             FileInputStream fis = new FileInputStream(fileToZip);){
            int len;
            ZipEntry ze = new ZipEntry(fileToZip.getName());
            zos.putNextEntry(ze);
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        log.debug("[zipFile] Archivo zippeado");
        return zipFile;
    }

    public static void deleteEmptyFile(String file) {
        File theFile = new File(file);
        if (!theFile.exists()) {
            return;
        }
        if (theFile.length() == 0L) {
            log.info("Se elimina file [" + file + "] por estar vacio");
            theFile.delete();
        }
    }

    public static void addLibraryPath(String libPath) {
        try {
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            String[] usrPaths = (String[])usrPathsField.get(null);
            boolean alreadyInPath = false;
            for (String path : usrPaths) {
                if (!path.equals(libPath)) continue;
                alreadyInPath = true;
            }
            if (!alreadyInPath) {
                String[] newPaths = Arrays.copyOf(usrPaths, usrPaths.length + 1);
                newPaths[newPaths.length - 1] = libPath;
                usrPathsField.set(null, newPaths);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum FileSizeUnits {
        KB,
        MB,
        GB,
        TB;

    }

    public static class OutputExecToBuffer
    extends Thread {
        private boolean processRunning;
        private InputStream inputStream;

        public void setProcessRunning(boolean processRunning) {
            this.processRunning = processRunning;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            while (this.processRunning) {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
                    while ((line = br.readLine()) != null) {
                        log.info(line);
                    }
                }
                catch (IOException e) {
                    log.error("Ha ocurrido un error", (Throwable)e);
                }
            }
        }
    }

    public static enum CompressionFormat {
        ZIP,
        GZIP;

    }
}

