/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.db;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.db.RangeExpresion;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.MatchMode;

public class QueryBuilder
implements Serializable {
    private static final long serialVersionUID = 5873238615031399220L;
    static Logger log = LogManager.getLogger(QueryBuilder.class);
    private static final int MAX_PARAMETERS = 50;
    private static final int MAX_IN_ARGUMENTS = 900;
    private ArrayList parameters = null;
    private ArrayList<String> optimizerHints = null;
    private ArrayList<String> selectPartExpr = null;
    private ArrayList<String> selectPartAlias = null;
    private StringBuilder fromPart = null;
    private StringBuilder wherePart = null;
    private StringBuilder groupByPart = null;
    private StringBuilder havingPart = null;
    private StringBuilder orderByPart = null;
    private ArrayList<QueryBuilder> unions = null;
    public static final String STRCONST_NULL = "$$NULL";

    public QueryBuilder() {
        this.reset();
    }

    public void reset() {
        this.parameters = new ArrayList();
        this.optimizerHints = new ArrayList();
        this.selectPartExpr = new ArrayList();
        this.selectPartAlias = new ArrayList();
        this.fromPart = new StringBuilder();
        this.wherePart = new StringBuilder();
        this.groupByPart = new StringBuilder();
        this.orderByPart = new StringBuilder();
        this.havingPart = new StringBuilder();
        this.unions = new ArrayList();
    }

    public void resetOrderBy() {
        this.orderByPart = new StringBuilder();
    }

    public QueryBuilder addUnion(QueryBuilder union) {
        this.unions.add(union);
        this.parameters.addAll(union.parameters);
        return this;
    }

    public QueryBuilder addParameter(Object parameter) {
        if (parameter instanceof Collection) {
            this.parameters.addAll((Collection)parameter);
        } else {
            this.parameters.add(parameter);
        }
        return this;
    }

    public QueryBuilder andCondition(String condition, Object ... parameters) {
        this.andCondition(condition);
        if (parameters != null) {
            for (Object parameter : parameters) {
                this.addParameter(parameter);
            }
        }
        return this;
    }

    public QueryBuilder andCondition(String condition) {
        if (this.wherePart.length() > 0) {
            this.wherePart.append(" AND ");
        }
        this.wherePart.append("(" + condition + ")");
        return this;
    }

    public QueryBuilder andCondition(String field, RangeExpresion rangeExpresion) {
        this.andCondition(rangeExpresion.getSQLFilter(field, false));
        this.addParameters(rangeExpresion.getSQLValues());
        return this;
    }

    public QueryBuilder andEquals(String expression, Object value) {
        return this.andCondition(expression + " = ?", value);
    }

    public QueryBuilder andLike(String expression, Object value) {
        return this.andLike(expression, value, true);
    }

    public QueryBuilder andLike(String expression, Object value, boolean escapeSpecialChars) {
        if (escapeSpecialChars) {
            return this.andCondition(expression + " LIKE ? ESCAPE '!'", QueryBuilder.getEscapedLike(value.toString()));
        }
        return this.andCondition(expression + " LIKE ? ", value.toString());
    }

    public QueryBuilder andNullOrIn(String expression, Collection values) {
        return this.andIn(expression, false, values, true);
    }

    public QueryBuilder andIn(String expression, Collection values) {
        boolean orNull = false;
        if (values != null) {
            orNull = values.remove(STRCONST_NULL);
        }
        return this.andIn(expression, false, values, orNull);
    }

    public QueryBuilder andNotIn(String expression, Collection values) {
        boolean orNull = false;
        if (values != null) {
            orNull = values.remove(STRCONST_NULL);
        }
        return this.andIn(expression, true, values, orNull);
    }

    public static String conditionAndIn(String expression, boolean not, Collection values, boolean orNull) {
        ArrayList valuesArrayList = new ArrayList(values);
        StringBuilder condition = new StringBuilder();
        if (valuesArrayList.size() == 0) {
            condition.append(expression);
            condition.append(" is null ");
        } else if (!valuesArrayList.contains("*")) {
            if (valuesArrayList.size() == 1) {
                condition.append("(");
                if (orNull) {
                    condition.append(expression);
                    condition.append(" is null or ");
                }
                condition.append(expression);
                condition.append(not ? "!=" : "=");
                condition.append("'" + valuesArrayList.get(0) + "'");
                condition.append(")");
            } else {
                condition.append("(");
                if (orNull) {
                    condition.append(expression);
                    condition.append(" is null or ");
                }
                condition.append(expression);
                condition.append(not ? " NOT " : "");
                condition.append(" IN (");
                Iterator valuesIterator = valuesArrayList.iterator();
                String separator = "";
                while (valuesIterator.hasNext()) {
                    Object value = valuesIterator.next();
                    condition.append(separator).append("'" + value + "'");
                    separator = ",";
                }
                condition.append(")");
                condition.append(")");
            }
        }
        return condition.toString();
    }

    private QueryBuilder andIn(String expression, boolean not, Collection values, boolean orNull) {
        ArrayList valuesArrayList = new ArrayList(values);
        if (valuesArrayList.size() == 0) {
            StringBuilder condition = new StringBuilder();
            condition.append(expression);
            condition.append(" is null ");
        } else if (!valuesArrayList.contains("*")) {
            if (valuesArrayList.size() == 1) {
                StringBuilder condition = new StringBuilder();
                condition.append("(");
                if (orNull) {
                    condition.append(expression);
                    condition.append(" is null or ");
                }
                condition.append(expression);
                condition.append(not ? "!=" : "=");
                condition.append("?");
                condition.append(")");
                this.andCondition(condition.toString(), valuesArrayList.get(0));
            } else {
                StringBuilder condition = new StringBuilder();
                condition.append("(");
                if (orNull) {
                    condition.append(expression);
                    condition.append(" is null or ");
                }
                condition.append(expression);
                condition.append(not ? " NOT " : "");
                condition.append(" IN (");
                Iterator valuesIterator = valuesArrayList.iterator();
                String separator = "";
                while (valuesIterator.hasNext()) {
                    Object value = valuesIterator.next();
                    condition.append(separator).append("?");
                    this.addParameter(value);
                    separator = ",";
                }
                condition.append(")");
                condition.append(")");
                this.andCondition(condition.toString());
            }
        }
        return this;
    }

    private QueryBuilder andFilterDateRange(String dateField, String optionalDateFrom, String optionalDateTo, boolean withNull) throws ParseException {
        String cond;
        if (!StringUtil.isEmpty(optionalDateFrom)) {
            cond = dateField + " >= " + this.getDateExpression(optionalDateFrom);
            if (withNull) {
                cond = "(" + cond + " OR " + dateField + " is null)";
            }
            this.andCondition(cond);
        }
        if (!StringUtil.isEmpty(optionalDateTo)) {
            cond = dateField + " <= " + this.getDateExpression(optionalDateTo);
            if (withNull) {
                cond = "(" + cond + " OR " + dateField + " is null)";
            }
            this.andCondition(cond);
        }
        return this;
    }

    public QueryBuilder andFilterDateRange(String dateField, String optionalDateFrom, String optionalDateTo) throws ParseException {
        return this.andFilterDateRange(dateField, optionalDateFrom, optionalDateTo, false);
    }

    public QueryBuilder andFilterDateRangeWithNull(String dateField, String optionalDateFrom, String optionalDateTo) throws ParseException {
        return this.andFilterDateRange(dateField, optionalDateFrom, optionalDateTo, true);
    }

    public QueryBuilder andFilterDateRange(String dateField, java.util.Date optionalDateFrom, java.util.Date optionalDateTo) throws ParseException {
        String dateFrom = optionalDateFrom != null ? DateUtil.dateToString(optionalDateFrom, "dd/MM/yyyy") : null;
        String dateTo = optionalDateTo != null ? DateUtil.dateToString(optionalDateTo, "dd/MM/yyyy") : null;
        return this.andFilterDateRange(dateField, dateFrom, dateTo, false);
    }

    public QueryBuilder andFilterDateRangeWithNull(String dateField, java.util.Date optionalDateFrom, java.util.Date optionalDateTo) throws ParseException {
        String dateFrom = optionalDateFrom != null ? DateUtil.dateToString(optionalDateFrom, "dd/MM/yyyy") : null;
        String dateTo = optionalDateTo != null ? DateUtil.dateToString(optionalDateTo, "dd/MM/yyyy") : null;
        return this.andFilterDateRange(dateField, dateFrom, dateTo, true);
    }

    public QueryBuilder andFilterDateRange(String dateField, String optionalDateFrom, int deltaFrom, String optionalDateTo, int deltaTo) throws ParseException {
        if (!StringUtil.isEmpty(optionalDateFrom)) {
            this.andCondition(dateField + " >= " + QueryBuilder.getLiteralDateExpression(optionalDateFrom) + " - " + deltaFrom);
        }
        if (!StringUtil.isEmpty(optionalDateTo)) {
            this.andCondition(dateField + " <= " + QueryBuilder.getLiteralDateExpression(optionalDateTo) + " + " + deltaTo);
        }
        return this;
    }

    private QueryBuilder andFilterTimestampRange(String timestampField, String optionalTimestampFrom, String optionalTimestampTo, boolean withNull) throws ParseException {
        String cond;
        if (!StringUtil.isEmpty(optionalTimestampFrom)) {
            cond = timestampField + " >= " + this.getTimestampExpression(optionalTimestampFrom, false);
            if (withNull) {
                cond = "(" + cond + " OR " + timestampField + " is null)";
            }
            this.andCondition(cond);
        }
        if (!StringUtil.isEmpty(optionalTimestampTo)) {
            cond = timestampField + " <= " + this.getTimestampExpression(optionalTimestampTo, false);
            if (withNull) {
                cond = "(" + cond + " OR " + timestampField + " is null)";
            }
            this.andCondition(cond);
        }
        return this;
    }

    public QueryBuilder andFilterTimestampRange(String timestampField, String optionalTimestampFrom, String optionalTimestampTo) throws ParseException {
        return this.andFilterTimestampRange(timestampField, optionalTimestampFrom, optionalTimestampTo, false);
    }

    public QueryBuilder andFilterTimestampRangeWithNull(String timestampField, String optionalTimestampFrom, String optionalTimestampTo) throws ParseException {
        return this.andFilterTimestampRange(timestampField, optionalTimestampFrom, optionalTimestampTo, true);
    }

    public QueryBuilder andFilterIn(String expression, Collection values) {
        if (values != null && values.size() > 0) {
            this.andIn(expression, values);
        }
        return this;
    }

    public QueryBuilder andFilterNotIn(String expression, Collection values) {
        if (values != null && values.size() > 0) {
            this.andNotIn(expression, values);
        }
        return this;
    }

    public QueryBuilder andFilterTimestampRangeAsDate(String dateField, String optionalDateFrom, String optionalDateTo) throws ParseException {
        if (!StringUtil.isEmpty(optionalDateFrom)) {
            if (!StringUtil.isEmpty(optionalDateTo)) {
                this.andCondition(dateField + " BETWEEN " + QueryBuilder.getLiteralDateExpression(optionalDateFrom) + " AND " + QueryBuilder.getLiteralDateExpression(optionalDateTo) + "+1");
            } else {
                this.andCondition(dateField + " >= " + QueryBuilder.getLiteralDateExpression(optionalDateFrom));
            }
        } else if (!StringUtil.isEmpty(optionalDateTo)) {
            this.andCondition(dateField + " <= " + QueryBuilder.getLiteralDateExpression(optionalDateTo) + "+1");
        }
        return this;
    }

    public QueryBuilder andFilterLike(String textField, String optionalText) {
        if (!StringUtil.isEmpty(optionalText)) {
            RangeExpresion reField = new RangeExpresion(optionalText.trim());
            this.andCondition(textField, reField);
        }
        return this;
    }

    public QueryBuilder andFilterNotLike(String textField, String optionalText) {
        if (!StringUtil.isEmpty((String)optionalText)) {
            optionalText = "%" + QueryBuilder.getEscapedLike(((String)optionalText).toUpperCase().trim()) + "%";
            this.andCondition("UPPER(" + textField + ") NOT like ? ESCAPE '!'", optionalText);
        }
        return this;
    }

    public QueryBuilder andFilterEquals(String textField, String optionalText) {
        if (!StringUtil.isEmptyNull(optionalText)) {
            this.andEquals(textField, optionalText);
        }
        return this;
    }

    public QueryBuilder andFilterCondition(String fieldExpresion, String optionalText) {
        if (!StringUtil.isEmpty(optionalText)) {
            this.andCondition(fieldExpresion, optionalText);
        }
        return this;
    }

    public QueryBuilder optimizerHint(String hint) {
        this.optimizerHints.add(hint);
        return this;
    }

    public QueryBuilder select(String exprList, String alias) {
        this.selectPartExpr.add(exprList);
        this.selectPartAlias.add(StringUtil.nonNull(alias).replace(' ', '_'));
        return this;
    }

    public QueryBuilder select(String exprList) {
        return this.select(exprList, null);
    }

    public QueryBuilder from(String tableName, String alias) {
        if (this.fromPart.length() > 0) {
            this.fromPart.append(", ");
        }
        this.fromPart.append(tableName);
        if (alias != null) {
            this.fromPart.append(" ").append(alias);
        }
        return this;
    }

    public QueryBuilder from(QueryBuilder subQuery) {
        this.addParameter(subQuery.getParameters());
        return this.from("( " + subQuery.toString() + ")");
    }

    public QueryBuilder from(QueryBuilder subQuery, String alias) {
        this.addParameter(subQuery.getParameters());
        return this.from("( " + subQuery.toString() + " )", alias);
    }

    public QueryBuilder from(String tableName) {
        return this.from(tableName, null);
    }

    public QueryBuilder groupBy(String exprList) {
        if (this.groupByPart.length() > 0) {
            this.groupByPart.append(", ");
        }
        this.groupByPart.append(exprList);
        return this;
    }

    public QueryBuilder orderBy(String exprList) {
        if (this.orderByPart.length() > 0) {
            this.orderByPart.append(", ");
        }
        this.orderByPart.append(exprList);
        return this;
    }

    public QueryBuilder having(String havingExpr) {
        if (this.havingPart.length() > 0) {
            this.havingPart.append(" AND ");
        }
        this.havingPart.append(havingExpr);
        return this;
    }

    public void addParameters(Collection params) {
        this.parameters.addAll(params);
    }

    public Collection getParameters() {
        return this.parameters;
    }

    private int createQuerySetParameters(int startIndex, PreparedStatement stmt) throws SQLException {
        int i;
        int n = this.parameters.size();
        for (i = 0; i < n; ++i) {
            stmt.setObject(startIndex + i, this.parameters.get(i));
        }
        return startIndex + i;
    }

    public PreparedStatement createQuery(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.toString());
        int startIndex = 1;
        if (this.unions.size() == 0) {
            this.createQuerySetParameters(startIndex, stmt);
        } else {
            for (QueryBuilder union : this.unions) {
                startIndex = union.createQuerySetParameters(startIndex, stmt);
            }
        }
        return stmt;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.unions.size() == 0) {
            if (this.selectPartExpr != null) {
                int i;
                result.append("SELECT ");
                if (this.optimizerHints.size() > 0) {
                    result.append("/*+");
                    for (i = 0; i < this.optimizerHints.size(); ++i) {
                        result.append(this.optimizerHints.get(i)).append(" ");
                    }
                    result.append("*/");
                }
                if (this.selectPartExpr.size() == 0) {
                    result.append("*");
                } else {
                    for (i = 0; i < this.selectPartExpr.size(); ++i) {
                        if (i != 0) {
                            result.append(", ");
                        }
                        result.append(this.selectPartExpr.get(i));
                        if (StringUtil.isEmpty(this.selectPartAlias.get(i))) continue;
                        result.append(" AS ");
                        result.append(this.selectPartAlias.get(i));
                    }
                }
                if (this.fromPart.length() == 0) {
                    result.append(" FROM DUAL");
                } else {
                    result.append(" FROM ").append((CharSequence)this.fromPart);
                }
                if (this.wherePart.length() > 0) {
                    result.append(" WHERE ").append((CharSequence)this.wherePart);
                }
                if (this.groupByPart.length() > 0) {
                    result.append(" GROUP BY ").append((CharSequence)this.groupByPart);
                }
                if (this.havingPart.length() > 0) {
                    result.append(" HAVING ").append((CharSequence)this.havingPart);
                }
                if (this.orderByPart.length() > 0) {
                    result.append(" ORDER BY ").append((CharSequence)this.orderByPart);
                }
            }
        } else {
            String connector = "";
            for (QueryBuilder union : this.unions) {
                result.append(connector);
                result.append("(" + union.toString() + ")");
                connector = " union all ";
            }
            if (this.orderByPart.length() > 0) {
                result.append(" ORDER BY ").append((CharSequence)this.orderByPart);
            }
        }
        String query = result.toString();
        log.trace(query);
        return query;
    }

    public String toStringWithParameters() {
        StringBuilder sb = new StringBuilder(this.toString());
        for (int i = 0; i < this.parameters.size(); ++i) {
            sb.append(" (").append(i).append(")= ").append(this.parameters.get(i)).append(" |");
        }
        return sb.toString();
    }

    public static String getEscapedLike(String likeValue) {
        likeValue = likeValue.replaceAll("[!]", "!!");
        likeValue = likeValue.replaceAll("[%]", "!%");
        likeValue = likeValue.replaceAll("[_]", "!_");
        return likeValue;
    }

    public static String getEscapedString(String value) {
        value = value.replaceAll("[']", "''");
        return value;
    }

    public String getDateExpression(String dateValue) throws ParseException {
        if (StringUtil.isEmptyNull(dateValue)) {
            return null;
        }
        Date date = DateUtil.parseDate(dateValue);
        if (date == null) {
            throw new ParseException("Fecha '" + dateValue + "' invalida", 0);
        }
        dateValue = DateUtil.dateToString((java.util.Date)date);
        this.addParameter(dateValue);
        return "TO_DATE(?, '" + DateUtil.getFormat() + "')";
    }

    public static String getLiteralDateExpression(String dateValue) throws ParseException {
        if (StringUtil.isEmpty(dateValue) || dateValue.equalsIgnoreCase("null")) {
            return null;
        }
        Date date = DateUtil.parseDate(dateValue);
        if (date == null) {
            throw new ParseException("Fecha '" + dateValue + "' invalida", 0);
        }
        dateValue = DateUtil.dateToString((java.util.Date)date);
        return "TO_DATE('" + dateValue + "', '" + DateUtil.getFormat() + "')";
    }

    public String getTimestampExpression(String timestampValue, boolean useLiteral) throws ParseException {
        if (StringUtil.isEmptyNull(timestampValue)) {
            return null;
        }
        java.util.Date date = DateUtil.parseDate(timestampValue, "dd/MM/yyyy HH:mm:ss");
        if (date == null) {
            throw new ParseException("Fecha y hora '" + timestampValue + "' invalida", 0);
        }
        timestampValue = DateUtil.dateToString(date, "dd/MM/yyyy HH:mm:ss");
        if (useLiteral) {
            return "TO_TIMESTAMP('" + timestampValue + "', 'dd/MM/yyyy HH24:MI:SS')";
        }
        this.addParameter(timestampValue);
        return "TO_TIMESTAMP(?, 'dd/MM/yyyy HH24:MI:SS')";
    }

    public static String queryOrCollection(Collection<?> col, String field) {
        return QueryBuilder.queryOrCollection(col, field, false);
    }

    public static String queryOrCollection(Collection<?> col, String field, boolean addParenthesis) {
        StringBuilder query = new StringBuilder("(");
        String and = "";
        boolean hasNull = false;
        if (QueryBuilder.isNullParamCollection(col)) {
            hasNull = true;
        } else {
            for (Object colElem : col) {
                query.append(and);
                if (addParenthesis) {
                    query.append(" ( ");
                }
                query.append(field).append(" = ?");
                if (addParenthesis) {
                    query.append(" ) ");
                }
                and = " OR ";
                hasNull = hasNull || colElem == null || "NULL".equalsIgnoreCase(colElem.toString());
            }
        }
        if (hasNull) {
            query.append(and);
            if (addParenthesis) {
                query.append(" ( ");
            }
            query.append(field).append(" IS NULL");
            if (addParenthesis) {
                query.append(" ) ");
            }
        }
        query.append(")");
        return query.toString();
    }

    public static String queryOrCollectionWithMaxParameters(Collection<String> col, String field) {
        if (col.size() < 50) {
            return QueryBuilder.queryOrCollection(col, field);
        }
        return QueryBuilder.queryINCollection(col, field);
    }

    public static int addParametersToCollectionWithMaxParameters(Collection<Long> colId, PreparedStatement stmt, int i, boolean debugAll, StringBuilder debugParameters, String debugParameterSeparator) throws SQLException {
        if (colId.size() < 50) {
            for (Long id : colId) {
                stmt.setLong(i++, id);
                if (!debugAll) continue;
                debugParameters.append(debugParameterSeparator).append(i - 1).append(": ").append(id);
            }
        }
        return i;
    }

    public static int addParametersToCollectionWithMaxParameters(Collection<Long> colId, PreparedStatement stmt, int i, boolean debugAll, List<Pair<String, Class<?>>> debugParameters, String debugParameterSeparator) throws SQLException {
        if (colId.size() < 50) {
            for (Long id : colId) {
                stmt.setLong(i++, id);
                if (!debugAll) continue;
                debugParameters.add(Pair.of((Object)id.toString(), Long.class));
            }
        }
        return i;
    }

    public static String queryNorCollection(Collection col, String field) {
        Object query = "(";
        String and = "";
        for (int i = 0; i < col.size(); ++i) {
            query = (String)query + and + field + " != ?";
            and = " AND ";
        }
        query = (String)query + ")";
        return query;
    }

    public static String queryINCollection(String[] col, String field) {
        List<String> asList = Arrays.stream(col).collect(Collectors.toList());
        return QueryBuilder.queryINCollection(asList, field);
    }

    public static String queryNotINCollection(String[] col, String field) {
        StringBuilder query = new StringBuilder();
        String sep = " ";
        query.append("(");
        query.append(field).append(" not in (");
        int count = 0;
        for (String aCol : col) {
            if (++count == 900) {
                count = 0;
                query.append(" ) or ").append(field).append(" not in (");
                sep = "";
            }
            query.append(sep).append("'").append(aCol).append("'");
            sep = ",";
        }
        query.append(")");
        query.append(")");
        return query.toString();
    }

    public static String queryINCollection(Collection<String> col, String field) {
        StringBuilder query = new StringBuilder();
        String sep = " ";
        query.append("(");
        query.append(field).append(" in (");
        int count = 0;
        for (String aCol : col) {
            if (++count == 900) {
                count = 0;
                query.append(" ) or ").append(field).append(" in (");
                sep = "";
            }
            query.append(sep).append("'").append(aCol).append("'");
            sep = ",";
        }
        query.append(")");
        query.append(")");
        return query.toString();
    }

    public static String queryINCollectionLong(Collection<Long> col, String field) {
        StringBuilder query = new StringBuilder();
        String sep = " ";
        query.append("(");
        query.append(field).append(" in (");
        int count = 0;
        for (Long aCol : col) {
            if (++count == 900) {
                count = 0;
                query.append(" ) or ").append(field).append(" in (");
                sep = "";
            }
            query.append(sep).append(aCol);
            sep = ",";
        }
        query.append(")");
        query.append(")");
        return query.toString();
    }

    public static String queryExpresionFilter(String expresion, String field) {
        Object query = "";
        if (!StringUtil.isEmpty(expresion)) {
            String[] expr;
            if ((expresion = expresion.trim()).startsWith("!")) {
                query = (String)query + " NOT ";
                expresion = expresion.substring(1);
            }
            query = (expr = StringUtil.split(expresion, ',')).length == 1 ? (String)query + field + " LIKE '%" + QueryBuilder.getEscapedLike(expr[0]) + "%' ESCAPE '!'" : (String)query + QueryBuilder.queryINCollection(expr, field);
        }
        return query;
    }

    public QueryBuilder transformSumarizeOnPivotDate(String sumarizeGroup, String pivot, String pivotDateValue, Map<String, Object> agregateMap) throws ParseException {
        if (StringUtil.isEmpty(pivotDateValue)) {
            return this;
        }
        QueryBuilder qba = new QueryBuilder();
        qba.optimizerHints = new ArrayList<String>(this.optimizerHints);
        qba.selectPartExpr = new ArrayList<String>(this.selectPartExpr);
        qba.selectPartAlias = new ArrayList<String>(this.selectPartAlias);
        for (Map.Entry<String, Object> entry : agregateMap.entrySet()) {
            int i = qba.selectPartAlias.indexOf(entry.getKey());
            if (i == -1) {
                log.error("Alias inexistente:" + entry.getKey());
                continue;
            }
            if (((String)entry.getValue()).startsWith("FIX")) {
                String[] fix = ((String)entry.getValue()).split("[:]");
                if (fix[0].equalsIgnoreCase("FIX_STRING")) {
                    qba.selectPartExpr.set(i, "'" + fix[1] + "'");
                    continue;
                }
                if (!fix[0].equalsIgnoreCase("FIX_INTEGER")) continue;
                qba.selectPartExpr.set(i, fix[1]);
                continue;
            }
            qba.selectPartExpr.set(i, "max('" + entry.getValue() + "')");
        }
        qba.fromPart = new StringBuilder(this.fromPart);
        qba.wherePart = new StringBuilder(this.wherePart);
        qba.parameters.addAll(this.parameters);
        qba.andCondition(pivot + " <= " + QueryBuilder.getLiteralDateExpression(pivotDateValue));
        qba.groupByPart = new StringBuilder(sumarizeGroup);
        qba.havingPart = new StringBuilder(this.havingPart);
        QueryBuilder qbb = new QueryBuilder();
        qbb.optimizerHints = new ArrayList<String>(this.optimizerHints);
        qbb.selectPartExpr = new ArrayList<String>(this.selectPartExpr);
        qbb.selectPartAlias = new ArrayList<String>(this.selectPartAlias);
        qbb.fromPart = new StringBuilder(this.fromPart);
        qbb.wherePart = new StringBuilder(this.wherePart);
        qbb.parameters.addAll(this.parameters);
        qbb.andCondition(pivot + " >  " + QueryBuilder.getLiteralDateExpression(pivotDateValue));
        qbb.groupByPart = new StringBuilder(this.groupByPart);
        qbb.havingPart = new StringBuilder(this.havingPart);
        QueryBuilder qb = new QueryBuilder();
        qb.addUnion(qba);
        qb.addUnion(qbb);
        qb.orderByPart = this.orderByPart;
        return qb;
    }

    public static String getSQL(String query, List<Pair<String, Class<?>>> debugParams) {
        while (query.contains("  ")) {
            query = query.replaceAll(" +", " ");
        }
        for (Pair<String, Class<?>> paramPair : debugParams) {
            String param = (String)paramPair.getKey();
            Class paramClass = (Class)paramPair.getValue();
            param = StringUtil.nonNull(param);
            if (paramClass.equals(Timestamp.class)) {
                param = param.replaceAll("\\.\\d+", "");
                query = query.replaceFirst("[?]", "TO_TIMESTAMP('" + param.trim() + "', 'YYYY-MM-DD HH24:MI:SS')");
                continue;
            }
            if (paramClass.equals(java.util.Date.class)) {
                query = query.replaceFirst("[?]", "TO_DATE('" + param.trim() + "', 'YYYY-MM-DD')");
                continue;
            }
            if (paramClass.equals(Integer.class) || paramClass.equals(Long.class) || paramClass.equals(Double.class)) {
                query = query.replaceFirst("[?]", param.trim());
                continue;
            }
            if (paramClass.equals(String.class)) {
                query = query.replaceFirst("[?]", "'" + param.trim() + "'");
                continue;
            }
            throw new ApplicationException("No se reconoce el tipo de parametro [" + paramClass + "]");
        }
        return query;
    }

    public static Pair<String, MatchMode> resolveLikeParam(String value) {
        MatchMode matchMode = MatchMode.ANYWHERE;
        if (value.startsWith("%")) {
            value = value.substring(1);
            matchMode = MatchMode.END;
        }
        if (value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
            matchMode = matchMode.equals((Object)MatchMode.END) ? MatchMode.ANYWHERE : MatchMode.START;
        }
        return Pair.of((Object)value, (Object)matchMode);
    }

    public static boolean isNullParamCollection(Collection<?> params) {
        if (params != null && params.size() == 1) {
            Object paramValue = params.iterator().next();
            return paramValue == null || "NULL".equalsIgnoreCase(paramValue.toString());
        }
        return false;
    }
}

