/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.BatchProcessorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatchProcessor {
    private static Logger log = LogManager.getLogger(BatchProcessor.class);
    private boolean oldAutoCommit;
    private String dataSourceName;
    private Context jndiContext;
    private DataSource dataSource = null;
    private Connection connection = null;
    private PreparedStatement preparedStmt = null;
    private String sqlQuery = null;

    public BatchProcessor(Context jndiContext, String dataSourceName) {
        this.jndiContext = jndiContext;
        this.dataSourceName = dataSourceName;
    }

    public BatchProcessor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void beginBatch(String sql) {
        if (this.sqlQuery != null && !this.sqlQuery.equals(sql)) {
            this.cleanUp();
        }
        this.sqlQuery = sql;
    }

    public void commitBatch() {
        if (this.connection != null) {
            try {
                if (this.preparedStmt != null) {
                    this.preparedStmt.executeBatch();
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new BatchProcessorException("Problemas al realizar el commit del DS [" + this.dataSourceName + "]: " + e, e);
            }
        }
    }

    public void rollbackBatch() {
        if (this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new BatchProcessorException("Problemas al realizar el rollback del DS [" + this.dataSourceName + "]: " + e, e);
            }
        }
    }

    public void close() {
        this.rollbackBatch();
        this.cleanUp();
    }

    public void execute(Object[] params) {
        PreparedStatement stmt = this.getPreparedStatement();
        try {
            int nullType = 12;
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    stmt.setNull(i + 1, nullType);
                    continue;
                }
                stmt.setObject(i + 1, params[i]);
            }
            stmt.addBatch();
        }
        catch (SQLException e) {
            throw new BatchProcessorException("Problemas al ejecutar batch sobre el datasource [" + this.dataSourceName + "]: " + e, e);
        }
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    private PreparedStatement getPreparedStatement() throws BatchProcessorException {
        if (this.preparedStmt == null) {
            try {
                this.preparedStmt = this.getConnection().prepareStatement(this.sqlQuery);
            }
            catch (SQLException e) {
                throw new BatchProcessorException("Problemas al preparar el statement datasource [" + this.dataSourceName + "]: " + e, e);
            }
        }
        return this.preparedStmt;
    }

    private DataSource getDataSource() throws BatchProcessorException {
        if (this.dataSource == null) {
            try {
                Object fullDataSourceName = this.dataSourceName.startsWith("java:") ? this.dataSourceName : "java:comp/env/jdbc/" + this.dataSourceName;
                this.dataSource = (DataSource)this.jndiContext.lookup((String)fullDataSourceName);
            }
            catch (NamingException e) {
                throw new BatchProcessorException("Problemas al localizar el datasource [" + this.dataSourceName + "]: " + e, e);
            }
        }
        return this.dataSource;
    }

    private Connection getConnection() throws BatchProcessorException {
        if (this.connection == null) {
            try {
                this.connection = this.getDataSource().getConnection();
                this.oldAutoCommit = this.connection.getAutoCommit();
                if (this.oldAutoCommit) {
                    this.connection.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                throw new BatchProcessorException("Problemas al obtener la conexion del DS [" + this.dataSourceName + "]: " + e, e);
            }
        }
        return this.connection;
    }

    private void cleanUp() {
        if (this.preparedStmt != null) {
            try {
                this.preparedStmt.close();
            }
            catch (SQLException e) {
                log.error("Ha ocurrido un error", (Throwable)e);
            }
        }
        this.preparedStmt = null;
        if (this.connection != null) {
            try {
                if (this.oldAutoCommit) {
                    this.connection.setAutoCommit(this.oldAutoCommit);
                }
                this.connection.close();
            }
            catch (SQLException e) {
                log.error("Ha ocurrido un error", (Throwable)e);
            }
        }
        this.connection = null;
    }
}

