/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import java.util.Iterator;

public class Partit
implements Iterator {
    int n;
    int curPart;
    int maxpart;
    Partit trail;
    boolean composit;

    public Partit(int n, boolean doComposit) {
        this(n, 1, n, doComposit);
    }

    public Partit(int n) {
        this(n, false);
    }

    public Partit(int n, int minp, int maxp, boolean doComposit) {
        this.n = n;
        this.curPart = minp;
        this.maxpart = maxp;
        this.trail = this.curPart >= n || this.curPart > this.maxpart ? null : new Partit(n - this.curPart, this.curPart, maxp, doComposit);
        this.composit = doComposit;
    }

    public Partit(int n, int minp, int maxp) {
        this(n, minp, maxp, false);
    }

    public static int max(int[] parts) {
        int m = 0;
        for (int i = 0; i < parts.length; ++i) {
            m = Math.max(m, parts[i]);
        }
        return m;
    }

    public static int frequency(int[] parts, int n) {
        int f = 0;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] != n) continue;
            ++f;
        }
        return f;
    }

    public static int frequencyMin(int[] parts, int m) {
        int f = 0;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] < m) continue;
            ++f;
        }
        return f;
    }

    public static int[] conjugate(int[] parts) {
        int mxpart = Partit.max(parts);
        int[] conj = new int[mxpart];
        for (int m = mxpart; m >= 1; --m) {
            conj[mxpart - m] = Partit.frequencyMin(parts, m);
        }
        return conj;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.n > 0 && this.curPart <= this.n && this.curPart <= this.maxpart;
    }

    public int[] next() {
        if (this.curPart == this.n && this.curPart <= this.maxpart) {
            int[] parts = new int[]{this.curPart++};
            this.trail = null;
            return parts;
        }
        if (this.trail != null) {
            int[] cnext = this.trail.next();
            if (cnext != null) {
                int[] parts = new int[cnext.length + 1];
                parts[0] = this.curPart;
                for (int i = 1; i < parts.length; ++i) {
                    parts[i] = cnext[i - 1];
                }
                return parts;
            }
            if (this.curPart < this.n && this.curPart < this.maxpart) {
                ++this.curPart;
                this.trail = new Partit(this.n - this.curPart, this.composit ? 1 : this.curPart, this.maxpart, this.composit);
                return this.next();
            }
            return null;
        }
        return null;
    }

    public int[] current() {
        if (this.curPart > this.maxpart) {
            return null;
        }
        if (this.curPart == this.n) {
            int[] parts = new int[]{this.curPart};
            return parts;
        }
        if (this.trail != null) {
            int[] cnext = this.trail.current();
            int[] parts = new int[cnext.length + 1];
            parts[0] = this.curPart;
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = cnext[i - 1];
            }
            return parts;
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            int i;
            int[] p;
            int n;
            int m = n = new Integer(args[0]).intValue();
            if (args.length > 1) {
                m = new Integer(args[1]);
            }
            Partit pofn = new Partit(n, 1, m);
            int N = 0;
            while ((p = pofn.next()) != null) {
                ++N;
                for (i = 0; i < p.length && p[i] > 0; ++i) {
                    System.out.print(" " + p[i]);
                }
                System.out.println();
            }
            System.out.println("# " + N);
            pofn = new Partit(n, 1, m, true);
            N = 0;
            while ((p = pofn.next()) != null) {
                ++N;
                for (i = 0; i < p.length && p[i] > 0; ++i) {
                    System.out.print(" " + p[i]);
                }
                System.out.println();
            }
            System.out.println("# " + N);
        }
    }
}

