package ar.com.sdd.commons.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import javax.ejb.ApplicationException;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * AbstractRuntimeException - Excepcion de Runtime base otras excepciones.
 * @author esteban@sdd
 * @date 11/03/2002
 */
@ApplicationException
public abstract class AbstractRuntimeException extends RuntimeException implements NestedException, Serializable {
	
	private static final Logger log = LogManager.getLogger(AbstractRuntimeException.class);

    private static final long serialVersionUID = 1L;

    static private ResourceBundle resource = null;

    /**
     * Recursos de la excepcion (Codigos, mensajes y etc.)
     * Es recomendable que no se cargue un ResourceBundle c/ vez que
     * se llama a este metodo, sino que devuelva un objeto previamente
     * instanciado.
     * @returns ResourceBundle
     */
	static public ResourceBundle getResourceBundle() {
    	return resource;
	}

    //---- Metodos y variables de instancia ---------------------------------------------//

    protected Object[] params  = null;
    protected Throwable detail = null;

    public AbstractRuntimeException() {}

    public AbstractRuntimeException(String msg) {
        this(msg, null, null);
    }

    public AbstractRuntimeException(String msg, Object[] params) {
        this(msg, params, null);
    }

    public AbstractRuntimeException(String msg, Object param) {
		this(msg, new Object[] {param});
	}

	public AbstractRuntimeException(String msg, Object param1, Object param2) {
        this(msg, new Object[] {param1, param2});
	}

    public AbstractRuntimeException(Throwable detail) {
        this(detail.getMessage(), null, detail);
    }

    public AbstractRuntimeException(String msg, Throwable detail) {
        this(msg, null, detail);
    }

    public AbstractRuntimeException(String msg, Object[] params, Throwable detail) {
        super(msg, detail);
        this.detail = detail;
        this.params = params;

        if (getLoggeable()) {
            dump();
        }
    }

    /**
     * La excepcion debe generar un log?
     * @returns boolean True si la excepcion se logea
     */
    protected boolean getLoggeable() {
        return false;
    }

    /**
     * La excepcion es fatal (panic)
     * @returns boolean True si la excepcion es fatal
     */
    protected boolean getFatal() {
        return false;
    }

    /**
     * Detalle de la excepcion.
     * @returns Throwable
     */
    public Throwable getDetail() {
        return detail;
    }

    /**
     * Detalle base de la excepcion (si tiene multiples detalles)
     * @returns Throwable
     */
    public Throwable getRootDetail() {
        return ExceptionUtil.getRootException( getDetail() );
    }

    /**
     * Devuelve el mensaje de error. Si hay un codigo establecido para el en
     * el archivo de resource, obtiene el String asociado.
     * NOTA: si no se desea la "traduccion", usar getMessage().
     * @deprecated no se deberia utilizar mas este metodo
     */
    @Deprecated
    public String getLocalizedMessage() {
		String ret;
		String key = super.getMessage();

		ResourceBundle resource = AbstractRuntimeException.getResourceBundle();
		if (resource != null) {

			try {

		    	if (key != null) {
		        	String msg = resource.getString(key);
		        	ret = (msg != null ? msg : key);
		    	} else {
		        	ret = key;
		    	}

		    } catch (MissingResourceException ex) {
		    	// Si no encuentra el resource, directamente devuelve la 'key'
		    	ret = key;
		    	log.error("Ha ocurrido un error", ex);
			}

		} else {
		    ret = super.getMessage();
		}

		return ret;
	}

    private void dump() {
        Logger log = LogManager.getLogger(this.getClass());
        if (!getFatal()) {
            log.error(getMessage(), this);
            if (getDetail() != null) {
                log.error("Causado por:", getDetail());
            }
        } else {
            log.fatal(getMessage(), this);
            if (getDetail() != null) {
                log.fatal("Causado por:", getDetail());
            }
        }
    }
}