package ar.com.sdd.commons.util;

public class Version {

    private static String versionStr = null;

    public static String getVersion()
    {
        if (versionStr == null)
        {
            String cvsTag = "$Name:  $";
            int    spcPos = cvsTag.indexOf(' ');
            int    endSpcPos = spcPos >= 0 ? cvsTag.indexOf(' ', spcPos + 1) : -1;
            
            String cvsTagSpec = endSpcPos >= 0 ? cvsTag.substring(spcPos, endSpcPos).trim() : "";

            versionStr = !cvsTagSpec.equals( "" ) ? cvsTagSpec : "INDEFINIDA";
        }

        return versionStr;
    }
    
    public static void main(String[] args) {
		System.out.println( getVersion() );
	}

    public static String getPackageVersion() {
        return getPackageVersion(Version.class);
    }

    public static String getPackageVersion(Class<?> cls) {
        Package pkg = cls.getPackage();
        return pkg != null ? StringUtil.nvl(pkg.getImplementationVersion(), "N/A") : "N/A";
    }
}
