package ar.com.sdd.commons.util.converter;

//import ar.com.sdd.ebpp.bo.type.Id;
import ar.com.sdd.commons.util.id.NumberId;

public class LongToIdConverter implements DataConverter {

   static LongToIdConverter instancia = null;

   public LongToIdConverter() {}

   protected static LongToIdConverter getInstance() {
      if (instancia == null) {
         instancia = new LongToIdConverter();
      }
      return instancia;
   }

   public static NumberId convertTo(Long o) {
      return (NumberId)getInstance().convertDataTo(o);
   }

   public static Long convertFrom(NumberId o) {
      return (Long)getInstance().convertFromData(o);
   }


//--- Implementacion de DataConverter ------------------------------------------------------------------------

    public Object convertDataTo(Object o) {
        return ( o != null ? new NumberId((Long)o) : null);
    }

    public Object convertFromData(Object o) {
        return ( o != null ?Long.valueOf(((NumberId)o).longValue()) : null);
    }


}

