package ar.com.sdd.commons.util.reflection;

import ar.com.sdd.commons.util.xml.XMLTag;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstanceCreator {

	private Class instanceClass;
//	private List arguments;
	private List argumentsClasses;
	private List argumentsInstances;

    private static Map classNamesMap = null;

	public InstanceCreator()
	{
		this.reset();
	}

	public void reset()
	{
		this.instanceClass = Class.class;
		this.argumentsClasses = new ArrayList();
		this.argumentsInstances = new ArrayList();
	}

	public void setInstanceClassName(String instanceClassName) throws InstanceCreatorException
	{
		this.instanceClass = this.getClassFor(instanceClassName);
	}

	public void addArgument(String argumentClassName, Object argument) throws InstanceCreatorException
	{
		this.argumentsClasses.add(this.getClassFor(argumentClassName));
		this.argumentsInstances.add(argument);
	}

	public void addArgument(String argumentClassName,int argument) throws InstanceCreatorException
	{
		this.addArgument(argumentClassName,Integer.valueOf(argument));
	}


	public Object createInstance() throws InstanceCreatorException
	{
		try
		{
			if(this.isEmptyArguments())
				return this.instanceClass.newInstance();
            Class argumentTypes[] = this.argumentsTypes();
            Object argumentValues[] = this.arguments();
			Constructor constructor = this.getConstructor( argumentTypes );
            this.checkConstructorArguments( constructor, argumentValues );
			return constructor.newInstance( argumentValues );
        } catch (Exception e) {
			throw new InstanceCreatorException("Ocurrio un error al instanciar la Clase " + this.instanceClass.getName(),e);
		}
	}


	private void checkConstructorArguments( Constructor constructor, Object[] argumentValues ) throws InstanceCreatorException {
        Class[] parameters = constructor.getParameterTypes();
        for( int i = 0; i<parameters.length; i++ )
            if ( parameters[ i ].isPrimitive() && argumentValues[ i ] == null )
                throw new InstanceCreatorException( "Argumento "+(i+1)+" de tipo primitivo "+parameters[i].getName()+" no puede ser null"  );
    }

    private Constructor getConstructor(Class[]argumentTypes) throws InstanceCreatorException
	{
		Constructor matchingConstructor = null;
		Constructor[] constructors = foldPrimitiveClass( this.instanceClass ).getConstructors();
		for(int i = 0;i<constructors.length && matchingConstructor == null;i++)
		{
			Constructor constructor = constructors[i];
			if(this.matchArguments(constructor,argumentTypes))
			{
				matchingConstructor = constructor;
			}
		}
		if(matchingConstructor == null)
			throw new InstanceCreatorException("No se encontro constructor adecuado para los argumentos pasados");
		return matchingConstructor;
	}

	private boolean matchArguments(Constructor constructor,Class[] argumentTypes)
	{
		Class[] parameters = constructor.getParameterTypes();
        boolean matchArguments = parameters.length == argumentTypes.length;
		for(int i = 0;i<parameters.length && matchArguments;i++)
    		matchArguments = foldPrimitiveClass( parameters[i] ).isAssignableFrom( foldPrimitiveClass( argumentTypes[i] ) );
		return matchArguments;
	}

    private Class foldPrimitiveClass(Class clazz) {
        if ( clazz.isPrimitive() )
                  if ( clazz.equals( Integer.TYPE ) )   clazz = Integer.class;
             else if ( clazz.equals( Long.TYPE ) )      clazz = Long.class;
             else if ( clazz.equals( Double.TYPE ) )    clazz = Double.class;
             else if ( clazz.equals( Float.TYPE ) )     clazz = Float.class;
             else if ( clazz.equals( Boolean.TYPE ) )   clazz = Boolean.class;
        return clazz;
    }

    private Map getClassNamesMap() {
        if ( classNamesMap == null ) {
            classNamesMap = new HashMap();
            classNamesMap.put( "int", int.class );
            classNamesMap.put( "Integer", Integer.class );
            classNamesMap.put( "long", long.class );
            classNamesMap.put( "Long", Long.class );
            classNamesMap.put( "string", String.class );
            classNamesMap.put( "String", String.class );
            classNamesMap.put( "boolean", boolean.class );
            classNamesMap.put( "Boolean", Boolean.class );
            classNamesMap.put( "Object", Object.class );
            classNamesMap.put( "xml", XMLTag.class );  //Deprecated. Borrar eventualmente
            classNamesMap.put( "XMLTag", XMLTag.class );
        }
        return classNamesMap;
    }


	private Class getClassFor(String className)throws InstanceCreatorException
	{
		try
		{
            Class mappedClass = (Class) getClassNamesMap().get( className );
			return mappedClass == null? Class.forName( className ): mappedClass;
		}
		catch(ClassNotFoundException e)
		{
			throw new InstanceCreatorException("No existe la clase " + className,e);
		}
	}

	private Object[] arguments()
	{
		return this.argumentsInstances.toArray();
	}

	private Class[] argumentsTypes()
	{
		Class[] arguments = new Class[this.argumentsClasses.size()];
		this.argumentsClasses.toArray(arguments);
		return arguments;
	}

	private boolean isEmptyArguments()
	{
		return this.argumentsInstances.isEmpty();
	}

}
