package ar.com.sdd.commons.util;

/**
 * Marca aquellas excepciones que tienen excepciones anidadas. Estas excepciones anidadas constituyen el 
 * <b>detalle</b> de la presente excepcion. 
 * <p> 
 * La idea es usar esta interfaz como marca para las excepciones que tienen otras anidadas y de esa forma
 * usar mecanismos automaticos para explorar los distintos niveles de anidamiento.
 * <p>
 * Se la presenta como interfaz para que la excepcion pueda heredar de la clase que sea logicamente mas 
 * adecuada y no de esta.
 * 
 * @author aalfonso
 */
public interface NestedException {

    /** 
     * Devuelve la excepcion que origino a la actual. Esta excepcion es el 
     * <b>detail</b> de la presente excepcion. 
     */
    public Throwable getDetail();


}
