package ar.com.sdd.commons.util.id;

import java.math.BigDecimal;

/**
 * Primary key generica para beans que tienen como clave un campo <b>id</b>
 * entero.
 * <p>
 * Esta clase permite convertir PK de y hacia <b>long</b>, <code>Long</code>,
 * <code>ar.com.sdd.ebpp.bo.type.Id</code> y <code>java.math.BigDecimal</code>
 *
 * 28/03/2003: modificado por Andres Ferrari para compatibilidad con Sun ONE AppServer7.
 *				La clase ahora es abstracta.
 */
public abstract class IdPK extends NumberIdPK {

    private static final long serialVersionUID = -5145736317445510354L;

	/** @see NumberIdPK#NumberIdPK() */
    public IdPK() { super(); }

    /** @see NumberIdPK#NumberIdPK(long) */
    public IdPK(long id) { super(id); }

    /** @see NumberIdPK#NumberIdPK(NumberId) */
    public IdPK(Id id) { super(id); }

    /** @see NumberIdPK#NumberIdPK(Long) */
    public IdPK(Long id) { super(id); }

    /** @see NumberIdPK#NumberIdPK(BigDecimal) */
    public IdPK(BigDecimal id) { super(id); }

    /** Crea un nuevo <code>IdPK</code> copiandose a partir del recibido como parametro */
    public IdPK(IdPK id) { super(id.getId()); }

//--- Metodos publicos ------------------------------------------------------------------------
    /**
     * Devuelve un Id que represente el mismo valor que esta primary key
     */
    public Id getId(){
    	// SUN_ONE_7
        //return new Id(id);
        return new Id(getLongId().longValue());
    }

	// SUN_ONE_7
	// (deprecated: equals() y hashCode() deben definirse en las subclases)
	/*
    public boolean equals( Object o1 )
    {
        if ( o1 == null || ! (o1.getClass().equals(this.getClass())) ) {
            return false;
        }
        IdPK o2 = (IdPK) o1;
        return (this.id == o2.id );
    }
    */
    
}
