/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.lineparser;

import ar.com.sdd.commons.util.lineparser.LineParserException;
import java.util.HashMap;
import java.util.Map;

public abstract class LineParser {
    public static int PARSE_NONE = -1;
    public static int PARSE_CSV = 0;
    public static int PARSE_FIXED = 1;
    protected int numOfFields;
    protected String[] fieldNames;
    protected String[] fieldValues;
    protected Map fieldIndexesByName;

    public LineParser(String[] fieldNames) {
        fieldNames = LineParser.standarizeFieldName(fieldNames);
        this.numOfFields = fieldNames.length;
        this.fieldNames = fieldNames;
        this.fieldValues = new String[fieldNames.length];
        this.fieldIndexesByName = new HashMap();
        for (int i = 0; i < this.numOfFields; ++i) {
            this.fieldIndexesByName.put(fieldNames[i], i);
        }
    }

    public int getNumOfFields() {
        return this.numOfFields;
    }

    public String getFieldValue(int i) {
        String fieldValue = i >= 0 && i < this.fieldValues.length ? this.fieldValues[i] : null;
        return fieldValue;
    }

    public String getFieldValue(String fieldName) {
        int idx = this.getFieldIndex(fieldName);
        String retValue = idx != -1 ? this.fieldValues[idx] : null;
        return retValue;
    }

    public String getFieldName(int i) {
        String fieldName = i >= 0 && i < this.fieldNames.length ? this.fieldNames[i] : null;
        return fieldName;
    }

    public int getFieldIndex(String fieldName) {
        Integer idx = (Integer)this.fieldIndexesByName.get(LineParser.standarizeFieldName(fieldName));
        int retValue = idx != null ? idx : -1;
        return retValue;
    }

    public abstract void parse(String var1) throws LineParserException;

    protected void resetFieldValues() {
        for (int i = 0; i < this.getNumOfFields(); ++i) {
            this.fieldValues[i] = null;
        }
    }

    public static String standarizeFieldName(String field) {
        return field.toLowerCase().replaceAll("[. _-]", "");
    }

    public static String[] standarizeFieldName(String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = LineParser.standarizeFieldName(fields[i]);
        }
        return fields;
    }
}

