/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.math;

import ar.com.sdd.commons.util.math.BigSurdVec;
import ar.com.sdd.commons.util.math.Rational;
import ar.com.sdd.commons.util.math.Wigner3j;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Wigner3jGUI
implements ActionListener,
ListSelectionListener {
    JFrame fram;
    Label Lbl0;
    Label Lbl1;
    JButton sear;
    JList searJ;
    String[] searOpt = new String[]{"6j", "9j", "12j 1st", "12j 2nd (not symm)", "15j 1st", "15j 2nd", "15j 3rd", "15j 4th", "15j 5th"};
    TextArea inpGtria;
    TextArea inpGjval;
    TextArea outG;
    GridBagLayout gridbag;
    GridBagConstraints gridconstr;

    public void init() {
        this.fram = new JFrame("Wigner3jGUI");
        this.Lbl0 = new Label("Input: (Triads upper area, values 2J+1 second area");
        this.Lbl1 = new Label("Output:");
        this.sear = new JButton("Compute");
        this.sear.setActionCommand("compute");
        this.sear.addActionListener(this);
        this.sear.setToolTipText("Compute a general 3jn  value");
        this.searJ = new JList<String>(this.searOpt);
        this.searJ.setLayoutOrientation(2);
        this.searJ.addListSelectionListener(this);
        Font defFont = new Font("Monospaced", 0, 11);
        this.fram.setBackground(new Color(250, 250, 250));
        this.fram.setForeground(new Color(0, 0, 0));
        Color fg = new Color(0, 200, 0);
        Color bg = new Color(10, 10, 10);
        this.gridbag = new GridBagLayout();
        this.fram.setLayout(this.gridbag);
        this.gridconstr = new GridBagConstraints();
        this.gridconstr.gridx = 0;
        this.gridconstr.gridy = -1;
        this.inpGtria = new TextArea("", 4, 80);
        this.inpGtria.setFont(defFont);
        this.inpGtria.setForeground(fg);
        this.inpGtria.setBackground(bg);
        this.inpGjval = new TextArea("", 10, 80);
        this.inpGjval.setFont(defFont);
        this.inpGjval.setForeground(fg);
        this.inpGjval.setBackground(bg);
        this.outG = new TextArea("", 12, 80);
        this.outG.setEditable(false);
        this.outG.setFont(defFont);
        this.outG.setForeground(fg);
        this.outG.setBackground(bg);
        this.fram.add(this.Lbl0);
        this.gridbag.setConstraints(this.Lbl0, this.gridconstr);
        this.fram.add(this.inpGtria);
        this.gridbag.setConstraints(this.inpGtria, this.gridconstr);
        this.fram.add(this.inpGjval);
        this.gridbag.setConstraints(this.inpGjval, this.gridconstr);
        this.fram.add(this.sear);
        this.gridbag.setConstraints(this.sear, this.gridconstr);
        this.fram.add(this.searJ);
        this.gridbag.setConstraints(this.searJ, this.gridconstr);
        this.fram.add(this.Lbl1);
        this.gridbag.setConstraints(this.Lbl1, this.gridconstr);
        this.fram.add(this.outG);
        this.gridbag.setConstraints(this.outG, this.gridconstr);
        this.fram.pack();
        this.fram.setVisible(true);
    }

    public void compute() {
        String tr = this.inpGtria.getText();
        String[] trias = new String[4];
        Scanner s = new Scanner(tr);
        int l = 0;
        while (l < 3) {
            try {
                trias[l] = s.nextLine().trim();
                if (trias[l].startsWith("#")) continue;
                ++l;
            }
            catch (Exception e) {
                this.outG.setText("ERROR: less than 3 lines in the triad definition");
                return;
            }
        }
        String j = this.inpGjval.getText();
        s = new Scanner(j);
        while (true) {
            try {
                trias[3] = s.nextLine().trim();
            }
            catch (Exception e) {
                return;
            }
            if (trias[3].startsWith("#")) continue;
            try {
                BigSurdVec w = Wigner3j.wigner3j(trias[0], trias[1], trias[2], trias[3]);
                this.outG.append(w.toString() + " = " + w.doubleValue());
            }
            catch (Exception e) {
                this.outG.append(e.toString());
                e.printStackTrace();
            }
            this.outG.append(" # J = ");
            Scanner num = new Scanner(trias[3]);
            while (num.hasNextInt()) {
                int twoj1 = num.nextInt();
                Rational jfrac = new Rational(twoj1 - 1, 2);
                this.outG.append(jfrac.toString() + " ");
            }
            this.outG.append("\n");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String lin = e.getActionCommand();
        if (lin == "compute") {
            this.outG.setText("");
            this.compute();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        switch (this.searJ.getMinSelectionIndex()) {
            case 0: {
                this.inpGtria.setText("6\n");
                this.inpGtria.append("1 2 -3 -1 5 6\n");
                this.inpGtria.append("4 -5 3 -4 -2 -6");
                this.outG.setText("");
                break;
            }
            case 1: {
                this.inpGtria.setText("9\n");
                this.inpGtria.append("1 3 2 4 6 5 7 9 8 # (j1 j3 j2) (k1 k3 k2) (l1 l3 l2)\n");
                this.inpGtria.append("-2 -8 -5 -6 -3 -9 -7 -4 -1 # (j2 l2 k2) (k3 j3 l3) (l1 k1 j1)");
                this.outG.setText("");
                break;
            }
            case 2: {
                this.inpGtria.setText("12\n");
                this.inpGtria.append("1 12 -8 -1 5 -2 2 6 -3 3 7 -4 # (j1 k4 l4) (j1 l1 j2) (j2 l2 j3) (j3 l3 j4)\n");
                this.inpGtria.append("4 8 -9 9 -5 -10 10 -6 -11 11 -7 -12 # (j4 l4 k1) (k1 l1 k2) (k2 l2 k3) (k3 l3 k4)");
                this.outG.setText("");
                break;
            }
            case 3: {
                this.inpGtria.setText("12\n");
                this.inpGtria.append("1 5 9 -9 -2 -7 2 11 8 -8 -12 -4 # (j1 l1 k1) (k1 j2 l3 ) (j2 k3 l4) (l4 k4 j4)\n");
                this.inpGtria.append("4 7 10 -10 -3 -5 3 6 12 -6 -11 -1 # (j4 l3 k2) (k2 j3 l1) (j3 l2 k4) (l2 k3 j1)");
                this.outG.setText("");
                break;
            }
            case 4: {
                this.inpGtria.setText("15\n");
                this.inpGtria.append("1 -6 2 -2 -7 3 -3 -8 4 -4 -9 5 -5 -10 11 # (j1 l1 j2)(j2 l2 j3)(j3 l3 j4)(j4 l4 j5)(j5 l5 k1)\n");
                this.inpGtria.append("-11 6 12 -12 7 13 -13 8 14 -14 9 15 -15 10 -1 # (k1 l1 k2)(k2 l2 k3)(k3 l3 k4)(k4 l4 k5)(k5 l5 j1)");
                this.outG.setText("");
                break;
            }
            case 5: {
                this.inpGtria.setText("15\n");
                this.inpGtria.append("-1 -6 2 -2 -7 3 -3 -8 4 -4 -9 5 1 -5 -10 # (j1 l1 j2)(j2 l2 j3)(j3 l3 j4)(j4 l4 j5)(j1 j5 l5)\n");
                this.inpGtria.append("11 -15 10 9 15 -14 8 14 -13 7 13 -12 6 12 -11 # (k1 k5 l5)(l4 k5 k4)(l3 k4 k3)(l2 k3 k2)(l1 k2 k1)");
                this.outG.setText("");
                break;
            }
            case 6: {
                this.inpGtria.setText("15\n");
                this.inpGtria.append("-13 -12 -8 12 14 10 -10 -1 7 -7 -11 -2 2 4 6 # (j' j p)(j j2 j1)(j1 k1 p1)(p1 j1' k1')(k1' k' k2')\n");
                this.inpGtria.append("-4 -3 8 1 3 5 -14 -5 9 -15 -6 -9 15 11 13 # (k' k p)(k1 k k2)(j2 k2 p2)(j2' k2' p2)(j2' j1' j')");
                this.outG.setText("");
                break;
            }
            case 7: {
                this.inpGtria.setText("15\n");
                this.inpGtria.append("-14 -12 -8 12 11 -10 -11 13 -7 7 -1 3 2 1 6 # (k2' k2 s)(k2 j2 p')(j2 s2 l)(l j1 s1)(k1 j1 p)\n");
                this.inpGtria.append("-4 -2 8 10 4 5 9 -5 -3 -13 -9 -15 15 -6 14 # (k1' k1 s)(p' k1' j1')(l' j1' s1)(s2 l' j2')(j2' p k2')");
                this.outG.setText("");
                break;
            }
            case 8: {
                this.inpGtria.setText("15\n");
                this.inpGtria.append("-15 1 -7 -4 -11 7 5 4 -3 -12 -5 6 12 -9 -1 # (l3' k1 k2')(l1 k3 k2')(l1' l1 j1)(k3' l1' k2)(k3' l2 k1)\n");
                this.inpGtria.append("9 -8 10 -10 11 -2 -14 -6 2 14 -13 15 3 8 13 # (l2 j2 l2')(l2' k3 k1')(l3 k2 k1')(l3 j3 l3')(j1 j2 j3)");
                this.outG.setText("");
            }
        }
    }

    public static void main(String[] args) {
        Wigner3jGUI g = new Wigner3jGUI();
        g.init();
    }
}

