package ar.com.sdd.commons.util;

import java.rmi.RemoteException;

public class ExceptionUtil {
    
    public static Throwable getRootException( Throwable e ) {
        Throwable result = null;
        Throwable aux = e;
        while ( aux != null ) {
            result = aux;
            if (aux instanceof NestedException) {
                aux = ((NestedException)aux).getDetail();
            } else if(aux instanceof RemoteException) {
                aux = ((RemoteException)aux).detail;
            } else if(aux instanceof AbstractException) {
                aux = ((AbstractException)aux).getDetail();
            } else if(aux instanceof AbstractRuntimeException) {
                aux = ((AbstractRuntimeException)aux).getDetail();
            } else {
                aux = null;
            }
        }
        return result;
    }

    public static String dumpStackTace() {
    	String result = "";
    	StackTraceElement[] stack =Thread.currentThread().getStackTrace();
    	for (int i=0; i< stack.length; i++) {
    		 result += stack[i].toString()+"\n";
    	}
    	return result;
    }
}
