package ar.com.sdd.commons.util;

//import ar.com.sdd.ebf.bo.document.DocumentData;
//import ar.com.sdd.ebf.bo.settlement.Settlement;
//import ar.com.sdd.ebf.creator.documentcreator.DocumentBuilder.ModoDigitoVerificadorFrances;
//import ar.com.sdd.ebf.ebl.EblContext;
//import ar.com.sdd.ebf.ebl.EblParser;
//import ar.com.sdd.ebf.payment.digitoVerificador.DigitoVerificadorFrances;
//import ar.com.sdd.ebf.payment.digitoVerificador.DigitoVerificadorRapipago;
import groovy.json.JsonSlurper;
import groovy.json.internal.LazyMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * Utiles para la manipulacion de Strings.
 *
 * @author Andres Ferrari
 */
public class StringUtil {

	public final static String LANG_ES = "es";
	public final static String LANG_EN = "en";

	public static final String PADD_LEFT = "PADD_LEFT";
	public static final String PADD_RIGHT = "PADD_RIGHT";
    public static final String FILL_AT = "FILL_AT";
	

	public static final char LIST_SEPARATOR_CHAR = '|';
	public static final char AT_SEPARATOR_CHAR = '@';
	public static final String LIST_SEPARATOR = String.valueOf(LIST_SEPARATOR_CHAR);

	public static final String LIST_ANY = "*";

	public static final String LIST_NONE = "~";

	public static final String LIST_ANY_SEP = "|*|"; // concatenar las
													  // anteriores

	private static final String LIST_NONE_SEP = "|~|"; // concatenar las
													  // anteriores
	public static final String PAD_SPC = " ";
	
	public static final String VALID_UPPERS = "ABCDEFGHIJKLMNNOPQRSTUVWXYZ";
	public static final String VALID_LOWERS = "abcdefghijklmnnopqrstuvwxyz";

    public static final String EOL = System.getProperty("line.separator");

	public static final String EMAIL_ADDRESS_VALIDATION_PATTERN = "^(?=.{1,64}@)[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*@[^-][A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";

    private static Logger log = LogManager.getLogger(StringUtil.class);
	
	
	private static Map<String, int[][]> substringFormatCache = new HashMap<String, int[][]>();

	/**
	 * Elimina todas las ocurrencias del conjunto de chars especifcado de un
	 * String, y devuelve el String resultante.
	 *
	 * @param chars
	 *            Conjunto de chars a eliminar.
	 * @param str
	 *            String del cual se desea eliminar los caracteres.
	 * @return String sin los caracteres eliminados.
	 */
	public static String deleteChars(String chars, String str) {

		StringBuilder newStr = new StringBuilder();

		// Usa los caracteres a eliminar como delimitadores del tokenizer
		StringTokenizer strTok = new StringTokenizer(str, chars);
		while (strTok.hasMoreTokens()) {
			newStr.append(strTok.nextToken());
		}

		return newStr.toString();
	}
	
	/**
	 * Elimina los ultimos n caracteres de una cadena
	 * @param quantity
	 * @return
	 */
	public static String deleteLastChars(String str, int quantity) {
		if (!isEmpty(str)) {
			return str.substring(0, str.length() - quantity);
		} else {
			return str;
		}
	}

	public static String trimLeading(String s, char fillerChar)	{
		if (s==null) return "";
		return s.replaceAll("^"+fillerChar+"*","");
	}

	public static String trimTrailing(String s, char fillerChar)	{
		if (s==null) return "";
		return s.replaceAll(fillerChar+"*$","");
	}

	public static String trimAll(String s)	{
		return trimAll(s,' ');
	}
	public static String trimAll(String s, char fillerChar)	{
		String result;
		//Trim leading
		result = trimLeading(s, fillerChar);
		//Trim trailing
		result = trimTrailing(result, fillerChar);
		return result;
	}
	
	public static String trimLeadingSpacesAndZeroes(String s)	{
		//Primero quita espacios y cero
		if (s==null) return "";
		return  s.replaceAll("^[ 0]*","");
	}

    public static String trimLastNZeroes(String s, int n) {
	    if (isEmpty(s)) return "";
	    return s.replaceAll("^(.*)(0{" + n + "})$", "$1");
    }

	/**
	 * 
	 * @param sourceString          String fuente.
	 * @param paddedStringLenght    largo maximo.
	 * @param fillerChar            caracter para llenar.
	 * @param paddingType           tipo de padding (Left, Right).
	 * @return String
	 */
    public static String padd(String sourceString, int paddedStringLenght, char fillerChar, String paddingType) {
        return padd(sourceString, paddedStringLenght, fillerChar, paddingType, null);
    }

	public static String padd(String sourceString, int paddedStringLenght, char fillerChar, String paddingType, Integer position) {
		if (sourceString == null) {
            sourceString = "";
        }

        if (sourceString.length() >= paddedStringLenght) {
            if (PADD_LEFT.equals(paddingType)) {
                // Le termina sacando caracteres de la izquierda para cumplir con el largo maximo
                return sourceString.substring(sourceString.length() - paddedStringLenght);
            } else {
                // Le termina sacando caracteres de la derecha para cumplir con el largo maximo
                return sourceString.substring(0, paddedStringLenght);
            }
        }

		int paddingLenght = paddedStringLenght - sourceString.length();
		StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(fillerChar).repeat(Math.max(0, paddingLenght)));

        if (PADD_LEFT.equals(paddingType)) {
			buffer.append(sourceString);
            return buffer.toString();
        } else if (PADD_RIGHT.equals(paddingType)) {
        	buffer.insert(0, sourceString);
            return buffer.toString();
        } else if (FILL_AT.equals(paddingType)) {
            if (position != null) {
				buffer.insert(0,sourceString.substring(0, position));
				buffer.append(sourceString.substring(position));
                return buffer.toString();
            }
        }
		return sourceString;
	}

    public static String spaces( int n ) {
        return padd( "", n, ' ', PADD_LEFT );
        
    }

    public static String padSpc( String value, int paddedStringLenght ) {
    	return padd( value, paddedStringLenght, ' ', PADD_RIGHT );
    }
    
    public static String padSpc( String value, int paddedStringLenght, String padd) {
    	return padd( value, paddedStringLenght, ' ', padd );
    }

    public static String padNum( String value, int paddedStringLenght ) {
    	if (value==null) value=""; 
		// No quiero que -3.0 quede como 0000-3.0, sino como -00003.0
		if (value.indexOf('-')==0) {
			value = "-"+ padd( value.substring(1), paddedStringLenght-1, '0', PADD_LEFT );
		} else {
			value = padd( value, paddedStringLenght, '0', PADD_LEFT );
		}
    	return value;
    }
    
    public static String padNum( int value, int paddedStringLenght ) {
    	return padNum(value+"", paddedStringLenght);
    }
    
    /**
     * Paddea con ceros a la izquierda llevando el value a un largo par
     * Ej. Si se pasa 123 devuelve 0123
     *     Si se pasa 1234 devuelve 1234 (no lo cambia porque es par)
     * @param value
     * @return
     */
    public static String padNumToEven(String value) {
		if (value.length() % 2 != 0) {
			value = padNum(value, value.length() +1);
		}
    	return value;
    }

	public static String padNumToOdd(String value) {
		if (value.length() % 2 == 0) {
			value = padNum(value, value.length() + 1);
		}
		return value;
	}

	public static String padCustomLeft( String value, int paddedStringLenght, char paddObj ) {
    	return padd( value, paddedStringLenght, paddObj, PADD_LEFT );
    }
    
    public static String padCustomRight( String value, int paddedStringLenght, char paddObj ) {
    	return padd( value, paddedStringLenght, paddObj, PADD_RIGHT );
    }

	/**
	 * Devuelve la coleccion de tokens de 'str' que estaban separados por los
	 * delimitadores 'delimiters'.
	 * @Todo: Parece ser lo mismo que listValues
	 */
	public static Collection<String> parseString(String str, String delimiters) {

		ArrayList<String> tokens = null;

		if (str != null) {

			tokens = new ArrayList<String>();

			StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
			while (tokenizer.hasMoreTokens()) {
				tokens.add(tokenizer.nextToken());
			}

			if (tokens.isEmpty())
				tokens = null;
		}

		return tokens;
	}
	
	/**
	 * Convierte una un string de numeros separados por pipes en una lista de longs
	 * @param str
	 * @param delimiters
	 * @return
	 */
	public static Collection<Long> parseStringAsLong(String str, String delimiters) {
		Collection<Long> result = null;
		Collection<String> strings = parseString(str, delimiters);
		if (!CollectionUtils.isEmpty(strings)) {
			result = new ArrayList<Long>();
			for (String string : strings) {
				result.add(Long.valueOf(string.trim()));
			}
		}
		return result;
	}

    public static List<String> listValues(String text) {
	    return listValues(text, LIST_SEPARATOR_CHAR);
    }
	public static Set<String> listValuesAsSet(String text) {
		return listValuesAsSet(text,LIST_SEPARATOR_CHAR);
	}
	public static Set<String> listValuesAsSet(String text, char separator) {
        HashSet result = new HashSet<>(listValues(text, separator));
		return result;
	}


	/**
	 * retorna una lista a partir de un string con valores separados por |
	 * @author jpalacios Jun 26, 2009
	 * @param text
	 * @param separator
	 * @Todo: Parece ser lo mismo que parseString
	 * @return
	 */
	public static List<String> listValues(String text, char separator){
		List<String> listValues = new ArrayList<String>();
		if (text==null) return listValues;
		String[] values = split(text, separator);
        listValues.addAll(Arrays.asList(values));
		return listValues;
	}
	
	public static String compactValues(Collection<String> values, String separator){
		StringBuilder result = new StringBuilder();
		boolean first = true;
		if (!CollectionUtils.isEmpty(values)) {
			for (String value: values) {
				if (first) first=false;
				else result.append(separator); 
				result.append(value);
			}
		}
		return result.toString();
	}
	public static String compactValuesQuote(Collection<String> values, String separator, String begQuote, String endQuote){
		StringBuilder result = new StringBuilder();
		boolean first = true;
		if (!CollectionUtils.isEmpty(values)) {
			for (String value: values) {
				if (first) first=false;
				else result.append(separator);
				result.append(begQuote);
				result.append(value);
				result.append(endQuote);
			}
		}
		return result.toString();
	}


	/**
	 * Extrae una valor de una lista de propertys separadas por pipe
	 * @param pipedPropertyText    key[valor]|key[valor]
	 * @param key
	 * @return
	 */
	public static String getProperyFromPipes(String pipedPropertyText, String key){
		List<String> listValues = StringUtil.listValues(pipedPropertyText, StringUtil.LIST_SEPARATOR_CHAR);
		for (String keyPair : listValues) {
			if (keyPair.startsWith(key)) {
				return keyPair.substring(keyPair.indexOf("[") + 1, keyPair.indexOf("]"));
			}
		}
		return "";
	}

    public static Map<String, Object> getJsonMapFromJson(String jsonString) {
        if (StringUtil.isEmpty(jsonString)) return null;
        JsonSlurper slurper = new JsonSlurper();
        return (Map<String, Object>) slurper.parseText(jsonString);
    }

    public static List<Map<String, Object>> getJsonListFromJson(String jsonString) {
        if (StringUtil.isEmpty(jsonString)) return null;
        JsonSlurper slurper = new JsonSlurper();
        return (List<Map<String, Object>>) slurper.parseText(jsonString);
    }

	public static String getPropertyFromJson(String jsonText , String...keys) {
        return getStringPropertyFromJsonMap(getJsonMapFromJson(jsonText), keys);
	}

    public static Long  getLongPropertyFromJson(String jsonText, String... keys) {
		return getPropertyFromJsonMap(Long.class, getJsonMapFromJson(jsonText), keys);
	}
    public static Integer  getIntegerPropertyFromJson(String jsonText, String... keys) {
        return getPropertyFromJsonMap(Integer.class, getJsonMapFromJson(jsonText), keys);
    }

    public static String getStringPropertyFromJsonMap(Map<String, Object> jsonSlurperMap, String... keys) {
        return getPropertyFromJsonMap(String.class, jsonSlurperMap, keys);
    }

    public static <T> T getPropertyFromJsonMap(Class<T> returnType, Map<String, Object> jsonSlurperMap, String... keys) {
        if (jsonSlurperMap == null) {
            return returnType.equals(String.class) ? (T) "" : null;
        }

        Object result;
        Iterator<String> keysIt = Arrays.stream(keys).iterator();
		while (keysIt.hasNext()) {
			String key = keysIt.next();
			int arrayPos = 0;
			boolean isValueAnArray = false;
			if (key.contains("[")) {
				int openPos = key.indexOf("[");
				int closePos = key.indexOf("]");
				arrayPos = Integer.parseInt(key.substring(openPos + 1, closePos));
				isValueAnArray = true;
				key = key.substring(0, openPos);
			}
            result = jsonSlurperMap.get(key);
            if (result == null) return returnType.equals(String.class) ? (T) "" : null;

			// Si es un array, reemplazo por el Map solicitado dentro del Array
			if (isValueAnArray && result instanceof ArrayList) {
				result = ((ArrayList) result).get(arrayPos);
			}

			// Si aun tengo keys para iterar, deberia ser un map para poder seguir buscando
            if (keysIt.hasNext() && result instanceof Map) {
                jsonSlurperMap = (Map) result;
            } else {
				if (returnType.equals(String.class) && result instanceof Number) {
					// Una guarda para convertir algo que venga sin "" en un String si asi me lo pidieron
					return (T) result.toString();
				} else if (returnType.equals(Double.class) && result instanceof String) {
					// Convierte el String a Double si es necesario
					try {
						return (T) Double.valueOf((String) result);
					} catch (NumberFormatException e) {
						return returnType.equals(String.class) ? (T) "" : null;
					}
				} else if (returnType.equals(Long.class) && result instanceof String) {
					// Convierte el String a Long si es necesario
					try {
						return (T) Long.valueOf((String) result);
					} catch (NumberFormatException e) {
						return returnType.equals(String.class) ? (T) "" : null;
					}
            } else {
				// Si result es un Map el toString lo devuelve como {key=value} mientras que el json era {"key": "value"}
                return (T) result;
            }
        }
        }

		return returnType.equals(String.class) ? (T) "" : null;
    }

    public static ArrayList<LazyMap> getArrayPropertyFromJsonMap(Map<String, Object> jsonSlurperMap, String... keys) {
        if (jsonSlurperMap == null) {
            return null;
        }

        Object result;
        Collection<String> keysConcat = new ArrayList<>();
        Iterator<String> keysIterator = Arrays.stream(keys).iterator();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next();
            result = jsonSlurperMap.get(key);
            if (result == null) {
                log.debug("No se encotro la el value para la property json [" + String.join(".", keysConcat) + "]");
                return null;
            }

            if (result instanceof LazyMap) {
                jsonSlurperMap = (LazyMap) result;
            } else if (result instanceof ArrayList && !keysIterator.hasNext()) {
                return (ArrayList<LazyMap>) result;
            } else {
                return null;
            }
        }

        return null;
    }

	public static String getProperySufixed(Map<String, String> properties, String key,  String...tags) {
		String value = properties.get(key); //Sin ningun tag
		String tagList = "";
		for (String tag : tags) {
			tagList += '.'+tag; //voy agreganto tags
			String moreSpecificValue = properties.get(key + tagList);
			if (!StringUtil.isEmpty(moreSpecificValue)) { //recerdo el mas espcifico
				value = moreSpecificValue;
			}
		}
		return value;
	}

	/**
	 * Evita los valores vacios. Usa el separador default {@link #LIST_SEPARATOR_CHAR}
	 * @param text
	 * @return
	 */
	public static List<String> listValuesNotEmpty(String text) {
		return listValuesNotEmpty(text, LIST_SEPARATOR_CHAR);
	}

	public static <T> List<T> listValuesNotEmptyMapping(String text, Function<String, T> function) {
		return listValuesNotEmptyMapping(text, LIST_SEPARATOR_CHAR, function);
	}

	//Devolver la posicion i, si existe. Sino devuelve null
	public static String listValuesNotEmpty(String text, int i) {
		List<String> values = listValuesNotEmpty(text, LIST_SEPARATOR_CHAR);
		if (values.size()<=i) return null;
		else return values.get(i);
	}
	
	/**
	 * Evita los valores vacios
	 * @param text
	 * @param separator
	 * @return
	 */
	public static List<String> listValuesNotEmpty(String text, char separator){
		return listValues(text, separator).stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
	}

	public static <T> List<T> listValuesNotEmptyMapping(String text, char separator, Function<String, T> function) {
		return listValues(text, separator).stream().filter(StringUtil::isNotEmpty).map(function).collect(Collectors.toList());
	}

	public static List<Long> listValuesAsLong(String str) {
		return listValuesAsLong(str, LIST_SEPARATOR);
	}

	public static List<Long> listValuesAsLong(String str, String delimiters) {
		List<Long> result = null;
		Collection<String> strings = parseString(str, delimiters);
		if (strings != null) {
			result = new ArrayList<>();
			for (String s : strings) if (!isEmpty(s)) {
				result.add(Long.valueOf(s.trim()));
			}
		}
		return result;
	}

    public static List<Long> listValuesAsLongNotEmpty(String str) {
	    return listValuesAsLongNotEmpty(str, LIST_SEPARATOR);
    }

    public static List<Long> listValuesAsLongNotEmpty(String str, String delimiters) {
	    List<Long> listValues = listValuesAsLong(str, delimiters);
	    return listValues == null ? new ArrayList<>() : listValues;
    }

	/**
	 * Cuenta la cantidad de caracteres que tiene una expresion del tipo fromTo
	 * "0:2,4:5" -> 3
	 * @return
	 */
	public static int fromToCountLenght(String substringFormat){
		String[] ranges = substringFormat.split(",");		
		int count = 0;

        for (String s : ranges) {
            String[] range = s.split(":");
			int from = Integer.parseInt(range[0]);
			int to = Integer.parseInt(range[1]);
			count += Math.abs(to - from);
		}
		return count;
	}

	/**
	 * Retorna true, si list es o contiene *. Considera las sintaxis * y |*|
	 *
	 */
	public static boolean isListAny(String listItems) {
		return listItems != null && (listItems.equals(LIST_ANY) || listItems.contains(LIST_ANY_SEP));
	}

	/**
	 * Retorna true, si list es vacia, o es o contiene !*. Considera las sintaxis * y |*|
	 *
	 */
	public static boolean isListNone(String listItems) {
		if (isEmpty(listItems))
			return true;
		if (listItems.equals(LIST_NONE))
			return true;
		if (listItems.equals(LIST_NONE_SEP))
			return true;
		return false;
	}

	
	
	//Recibe una lista de opciones tageadas con roles, y una lista de roles (que tengo)
	//Devuele las opciones que sobreviven al filtro:
	//      |AMOUNT|CUIT@B|LEGAL@B@S|  ,  "B"   ==>  |AMOUNT|CUIT|LEGAL|
	//      |AMOUNT|CUIT@B|LEGAL@B@S|  ,  "S"   ==>  |AMOUNT|LEGAL|
	//      |AMOUNT|CUIT@B@A|LEGAL@B@S|  ,  "A|S"   ==>  |AMOUNT|CUIT|LEGAL|
	//
	
	public static String getListFilterByRoles(String options, String roles) {
		if (StringUtil.isEmpty(options)) return options;
		String result="";
		String sep="";
		List<String> lvs = listValues(options, LIST_SEPARATOR_CHAR);
		for(String value:lvs) if (!isEmpty(value)){
			List<String> optionsRoles = listValues(value, AT_SEPARATOR_CHAR);
			String option=optionsRoles.get(0); //tiene que haber!
			if (optionsRoles.size()==1) {
				result +=  option + LIST_SEPARATOR_CHAR;
				
			} else {
				for(int i=1; i<optionsRoles.size();i++) {
					if (isInList(roles, optionsRoles.get(i))) {
						result += option+LIST_SEPARATOR_CHAR;
						break;
					}
				}
			}
		}
		return result;
	}


	
	/** 
	 * Los strings pasados como parametro tienen la forma: '|FAC|NCR|' o '*'
	 * Donde '*' significa todos los tipos de docs.
	 * Si los dos parametros son '*', la collection sera null.
	 * Si uno de los strings es *, y el otro no, devuelve un string formado por todos los 
	 * tokens que se encuentran en el string != '*'.
	 * Si los dos parametros son distintos de '*', devuelve un string con la interseccion de ambos.  
	 * Si no hay interseccion devuelve NULL
     */
	// alguno es null		==> return = null	(no listar)
	// los dos son *		==> return = ""		(listar sin filtrar por tipos)
	// * y |FAC|RET|		==> return = |FAC|RET|
	// |xx|yy|zz| y |xx|aa|	==> return = |xx|
	// |xx|yy|zz| y |aa|bb|	==> return = null	(no listar)
	public static String calcIntersection(String grupoUno, String grupoDos) {
		String result = "";
		boolean grupoUnoAny = false;
		boolean grupoDosAny = false;
		
		if (grupoUno == null || grupoDos == null) {
			return null;
		}
		if (StringUtil.isListAny(grupoUno)) grupoUnoAny = true;
		if (StringUtil.isListAny(grupoDos)) grupoDosAny = true;
		
	    if(grupoUnoAny && grupoDosAny) {
			result = "";

		} else if(grupoUnoAny && !grupoDosAny) {
			result = grupoDos;

		} else if(!grupoUnoAny && grupoDosAny) {
			result = grupoUno;
			
		} else if(!grupoUnoAny && !grupoDosAny) {
			
			//Agrego un caso particular por performance (evito los tokenizers....)
			if (grupoUno.equals(grupoDos)) {
				result = grupoUno;
			} else {
				//Recorro los tipos soportados por la pagina, y si el operador lo tiene, lo agrego a docTypes
				StringTokenizer stGrupoUno = new StringTokenizer(grupoUno, "|", false);
		
				while (stGrupoUno.hasMoreTokens()) {	
					String tokenGrupoUno = stGrupoUno.nextToken();
					StringTokenizer stGrupoDos = new StringTokenizer(grupoDos, "|", false);
					boolean encontrado = false;
					while (stGrupoDos.hasMoreTokens() && !encontrado) {
						String tokenGrupoDos = stGrupoDos.nextToken();
						if (tokenGrupoUno.equals(tokenGrupoDos)) {
							result += tokenGrupoUno + "|";
							encontrado=true;
						}
					}
				}
				if ((result!=null) && (!result.isEmpty()))
					result = "|" + result;
		
				if ((result==null) || (result.isEmpty())) {
					result = null; //para diferenciar entre todos o ninguno.
				}
			}
		} 

		return result;
	}

	//Me permite controlar si un valor esta en la lista de los otros
	//ej:   hasIntersection("A|B|C","A|C") =true
	public static boolean hasIntersection(String grupoUno, String grupoDos) {
		String intersection = calcIntersection(grupoUno, grupoDos);
		return intersection != null;
	}
	
	
	
	/**
	 * Retorna true, si item se encuentra en listItems. Si listItems tiene un *,
	 * return true Retorna false, en caso contrario. listItems es del estilo:
	 * '|FAC|OCV|' o '*' o null item es del estilo: 'FAC'
	 */
	public static boolean isInList(String listItems, String item) {
		return isInList( listItems, item, false );
	}

	/**
	 * Devuelve true si el item no esta incluido en la lista. Si listItems es <b>*</b> entonces devuelve true
	 *
	 * @param listItems
	 * @param item
	 * @return
	 */
	public static boolean isNotInList(String listItems, String item) {
		return !isInList(listItems, item);
	}

	/**
	 * Retorna un string que agrega a una lista con "|" otro string, cuidando de no repetir 
	 * @author alvewe Jun 8, 2011
	 * @param listItems
	 * @param item
	 * @return
	 */
	public static String addToList(String listItems, String item) {
		listItems= StringUtil.nonNull(listItems);
		if (!StringUtil.isInList(listItems, item)) {
			listItems+= LIST_SEPARATOR+item;
		}
		return listItems;
	}

	/**
	 * Retorna un string que saca de una lista con "|" otro string, si esta 
	 * @author alvewe Jun 8, 2011
	 * @param listItems
	 * @param item
	 * @return
	 */

    public static String removeFromList(String listItems, String item) {
        listItems = StringUtil.nonNull(listItems);
        if (StringUtil.isInList(listItems, item)) {
            // Primero saco el item de la lista
            listItems = StringUtil.replace(listItems, item, "");
            // Luego los doble pipes que me hayan quedado
            listItems = StringUtil.replace(listItems, LIST_SEPARATOR + LIST_SEPARATOR, LIST_SEPARATOR);
            // Y por ultimo, si saque el ultimo item de la lista y me quedo un "|", lo fleto tambien
            if (listItems.equals(LIST_SEPARATOR)) listItems = "";
        }
        return listItems;
    }
	/**
	 * Retorna true, si item se encuentra en listItems. Si listItems tiene un *,
	 * Retorna false, en caso contrario. listItems es del estilo:
	 * '|FAC|OCV|' o '*' o null item es del estilo: 'FAC'
	 * @param allowPrefix indica si se chequearan las variantes usando "equals" o "startsWith"
	 */
	public static boolean isInList(String listItems, String item, boolean allowPrefix) {

		boolean isInItems = false;

		if (listItems != null && item != null) {

			if (isListAny(listItems)) {
				isInItems = true;
			} else if (!listItems.contains(LIST_SEPARATOR)) {
				//Hago una version mas rapida: no es una lista realmente, asi que quiero un equals
				isInItems = allowPrefix? item.startsWith( listItems ): item.equals(listItems);
			} else {
				StringTokenizer stDocTypes = new StringTokenizer(listItems,
						LIST_SEPARATOR, false);

				while (stDocTypes.hasMoreTokens() && !isInItems) {
					String token = stDocTypes.nextToken();
					isInItems = allowPrefix? item.startsWith( token ): item.equals(token);
				}
			}
		}

		return isInItems;
	}

    /**
     * Reemplaza un conjunto de caracteres por otro.
     */
    public static String replaceChars(String text, char[] ori, char[] rep) {
        return replaceChars(text, ori, rep, null);
    }

    /**
     * Reemplaza un conjunto de caracteres por otro, pasando por un Encoding si me lo especificaron
     */
    public static String replaceChars(String text, char[] ori, char[] rep, Charset encoding) {
        if (encoding != null) {
            text = new String(text.getBytes(), encoding);
        }

        for (int i = 0; i < ori.length; i++) {
            if (text.indexOf(ori[i])>=0) { //Mini optimizacion. No remplazo si no esta. IndexOf es mas rapido que contains
                text = text.replace(ori[i], rep[i]);
            }
        }
        return text;
    }

    /**
     * Reemplaza un conjunto de caracteres por otro. Devuelve un StringBuilder.
     */
    public static String replace(String original, String search, String replace) {
        if (isEmpty(original)) return original;
        // por ahora, uso un regular expression
        int len = search.length();
        //Si el replace es igual al search, tengo que moverme uno.
        //   Caso  ".txt" => ".txt.ok"
        // Pero sino, quiero reemplazar todo
        //   Caso  "-----1"  =>  "1"
        int replaceLen = replace.length(); //No quiere reemplazar dentro del reemplazo!
        for (int position = original.indexOf(search); position >= 0; position = original.indexOf(search,position+replaceLen)) {
            original = original.substring(0, position) + replace+ original.substring(position + len);
        }
        return original;
    }

    /**
     * Parsea una cadena de caracteres (separados por un caracter) y devuelve un
     * array de caracteres
     */
    public static char[] replaceCharsParser(String cadena, char sep) {
        String[] tokens = cadena.split("[" + sep + "]");
        char result[] = new char[tokens.length];
        for (int i = 0; i < tokens.length; i++) {
            if ((tokens[i] != null) && !"".equals(tokens[i])) {
                result[i] = tokens[i].charAt(0);
            } else {
                result[i] = ' ';
            }
        }
        return result;
    }

    public static String sanitizeASCII(String cadena) {
        return sanitizeASCII(cadena, true);
    }

    public static String sanitizeASCII(String cadena, boolean encodeStringBeforeReplaceChars) {
        if (cadena == null) return "";

        final char[] charsToBeReplaced = {
                'á', 'é', 'í', 'ó', 'ú', 'ñ', 'Á', 'É', 'Í', 'Ó', 'Ú', 'Ñ', '¿', 'º', 'Ã',
                '\u00F1', '\u00D1', '\u00E1', '\u00E9', '\u00ED', '\u00F3', '\u00FA', '\u00C1', '\u00C9', '\u00CD', '\u00D3', '\u00DA', '\u00FC', '\u00DC', '\u00e7', '\u00c7', '\u00b0', '\u00ba', '\u00aa', '\u00bf', '\u00a6',
				'\u00E0', '\u00E8', '\u00EC', '\u00F2', '\u00F9', '\u00A3', '\u00A7', '\u00EF', '\u00A5', '\u00FF', '\u00D6', '\u00B2', '\u00C3', '\u00A0'
        };
        final char[] replacementChars = {
                'a', 'e', 'i', 'o', 'u', 'n', 'A', 'E', 'I', 'O', 'U', 'N', '?', 'o', 'A',
                'n', 'N', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', 'u', 'U', 'c', 'C', 'o', 'o', 'a', '?', ':',
				'a', 'e', 'i', 'o', 'u', '$', '$', 'i', '$', 'y', 'O', '2', 'A', ' '
        };

        String res = encodeStringBeforeReplaceChars
                ? replaceChars(cadena, charsToBeReplaced, replacementChars, StandardCharsets.UTF_8)
                : replaceChars(cadena, charsToBeReplaced , replacementChars);
        return res.replaceAll("[^\\x20-\\x7E]", "_");
    }
		/**
	 * Permite extraer pedacitos de un string, de a rangos el formato es
	 * rango,rango,rango cada rango es un par from:to from y to son numeros 
	 * . de 0 a len-1 --> posiciones del string 
	 * . de -1 a -(len-1) --> posiciones del string, desde la derecha
	 * . 0 en to implica el final . 0 en from implica el ppio ej: substringFormat="0:2,4:5,-10:0"
	 */
	public static String fromToParser(String value, String substringFormat) {
		return fromToParser(value, substringFormat, null);
	}


	private static int[][] parseSubstringFormat( String substringFormat, int len, boolean padded )
	{
		StringBuilder keyBuild = new StringBuilder(padded? "P": "R").append(len).append('/').append(substringFormat);
		String key = keyBuild.toString();

		int result[][];

		if ( substringFormatCache.containsKey( key ) ){
			result = (int[][]) substringFormatCache.get( key );
		
		} else {
			String[] ranges = substringFormat.split("[,;]");
			result = new int[ ranges.length ][ 2 ];

			for (int i = 0; i < ranges.length; i++) {
				String[] range = ranges[i].split(":");
				int from = Integer.parseInt(range[0]);
				int to = Integer.parseInt(range[1].replace("+", "")); //El Java 6 no se banca el "+" adelante de los numeros

				//Acomodo el from por si es relativo
				if (from < 0) from = len + from; //lo tomo desde la derecha
				if (from < 0) from = 0; // corrijo el exceso
				if (from >= len) { //control limites
					if (!padded) result = null;
				}
				//Acomodo el to
				if (to < 0) to = len + to; //Si e negativo, es desde la derecha
				if (to < 0) to = 0; // corrijo el exceso
				if (to == 0) to = len; // 0 implica el ultimo caracter
				if (range[1].startsWith("+")) to = from + to; //Lo tomo relativo al from
				if (to > len) { //control limites
					if (!padded) result = null;
				}
				
				if ( result != null ) {
					result[ i ][ 0 ] = from;
					result[ i ][ 1 ] = to;
				}
			}

			substringFormatCache.put( key, result );
		}

		return result;
	}

	public static String fromToParser(String value, String substringFormat, String pad) {

		if (value==null) return null; //por las dudas, evito el NPE de abajo....
		int spec[][] = parseSubstringFormat( substringFormat, value.length(), pad != null );
		if ( spec == null ){
			return null;
		}
		if(("").equals(pad)) {
			throw new IllegalArgumentException("El Padding no puede ser vacio"); //Si puede ser null!!
		}
		/*
		 * Si solo tengo un grupo (por ejemplo "3:15") y no me paso del largo total (no necesito paddear)
		 * entonces simplemente hago un substring de ese grupo
		 */
		if (spec.length==1 && value.length() >= spec[ 0 ][ 1 ]) {
			return value.substring(spec[ 0 ][ 0 ], spec[ 0 ][ 1 ]);
		}
		
		StringBuilder valorAEscribir = new StringBuilder();
		for (int i = 0; i < spec.length; i++)
		{
			int from = spec[ i ][ 0 ];
			int to = spec[ i ][ 1 ];

			if (value.length() >= to) {
				valorAEscribir.append(value,from, to);
			} else {
				if (from > value.length()) {
                    valorAEscribir.append(String.valueOf(pad).repeat(Math.max(0, to - from)));
					
				} else {
					valorAEscribir.append(value.substring(from));
                    valorAEscribir.append(String.valueOf(pad).repeat(to - value.length()));
				}
			}
		}

		return valorAEscribir.toString();
	}


	/*
	 * public static String fromToParser(String value, String substringFormat) {
	 * String valorAEscribir = ""; String[] ranges = substringFormat.split(",");
	 * int len = value.length(); for(int i=0;i<ranges.length;i++) { String[]
	 * range = ranges[i].split(":"); int from = Integer.parseInt(range[0]); int
	 * to = Integer.parseInt(range[1]); if (from<0) from = len+from; if (from
	 * <0) from =0; //corrijo el exceso
	 *
	 * if (to<0) to = len+to; if (to<0) to = 0; //corrijo el exceso if (to==0)
	 * to = len;
	 *
	 * valorAEscribir += value.substring(from,to); } return valorAEscribir; }
	 */

	/**
	 * Genera una permutacion del String pasado como parametro.
	 */
	public static String stringPermutation(String source) {
		Random random = new Random();
		StringBuilder temp = new StringBuilder(source);
		StringBuilder target = new StringBuilder();

		int index = 0;
		while (temp.length() > 0) {
			index = (random.nextInt(Integer.MAX_VALUE) % temp.length()); // Esto me
																	// tiene que
																	// generar
																	// un numero
																	// al azar
																	// entre 0 y
																	// la long
																	// de temp.
			target.append(temp.charAt(index));
			temp.deleteCharAt(index);
		}
		return target.toString();
	}

	/**
	 * Chequea si un String es null o es vacio
	 * @param st
	 * @return
	 */
	public final static boolean isEmpty(String st){
		return (st==null || st.isEmpty());
	}
	public final static boolean isEmpty(StringBuilder st){
		return (st==null || st.length()==0);
	}
	public final static boolean isEmptyNull(String st){
		return (st==null || st.isEmpty() || st.trim().equalsIgnoreCase("null"));
	}
    public static boolean isNotEmpty(String value) {
	    return !isEmpty(value);
    }
	public static boolean isNotEmptyNull(String value) {
		return !isEmptyNull(value);
	}
    public static boolean isNotEmpty(StringBuilder st) {
	    return !isEmpty(st);
    }

	/**
	 * Compara dos Strings, considerandolos iguales si son null, vacios o
	 * compuestos solo de espacios (o sea, si trim() los deja vacios)
	 * @param s1 Primer string
	 * @param s2 Segundo string
	 * @return true si son iguales segun este criterio y false en caso contrario
	 * @author Matias Albanesi
	 */
	public static boolean emptySafeEquals(String s1, String s2) {
		if (isEmpty(s1)) {
			return isEmpty(s2);
		}
		else {
			return s1.equals(s2);
		}
	}

	public static boolean emptySafeContains(String s1, String s2) {
	    if (isEmpty(s1) || isEmpty(s2)) return false;
	    return s1.contains(s2);
    }

	public static boolean emptySafeStartsWith(String s1, String s2) {
	    if (isEmpty(s1) || isEmpty(s2)) return false;
	    return s1.startsWith(s2);
    }

	public static boolean isTrue(String st){
		if (st==null) return false;
		st = st.trim().toLowerCase();
		return st.equals("true") || st.equals("1") || st.equals("yes");
	}

	/**
	 * Compara dos Strings, considerandolos iguales si son null, vacios o
	 * compuestos solo de espacios (o sea, si trim() los deja vacios)
	 * @param s1 Primer string
	 * @param s2 Segundo string
	 * @return true si son iguales segun este criterio y false en caso contrario
	 * @author Matias Albanesi
	 */
	public final static boolean emptySafeEqualsIgnoreCase(String s1, String s2) {
		if (isEmpty(s1)) {
			return isEmpty(s2);
		}
		else {
			return s1.equalsIgnoreCase(s2);
		}
	}

	public final static int emptySafeIndexOfIgnoreCase(String s1, String s2) {
		if (isEmpty(s1) || isEmpty(s2)) {
			return -1;
		} else {
			return s1.toLowerCase().indexOf(s2.toLowerCase());
		}
	}


	/**
	 * Compara dos Strings, considerandolos null o vacio 'menor' que el resto
	 * @param s1 Primer string
	 * @param s2 Segundo string
	 */
	public final static int safeCompareTo(String s1, String s2) {
		if (isEmpty(s1)) {
			return 1;
		}
		else if (isEmpty(s2)) {
			return -1;
		} else {
			return s1.compareTo(s2);
		}
	}

	public static boolean emptySafeLenght(String s, int len) {
		return s != null && s.length() == len;
	}
	
	/**
	 * Apendea con cuidad, manteniendo la nullidad de las cosas
	 * @param appendTo StringBuilder sobre lo que se apendea (puede ser null)
	 * @param appendElement String a apendear (puede ser null)
	 * @return String buffer apendeado, o null si ambos son null
	 * @author Matias Albanesi
	 */
	public final static StringBuilder safeAppend(StringBuilder  appendTo, String appendElement) {
		return safeAppend(appendTo,appendElement,null);
	}
	public final static StringBuilder safeAppend(StringBuilder  appendTo, String appendElement, String separator) {
		if (isEmpty(appendElement)) {
			return appendTo;
		} else {
			if (appendTo == null) {
				appendTo = new StringBuilder();
			} else {
				if (!StringUtil.isEmpty(separator)) {
					appendTo.append(separator);
				}
			}
			appendTo.append(appendElement);
			return appendTo;
		}
	}
	/**
	 * Wrapper para Strings de {@link #safeAppend(StringBuilder, String, String)}
	 * @param appendTo
	 * @param appendElement
	 * @param separator
	 * @return
	 */
	public static String safeAppend(String appendTo, String appendElement, String separator) {
        if (isEmpty(appendTo)) return appendElement;
        if (isEmpty(appendElement)) return appendTo;
		StringBuilder returnValue = safeAppend(new StringBuilder(appendTo), appendElement, separator);
		if (returnValue != null) {
			return returnValue.toString();
		} else {
			return null;
		}
	}
	
	/**
	 * Agrega al final del string 'appentTo' el string 'appendElement' separandolos con el separador 'separator'
     * Si el string 'appendTo' es null, devuelvo el string 'appendElement'
	 * Si el string a agregar ya existia al final, no lo vuelve a agregar (y devuelve el valor de 'appendTo')
	 * Si el String 'appendTo' esta vacio, voy a appendear solamente el String 'appendElement' sin el 'separator'
	 * 
	 * @param appendTo
	 * @param appendElement
	 * @param separator
	 * @return
	 */
	public static String safeAppendNoRepeat(String appendTo, String appendElement, String separator) {
		if (isEmpty(appendTo)) return appendElement;
		if (isEmpty(appendElement)) return appendTo;
		boolean yaAgregado = appendTo.contains(appendElement);
		return yaAgregado ? appendTo : safeAppend(appendTo, appendElement, separator);
	}

	/**
	 * Calcula la editDistance (originalmente llamada Levenshtein Distance) entre dos Strings.
	 * Este valor representa en cuantos caracteres difiere un String del otro.
	 * @return un valor entero representando la editDistance entre los dos Strings pasados por parametro
	 */

	public static int calcEditDistance (String s, String t) {
		  int d[][];
		  int n;
		  int m;
		  int i;
		  int j;
		  char s_i;
		  char t_j;
		  int cost;
		    // Step 1
		    n = s.length ();
		    m = t.length ();
		    if (n == 0) {
		      return m;
		    }
		    if (m == 0) {
		      return n;
		    }
		    d = new int[n+1][m+1];
		    // Step 2
		    for (i = 0; i <= n; i++) {
		      d[i][0] = i;
		    }

		    for (j = 0; j <= m; j++) {
		      d[0][j] = j;
		    }
		    // Step 3
		    for (i = 1; i <= n; i++) {
		      s_i = s.charAt (i - 1);
		      // Step 4
		      for (j = 1; j <= m; j++) {
		        t_j = t.charAt (j - 1);
		        // Step 5
		        if (s_i == t_j) {
		          cost = 0;
		        }
		        else {
		          cost = 1;
		        }
		        // Step 6
		        d[i][j] = Minimo (d[i-1][j]+1, d[i][j-1]+1, d[i-1][j-1] + cost);
		      }
		    }
		    // Step 7
		    return d[n][m];

		  }

	/**
	 * @return El minimo de los tres valores pasados por parametro
	 */
	private static int Minimo (int a, int b, int c) {
		  int mi;

		    mi = a;
		    if (b < mi) {
		      mi = b;
		    }
		    if (c < mi) {
		      mi = c;
		    }
		    return mi;

	}

	public static String[] regexSplit(String srcString, String regexSplitExpression) {
		if (StringUtil.isNotEmpty(regexSplitExpression)) {
			return srcString.split(regexSplitExpression);
		} else {
			return new String[]{srcString};
		}
	}

	/**
	 * Version mas rapida de String.split, sin expresiones regulares
	 * Puedo escapar el separador en el value, usando \  (o "\\" si es un string java). Esto me impide que una de las partes termine en "\"
	 * Ejemplos:
	 *     "a:b:c"  separador=:  =>  {"a","b","c"}
	 *     "a\:b:c" separador=:  =>  {"a:b","c"}
	 *
	 * La version que recibe un size minimo, garantiza el largo del aray
	 * 	   "a:b:c"  min=4    =>  {"a","b","c", ""}
	 *
	 * La version notEmpy, elimina los vacios (raro usarlo con minimo, pero funcion genreando mas vacios al final
	 * 	   "a::b"  empty     =>  {"a","","b"}
	 *     "a::b"  no-empty  =>  {"a","b"}
	 * @param value
	 * @param separator
	 */
	public static String[] split( String value, char separator ) {
		return split(value, separator, 0, false);
	}
	public static String[] splitNotEmpty( String value, char separator ) {
		return split(value, separator, 0, true);
	}
	public static String[] split( String value, char separator, int sizeMinimo ) {
		return split(value, separator, sizeMinimo, false);
	}

	//Version que devuelve el vlaor original, o el primer substring si el separador existe
	//Especifica, pero mas eficiente que split(regex) para este caso
	public static String split0( String value, char separator ) {
		if (value==null) return null;
		int pos = value.indexOf(separator);
		if (pos>0) return value.substring(0,pos);
		else return value;
	}
	/**
	 * Version que  fuerza un largo minimo en el array, garantizando que no haya null sino espacios
	 * @param value
	 * @param separator
	 * @return
	 */
	public static String[] split( String value, char separator, int sizeMinimo,boolean removeEmpty ) {
		ArrayList<String> resultList = new ArrayList<String>();
		if ( value == null ) {
			if (sizeMinimo==0) return null;
		} else {
			//Esto es menos legible, pero evito el + de string, y es el 5 veces mas rapido
			//char valueArray[] = (value + separator).toCharArray();
			int valueLen = value.length();
			char[] valueArray = new char[valueLen+1];
			value.getChars(0, valueLen, valueArray,0);
			valueArray[valueLen] = separator;

			int i, n = valueArray.length, lastSep = -1;
			boolean anyEscapeChar = false; //flag por performance
			for (i = 0; i < n; i++) {
				if (valueArray[i] == separator) {
					//MAnejo el caso de que escapo el separador con un \ delante
					if (i > 0 && valueArray[i - 1] == '\\') {
						//No es un separador,pero tengo que sacarlo del string resultante.
						// Para no hacerlo siempre, prendo un flag aca y luego hago un replace mas abajo
						anyEscapeChar = true;
					} else {
						//String part = value.substring(lastSep + 1, i);
						String part = new String(valueArray, lastSep + 1, i - (lastSep + 1));
						if (!removeEmpty || !StringUtil.isEmptyNull(part)) {
							if (anyEscapeChar) {
								part = replace(part,"\\"+separator,""+separator);
								anyEscapeChar = false; //reseteo para el proximo grupo
							}
							resultList.add(part);
						}
						lastSep = i;
					}
				}
			}
		}
		for (int f = resultList.size(); f<sizeMinimo; f++) {
			resultList.add(""); //No hace mucho sentido poner esto Y removeEmpty=true
		}
		String result[] = new String[ resultList.size() ];
		resultList.toArray( result );
		return result;
	}

	public static String plural( long value, String singular ) {
		if ( singular == null || singular.length() < 0 )
			return singular;
		char ultimaLetra = singular.charAt( singular.length() - 1 );
		boolean terminaEnVocal = "aeiouAEIOU".indexOf( ultimaLetra ) >= 0;
		String sufijo = value == 1? "": terminaEnVocal? "s": "es";
		return singular + ( Character.isUpperCase( ultimaLetra )? sufijo.toUpperCase(): sufijo );
	}

	public static String cardinal( long value, String singular ) {
		return value + " " + plural( value, singular );
	}

	/**
	 * Rutinas de conversion de String's de Java a texto HTML que convierte
	 * acentos, e#es y demas caracteres centroeuropeos a "HTML entities" hexadecimales.
	 *
	 * Sacado (la idea principalmente) de HTMLParser.
	 * En lugar de utilizar entidades legibles como &aacute; o &ntilde; se usaran
	 * los codigos numericos al estilo &#nnn; para simplificar el algoritmo.
	 *
	 * @author Matias Albanesi Caceres
	 */
	//	 HTMLParser Library $Name:  $ - A java-based parser for HTML
	//	 http://sourceforge.org/projects/htmlparser
	//	 Copyright (C) 2004 Derrick Oswald
	//	 This library is free software; you can redistribute it and/or
	//	 modify it under the terms of the GNU Lesser General Public
	//	 License as published by the Free Software Foundation; either
	//	 version 2.1 of the License, or (at your option) any later version.

	/**
	 * Agregar un caracter a un StringBuilder, convirtiendolo si no es ASCII a una
	 * entidad numerica HTML. Es el cacho de codigo mas importante sacado del
	 * metodo original encode() del HTMLParser, trimmeado a entidades
	 * numericas exclusivamente (el codigo original soporta &aacute; y &#xNNNN;)
	 *
 	 * @author Matias Albanesi Caceres
	 */
	public static void appendToHTMLStringBuilder(char character, StringBuilder buf) {
		if (!(character > 0x001F && character < 0x007F)) {
			buf.append("&#");
			buf.append((int) character);
			buf.append(';');
		}
		else
			buf.append(character);
	}
	/**
	 * Si el String es null me devuelve "", sino el mismo String.
	 *
	 * @param string
	 * @return
	 */
	public static String nonNull(String string){
		if(string == null) return "";
		if(string.equals("null") ) return "";
		return string;
	}
	public static String nonNull(Object obj){
		if (obj == null) return "";
		return nonNull(obj.toString());
	}
	public static String nonEmpty(String string,String defaultValue){
		if(isEmpty(string)) return defaultValue;
		return string;
	}
	
	public static String toString(Object o) {
		if (o == null) {
			return null;
		} else {
			return String.valueOf(o);
		}
	}
	
	/**
	 * Si el String esta vacio o es null => me devuelve null
	 *
	 * @param string
	 * @return
	 */
	public static String emptyToNull(String string){
		if(isEmpty(string)) return null;
		return string;
	}


    /**
     * Convert a character to a numeric character reference.
     * Convert a unicode character to a numeric character reference of
     * the form #xxxx;.
     * @param character The character to convert.
     * @return The converted character.
     *
	 * @author Matias Albanesi Caceres
	 * @
     */
    public static String encodeToHTML(char character) {
		StringBuilder ret;
		ret = new StringBuilder(6); /* &#2147483647; necesitaria 13 caracteres */
		appendToHTMLStringBuilder(character, ret);
		return (ret.toString());
	}

    /**
	 * Encode a string to use references. Change all characters that are not ISO-8859-1 to
	 * their numeric character reference.
	 * Muy modificado para devolver entidades numericas siempre que un caracter no sea ASCII.
	 *
	 * @param string The string to translate.
	 * @return The encoded string.
	 * @author Matias Albanesi Caceres
	 */
    public static String encodeToHTML(String string) {
		int length;
		char c;
		StringBuilder ret;

		if (string == null)
			return null;

		ret = new StringBuilder(string.length() * 4); // 13 si todas las letras debieran escaparse, no es un caso tipico
		length = string.length();
		for (int i = 0; i < length; i++) {
			c = string.charAt(i);
			appendToHTMLStringBuilder(c, ret);
		}

		return (ret.toString());
	}

    public static String[] internetAddressParse(String addresses, boolean force){
    	InternetAddress[] ia;
    	String[] retorno = null;
		try {
			ia = InternetAddress.parse(addresses, force);
			retorno = new String[ia.length];
	    	for (int i = 0; i < ia.length; i++) {
				InternetAddress internetAddress = ia[i];	
				retorno[i] = internetAddress.getAddress();
			}
	    	
		} catch (AddressException e) {
			log.error("Ha ocurrido un error", e);
		}
    	
    	return retorno;    	
    }
    
    /**
	 * Valida la cantidad de numeros iguales consecutivos que hay en una cadena 
	 * determinada.
	 * en el parametro text se recibe el String a validar mientras que en 
	 * admitRepeat se recibe la cantidad de numeros iguales consecutivos 
	 * que se permiten.
	 * 
	 * Retorna true si la cantidad de numeros iguales consecutivos que contiene
	 * el String recibido es menor o igual al especificado en el parametro admitRepeat.  
	 * 
	 * @param text
	 * @param admitRepeat
	 * @return boolean
	 */
	public static boolean validateRepeatNumber(String text,int admitRepeat){
		
		Character character;
		Character characterCompare;
		boolean returnValue = true;
		
		int cont = 0;
		int number = 0;
		
		for(int i=0; i < text.length() && returnValue ; i++){
			character = text.charAt(i);
			if (Character.isDigit(character)) {
				try{
					number = Character.getNumericValue(character);
					for(int j = i+1; j <= i+admitRepeat; j++){
						if(i+admitRepeat < text.length()){
							characterCompare = text.charAt(j);
							try{
								if(Character.isDigit(characterCompare) && number == Character.getNumericValue(characterCompare)){
									cont++;
								}
							}catch (Exception e) {log.error("Error1: "+e.getMessage(), e);}
						}
					}
					if(cont >= admitRepeat){
						returnValue = false;
					}
					cont = 0;
				}catch (Exception e) {log.error("Error2: "+e.getMessage(), e);}
			}
		}
		return returnValue;
	}    
	
	
	/**
	 * Valida la cantidad de caracteres iguales consecutivos que hay en una cadena 
	 * determinada.
	 * En el parametro text se recibe el String a validar mientras que en 
	 * admitRepeat se recibe la cantidad de caracteres iguales consecutivos 
	 * que se permiten.
	 * 
	 * Retorna true si la cantidad de caracteres iguales consecutivos que contiene
	 * el String recibido es menor o igual al especificado en el parametro admitRepeat.  
	 * @param text
	 * @param admitRepeat
	 * @return boolean
	 */
	public static boolean validateRepeatCharacters(String text,int admitRepeat){

		String character;
		String characterCompare;
		int cont = 0;
		boolean returnValue = true;
		
		for(int i=0; i < text.length() && returnValue; i++){
			character = text.substring(i, i+1);
			if(VALID_LOWERS.contains(character)||VALID_UPPERS.contains(character)){
				for(int j = i+1; j <= i+admitRepeat; j++){
					if(i+admitRepeat < text.length()){
						characterCompare = text.substring(j, j+1);
						if(character.equals(characterCompare)){
							cont++;	
						}
					}
				}
				if(cont >= admitRepeat){
					returnValue = false;
				}
				cont = 0;
			}	
		}
		return returnValue;
	}
	
	
	public static String extractPipes(String value){
		String val = null;
		if(value!=null){
			val = StringUtil.replace(value,"|","");
		}
		return val;
	}
	
	public static String extractPipesAtInitAndEnd(String value){ 
		if (StringUtil.isEmptyNull(value)) return null;
		if (value.charAt(0)=='|'){
			value = value.substring(1);
		}
		if (value.charAt(value.length()-1)=='|'){
			value = value.substring(0,value.length()-1);
		}
		return value;
	}
	
	public static Collection<String> asArrayList(String ... items) {
        Collection<String> result = new ArrayList<String>(Arrays.asList(items));
		return result;
	}

	public static String asList(Collection<String> items) {
		return  asList(items,LIST_SEPARATOR_CHAR);
	}
	public static String asList(Collection<String> items, char separator) {
		StringBuilder result = new StringBuilder();
		for (String item : items) {
			result.append(item).append(separator);
		}

		return result.toString();
	}

    public static String asList(String... items) {
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            result.append(item).append(LIST_SEPARATOR_CHAR);
        }
        return result.toString();
    }


	/**
	 * Listamos solo 10 items, para no tener un log TAN largo
	 * @param items
	 * @return
	 */
	public static String toDebugString(Collection<?> items) {
		if (items==null) return "null";
		StringBuilder result = new StringBuilder("[");
		int i=0;
		String sep = "";
		for (Object item : items) {
			result.append(sep).append(item);
			i++;
            sep = ",";
			if (i>=10) {
				result.append("...total:").append(items.size());
				break;
			}
		}
		result.append("]");
		return result.toString();
	}

	/**
	 * 
	 * Parsea un String separado por pipes, con la posibilidad de tener 'propiedades' en cada String
	 * Ej: prueba:prop1=val1;prop2=val2|otrostring:otrapropiedad=otrovalor;nuevapropiedad=nuevoValor|tercerstring
	 * 
	 * En este caso, devuelve una lista de tuplas donde el primer componente de la tupla es el String
	 * y el segundo componente de la tupla, un Map con los pares clave/valor de cada propiedad
	 * De no haber propiedades para el String, el segundo componente es null
	 * 
	 * Tupla 1 1er componente: prueba
	 * Tupla 1 2do componente: <prop1,val1><prop2,val2>
	 * Tupla 2 1er componente: otrostring
	 * Tupla 2 2do componente: <otrapropiedad,otrovalor><nuevapropiedad,nuevoValor>
	 * Tupla 3 1er componente: tercerstring
	 * Tupla 3 2do componente: null
	 * 
	 * @param pipedStrings los String con propiedades separados por pipes
	 * @return lista de tuplas con los strings y sus Maps de propiedades
	 */
	public static List<Tuple<String, Map<String, String>>> getPipedStringsWithProperties(String pipedStrings) {
		List<Tuple<String, Map<String, String>>> result = new ArrayList<Tuple<String, Map<String, String>>>();
		
		if (pipedStrings != null) {
			for (String encodedStringProps : pipedStrings.split("[|]")) {
                result.add(getStringWithProperties(encodedStringProps));
			}
		}
		return result;
	}


    /**
     *
     * Parsea un String con la posibilidad de tener 'propiedades' en cada String
     * Ej: prueba:prop1=val1;prop2=val2
     *
     * Devuelve una tupla donde el primer componente de la tupla es el String (prueba)
     * y el segundo componente de la tupla, un Map con los pares clave/valor de cada propiedad (prop1 y prop2 con sus valores)
     * De no haber propiedades para el String, el segundo componente es null
     *
     * Tupla 1er componente: prueba
     * Tupla 2do componente: <prop1,val1><prop2,val2>
     *
     * @param stringWithProperties el String con propiedades
     * @return Tuplas con el String y sus Maps de propiedades
     */
    public static Tuple<String, Map<String, String>> getStringWithProperties(String stringWithProperties) {

        if (stringWithProperties == null) {
            return null;
        }

        String string;
        Map<String, String> props = null;

        //Encuentro si hay dos puntos separando el string de las propiedades
        int posicionSeparador = stringWithProperties.indexOf(":");
        if(posicionSeparador > -1) {
            string = stringWithProperties.substring(0, posicionSeparador);
            String encodedProps = stringWithProperties.substring(posicionSeparador + 1);
            props = new HashMap<String, String>();

            //Separo las properties por punto y coma
            for (String prop : encodedProps.split(";")) {

                //Encuentro la posicion del primer '='
                int equalsPos = prop.indexOf('=');
                if (equalsPos == -1) {
                    log.error("Propiedad mal formada en string [" + string + "]. Falta el '='. La cadena completa pasada al metodo [" + stringWithProperties + "]");
                } else {
                    String key = prop.substring(0, equalsPos).trim();
                    String value = prop.substring(equalsPos + 1);
                    props.put(key, value);
                }
            }
        } else {
            //No tiene separador, vino el string solo, sin propiedades
            string = stringWithProperties;
        }

        return new Tuple<String, Map<String,String>>(string, props);

    }

    /**
     * Transforma el pipedStrings que devolveria el metodo {@link #getPipedStringsWithProperties(String)} en un mapa
     *
     * @param pipedStrings
     * @return
     */
    public static Map<String, Map<String, String>> getPipedStringsWithPropertiesToMap(String pipedStrings) {
        Map <String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();

        List<Tuple<String, Map<String, String>>> tuples = getPipedStringsWithProperties(pipedStrings);
        if (!CollectionUtils.isEmpty(tuples)) {
            for(Tuple<String, Map<String, String>> tuple : tuples) {
                result.put(tuple.getFirst(), tuple.getSecond());
            }
        }
        return result;
    }

	public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression) {return splitToMapUsingRegex(srcString, regexSplitExpression, '=', null);}
	public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression, Map<String, String> targetMap) {return splitToMapUsingRegex(srcString, regexSplitExpression, '=', targetMap);}

	public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression, char keyValueSeparator, Map<String, String> targetMap) {
		return arrayToMap(regexSplit(srcString, regexSplitExpression), keyValueSeparator, targetMap);
	}

	public static Map<String, String> arrayToMap(String[] srcArray) {return arrayToMap(srcArray, '=', null);}
	public static Map<String, String> arrayToMap(String[] srcArray, Map<String, String> targetMap) {return arrayToMap(srcArray, '=', targetMap);}

	public static Map<String, String> arrayToMap(String[] srcArray, char keyValueSeparator, Map<String, String> targetMap) {
        if (targetMap == null) targetMap = new HashMap<>();
        if (ArrayUtils.isNotEmpty(srcArray)) {
			for (String src : srcArray) {
				if (src.contains(String.valueOf(keyValueSeparator))) {
					Pair<String, String> keyValue = toKeyValue(src, keyValueSeparator);
					targetMap.put(keyValue.getKey(), keyValue.getValue());
				}
			}
		}

		return targetMap;
	}

	/**
	 * Toma un String de la forma "key1=val1|key2=val2|key3=val3" y lo separa en un map de tres keys con sus values
	 * Conserva el orden usando un LinkedHashMap
	 *
	 * @param value
	 * @param separator
	 * @return mapa con los pares clave/valor, o un mapa vacio
	 */
	public static Map<String, String> splitToMapSameOrder(String value, char separator) {
		return splitToMap(value, separator, new LinkedHashMap<>());
	}

	/**
	 * Toma un String de la forma "key1=val1|key2=val2|key3=val3" y lo separa en un map de tres keys con sus values
	 * @param value
	 * @param separator
	 * @return mapa con los pares clave/valor, o un mapa vacio
	 */
	public static Map<String, String> splitToMap(String value, char separator) {
		return splitToMap(value, separator, null);
	}


	/**
	 * Toma un String de la forma "key1=val1|key2=val2|key3=val3" y lo separa en un map de tres keys con sus values
	 * @param value
	 * @param separator
	 * @return mapa con los pares clave/valor, o un mapa vacio
	 */
	private static Map<String, String> splitToMap(String value, char separator, Map<String, String> mapImplementation) {
		return arrayToMap(split(value, separator), mapImplementation);
	}

	/**
	 * Toma un map de keys y values y lo compone de la forma "key1=val1|key2=val2|key3=val3"
	 *
	 * @param map
	 * @return
	 */
	public static String joinFromMap(Map<String, String> map) {
		return joinFromMap(map, LIST_SEPARATOR_CHAR);
	}

	/**
	 * Toma un map de keys y values y lo compone de la forma "key1=val1|key2=val2|key3=val3"
	 *
	 * @param map
	 * @param separator
	 * @return
	 */
	public static String joinFromMap(Map<String, String> map, char separator) {
		if (map != null) {
			return map.keySet().stream().map(key -> key + "=" + map.get(key)).collect(Collectors.joining(String.valueOf(separator)));
		} else {
			return null;
		}
	}

	/**
	 * Busca una clave dentro de un string de la forma "key1=val1|key2=val2|key3=val3" y la actualiza
	 * Por ejemplo si se pasa key: key2 y value:tito, queda: "key1=val1|key2=tito|key3=val3"
	 * Si la clave no esta, la agrega
	 * Si en value se pasa null, se quita el par del string
	 *
	 * @param keyValueMap
	 * @param key
	 * @param value
	 * @return
	 */
	public static String updateKeyValueStringMap(String keyValueMap, String key, String value) {
		if (keyValueMap == null && key == null) return null;
		if (keyValueMap == null) keyValueMap = ""; //Lleno por primera vez
		Map<String, String> map = splitToMapSameOrder(keyValueMap, LIST_SEPARATOR_CHAR);
		if (value != null) {
			map.put(key, value);
		} else {
			//Quito el valor
			map.remove(key);
		}
		return joinFromMap(map);
	}

	/**
	 * Devuelve un value de una clave que esta en un string de la forma "key1=val1|key2=val2|key3=val3"
	 * Ej: para key2, devuelve val2
	 *
	 * @param keyValueMap
	 * @param key
	 * @return
	 */
	public static String getValueFromKeyValueStringMap(String keyValueMap, String key) {
		if (keyValueMap == null || key == null) return keyValueMap;
		Map<String, String> map = splitToMapSameOrder(keyValueMap, LIST_SEPARATOR_CHAR);
		return map.get(key);
	}

	/**
	 * Toma un string de la forma key=value y devuelve un Pair donde left=key y right=value
	 * Si no esta de esa forma, devuelve null
	 * @param keyValue
	 * @return
	 */
	public static Pair<String, String> toKeyValue(String keyValue) {
		return toKeyValue(keyValue, '=');
	}

	/**
	 * Toma un string de la forma key=value (o key[sep]value) y devuelve un Pair donde left=key y right=value
	 * Si no esta de esa forma, devuelve null
	 * @param keyValue
	 * @return
	 */
	public static Pair<String, String> toKeyValue(String keyValue, char sep) {
		if (keyValue != null) {
			int pos = keyValue.indexOf(sep);
			if (pos > 0) {
				return new ImmutablePair<>(keyValue.substring(0, pos), keyValue.substring(pos + 1));
			}
		}
		return null;
	}

	public static boolean getBooleanValue(String value, boolean defaultValue) {
		if (!StringUtil.isEmpty(value)) {
			return Boolean.parseBoolean(value);
		}
		return defaultValue;
		
	}

	/**
	 * Genera un string que puede ser usado como el like de una query Oracle
	 * 
	 * @param value valor a enmascarar
	 * @param mask mascara por la cual se pasa el value segun la siguiente forma:
	 * <pre>
	 * Si la mascara tiene punto (.) en una posicion, se conserva el caracter del value
	 * Si la mascara tiene un guion bajo (_) se pone el guion bajo y se pierde el cararcter del value
	 * Si la mascara tiene un porcentaje (%), se pone el porcentaje sin perder el caracter value
	 * 
	 * Ej:
	 * value  = Hola Mundo
	 * mask   = ..__......
	 * result = Ho__ Mundo
	 * 
	 * value  = Pedro1234
	 * mask   = %..._.....% (parece corrida, pero el % se ignora del conteo de posiciones)
	 * result = %Ped_o1234%
	 * 
	 * <pre>
	 * @return
	 */
	public static String generateLikeFromMask(String value, String mask) {
		if (StringUtil.isEmpty(value) || StringUtil.isEmpty(mask)) {
			return value;
		}
		StringBuilder result = new StringBuilder();
		int posValue = 0;
		//Recorro la mascara actualizando el posicionador del value
		for (char maskChar: mask.toCharArray()) {
			switch (maskChar) {
				case '%':
					result.append(maskChar);
					break;
				case '_':
					result.append(maskChar);
					posValue++;
					break;
				case '.':
					if (posValue >= value.length()) {
						throw new IllegalArgumentException("La mascara [" + mask + "] es mas larga que el value [" + value + "] (sin contar los %)");
					}
					result.append(value.charAt(posValue));
					posValue++;
					break;
				default:
					throw new IllegalArgumentException("Caracter [" + maskChar + "] no reconocido en la mascara [" + mask + "] para el value [" + value + "]");
			}
		}
			
		return result.toString();
	}

    /*
    //PARA IMPLEMENTAR @EBF
    public static String digitoVerificadorFrances(String input, ModoDigitoVerificadorFrances modoDigitoVerificadorFrances) {
        return DigitoVerificadorFrances.execute(input, modoDigitoVerificadorFrances);
	}
    */
    /*
    //PARA IMPLEMENTAR @EBF
	public static String addDigitoVerificadorFrances(String input, ModoDigitoVerificadorFrances modoDigitoVerificadorFrances) {
		return input+DigitoVerificadorFrances.execute(input, modoDigitoVerificadorFrances);
	}
	*/
    /*
    //PARA IMPLEMENTAR @EBF
	public static String digitoVerificadorRapipago(String input) {
        return DigitoVerificadorRapipago.execute(input);
	}*/
    /*
    //PARA IMPLEMENTAR @EBF
	public static String addDigitoVerificadorRapipago(String input) {
		return input+DigitoVerificadorRapipago.execute(input);
	}
	*/


	///**
	// * Calcula un digito verificador sobre la entrada
	// * <br>
	// * La entrada debe ser numerica (sin separador decimal, ni de miles, ni menos. Solo numeros)
	// * <br>
	// * Si la entrada no es numerica, convierte cada caracter en su representacion numerica y evalua sobre eso
	// *
	// * @param input
	// * @return
    //*/
    /*
    PARA IMPLEMENTAR @EBF
    public static String digitoVerificadorGenerico(String input) {
		if (StringUtil.isEmpty(input)) {
			throw new ApplicationException("La entrada no puede estar vacia");
		}
		boolean convertToNumericValue = !StringUtil.isNumber(input, false, false);
		StringBuilder result;
		if (convertToNumericValue) {
			result = new StringBuilder();
			//Convierto cada caracter en su valor numerico
			for (int i=0; i < input.length(); i++) {
				result.append((int)input.charAt(i));
			}
		} else {
			result = new StringBuilder(input); 
		}
		//Por ahora uso el mismo algoritmo que el Frances
		return digitoVerificadorFrances(result.toString(), ModoDigitoVerificadorFrances.MODO_DEFAULT);
	}
    */
    /*
        PARA IMPLEMENTAR @EBF

	public static String addDigitoVerificadorGenerico(String input) {
		return input+digitoVerificadorGenerico(input);
	}
    */
    /*
        PARA IMPLEMENTAR @EBF
    */
    /*
    public static String codigoBarraPublicacionRapipago(String codigoEmpresa, String referenceText,ar.com.sdd.ebf.bo.document.Document doc) {
        if (StringUtil.isEmpty(codigoEmpresa) || doc == null) {
            return null;
        }
        String amountPart = NumberUtil.formatNumber(NumberUtil.multiplyToBigDecimal(doc.getDueAmount(), NumberUtil.CIEN_SCALED).doubleValue(), 8, 0);
        String datePart = DateUtil.format(DateUtil.dueDateOrNextMonth(doc.getDueDate()), "yyDDD");
        String codePart = padNum(StringUtil.nonNull(referenceText), 15); //si llega a venir null, al menos pongo 0000
        StringBuilder barCode = new StringBuilder(codigoEmpresa);
        barCode.append(amountPart);
        barCode.append(datePart);
        barCode.append(codePart);
        barCode.append("0");
        barCode.append(amountPart);
        barCode.append(datePart);
        barCode.append(digitoVerificadorRapipago(barCode.toString()));
        return barCode.toString();
    }
    */
        public static String nvl(String... datos) {
            for (String dato : datos) {
                if (!isEmpty(dato)) return dato;
            }
            return "";
        }
        public static String nvlNull(String... datos) {
            for (String dato : datos) {
                if (!isEmptyNull(dato)) return dato;
            }
            return "";
        }


    /**
         * Chequea si el string pasado es un numero
         *
         * @param number String a verificar
         * @param couldHaveDecimalPoint Determina si el numero a verificar puede tener punto decimal
         * @param couldHaveMinus Determina si el numero a verificar puede tener un menos adelante para indicar negativo
         * @return
         */
	static final Pattern patternNumberUnsigned 		 = Pattern.compile("\\d+");
	static final Pattern patternNumberUnsignedDecimal= Pattern.compile("\\d+(\\.\\d+)?");
	static final Pattern patternNumberSigned   		 = Pattern.compile("-?\\d+");
	static final Pattern patternNumberSignedDecimal  = Pattern.compile("-?\\d+(\\.\\d+)?");
	public static boolean isNumber(String number, boolean couldHaveDecimalPoint, boolean couldHaveMinus) {
		if (StringUtil.isEmpty(number)) {
			return false;
		}
		Pattern pattern;
		if (couldHaveMinus) {
			pattern =couldHaveDecimalPoint?patternNumberSignedDecimal:patternNumberSigned;
		} else {
			pattern =couldHaveDecimalPoint?patternNumberUnsignedDecimal:patternNumberUnsigned;
		}
		return pattern.matcher(number).matches();
	}

    /**
     * Chequea si el string pasado es un numero entero positivo (sin signo menos, sin punto decimal)
     * @param number
     * @return
     */
    public static boolean isNumber(String number) {
	    return isNumber(number, false, false);
    }
	
	
	/**
	 * Une un array de Strings
	 * 
	 * @param splitted
	 * @param joinString
	 * @return
	 */
	public static String join(String[] splitted, String joinString) {
		if (joinString == null) {
			joinString = "";
		}
		if (splitted != null) {
			StringBuilder result = new StringBuilder();
			boolean first = true;
			for (String split : splitted) {
			    if (split != null) {
                    if (first) {
                        result.append(split);
                        first = false;
                    } else {
                        result.append(joinString).append(split);
                    }
                }
			}
			return result.toString();
		} else {
			return null;
		}
	}

	public static String join(String joinString, String... toJoin) {
	    return join(toJoin, joinString);
    }
	
	/**
	 * Toma un String y le quita todos los caracteres de nueva linea, dejando todo el texto en una sola linea
	 * 
	 * @param value
	 * @return
	 */
	public static String flatten(String value) {
		return flatten(value, "");
	}
	
	/**
	 * Toma un String y reemplaza todos los caracteres de nueva linea por el especificado, dejando todo el texto en una sola linea
	 * 
	 * @param value
	 * @param replaceNewLines
	 * @return
	 */
	public static String flatten(String value, String replaceNewLines) {
		if (value == null) {
			return null;
		}
		return value.replace("\r\n", replaceNewLines).replace("\n\r", replaceNewLines).replace("\n", replaceNewLines).replace("\r", replaceNewLines);
	}

	/**
	 * Dado un String, le remueve el tag CDATA
	 *  
	 * @param cdata
	 * @return
	 */
	public static String removeCDATA(String cdata) {
		if (cdata != null) {
			cdata = cdata.replace("<![CDATA[", "").replace("]]>", "");
		}
		return cdata;
	}
	
	/**
	 * Conviente los argumentos en pares clave:valor del mapa devuelto <br>
	 * El largo de los argumentos debe ser par
	 * 
	 * @param args
	 * @return
	 */
	public static Map<String, String> asMap(String ... args) {
		if (args == null) {
			return null;
		}
		if (args.length % 2 != 0) {
			throw new ApplicationException("Los argumentos tienen que ser pares");
		}
		Map<String, String> result = new HashMap<>();
		for (int i = 0; i < args.length; i+=2) {
			result.put(args[i], args[i+1]);
		}
		return result;
	}

	public static Map<String, String> asMap(ArrayList<String> args) {
        if (args == null) {
            return null;
        }
        if (args.size() % 2 != 0) {
            throw new ApplicationException("Los argumentos tienen que ser pares");
        }
        Map<String, String> result = new HashMap<>();
        for (int i = 0; i < args.size(); i+=2) {
            result.put(args.get(i), args.get(i+1));
        }
        return result;
    }
	
	public static String toXML(JAXBElement<?> element) {
		if (element == null) {
			return null;
		}
	    try {
	        JAXBContext jc = JAXBContext.newInstance(element.getValue().getClass());  
	        Marshaller marshaller = jc.createMarshaller();  
	        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);  

	        ByteArrayOutputStream baos = new ByteArrayOutputStream();
	        marshaller.marshal(element, baos);
	        return baos.toString();
	    } catch (Exception e) {
	        log.error("Error al convertir a XML el elemento [" + element + "]", e);
	    }      
	    return "";
	}
	
	public static String trunc(String input, int length) {
		if (input == null) {
			return null;
		}
		return input.substring(0, Math.min(input.length(), length));
	}


    public static String getFormattedXML(String xml) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(is);
            return getXMLFromDoc(doc, true,  false);
        } catch (Exception e) {
            throw new ApplicationException("Error al formatear XML", e);
        }
    }


    /**
     * Arma un String de XML en base al documento w3c que recibe
     *
     * @param doc el documento org.w3c.dom.Document (no confundir con un DocumentBean)
     * @param indent identa o no el documento a 4 posiciones
     * @param removeRootElementAndHeader quita el primer elemento y el header ?xml?. El documento resultante no es un XML valido, pero nos sirve para armar las firmas para Santander
     * @return un string XML
     */
    public static String getXMLFromDoc(Document doc, boolean indent, boolean removeRootElementAndHeader) {
        try {
            DOMSource domSource = new DOMSource(doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (removeRootElementAndHeader) {
                transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            } else {
                transformer.setOutputProperty(OutputKeys.METHOD, "xml");
                transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");
            }
            if (indent) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            }
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            String result = sw.toString();

            if (removeRootElementAndHeader && !StringUtil.isEmpty(result)) {
                /*
                    No hay una forma sencilla de eliminar el elemento root de un documento XML
                    Asi que lo borramos directamente en el string generado
                 */
                String eol = indent ? StringUtil.EOL : "";
                //Busco donde termina el primer tag y corto desde ahi
                int finPrimerTag = result.indexOf(">" + eol);
                result = result.substring(finPrimerTag + 1 + eol.length());
                //Busco donde empieza el ultimo tag y corto desde ahi
                int comUltimoTag = result.lastIndexOf(eol +"<");
                result = result.substring(0, comUltimoTag + eol.length());
            }

            return result;
        } catch (Exception e) {
            throw new ApplicationException("Error al formatear XML", e);
        }
    }

    /**
     * Es la contrapartida de {@link #splitToMap(String, char)} <br>
     * Rearma unas properties separadas por pipe (u otro separador), cambiando el valor de las que ya tiene y agregando las que faltan
     *
     * @param propertiesMap un map con los pares clave-valor de las nuevas properties a cambiar. Si la clave no esta entre las que ya estaban, se agrega al final
     * @param actualProperties las properties que ya estan (formato key=val|key2=val2), que pueden ser pisadas por el propertiesMap
     * @param listSeparatorChar el separador de las properties (pipe en general)
     * @return la nueva lista de properties, con los valores cambiados o agregados
     */
    public static String addToMap(Map<String, String> propertiesMap, String actualProperties, char listSeparatorChar) {
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            //no hay nada para hacer
            return actualProperties;
        } else {
            Map<String, String> actualPropertiesMap = splitToMap(actualProperties, listSeparatorChar);
            //Piso los valores del viejo con los del nuevo
            actualPropertiesMap.putAll(propertiesMap);

            //Itero el map y reconstruyo el string
            StringBuilder result = new StringBuilder();
            String sep = "";
            for (Map.Entry<String, String> entry : actualPropertiesMap.entrySet()) {
                //Esquivo los values=null
                if (entry.getValue() != null) {
                    result.append(sep).append(entry.getKey()).append("=").append(entry.getValue());
                    sep = String.valueOf(listSeparatorChar);
                }
            }
            return result.toString();
        }

    }

	///**
	// * Devuelve un iterable formateado como csv
	// *
	// * @param iterable cualquier lista o coleccion que soporte Iterable
	// * @param groovyEblExpressions una lista de expresiones groovy EBL (se les va a apendear el G:)
	// * @param headers una lista opcional de encabezados. Tiene que tener el mismo tamaño que la lista de expresiones
	// * @param separator un separador opcional, si es null, se usa la coma
	// * @return
	// */
    /*
    PARA IMPLEMENTAR @EBF
    public static String printAsCSV(Iterable<?> iterable, List<String> groovyEblExpressions, List<String> headers, String separator) {
    	if (isEmpty(separator)) {
    		separator = ",";
		}

    	if (iterable != null && !CollectionUtils.isEmpty(groovyEblExpressions)) {
    		StringBuilder result = new StringBuilder();

			EblContext ctx = new EblContext();
			EblParser eblParser = new EblParser(ctx);
			Iterator<?> iterator = iterable.iterator();

			if (!CollectionUtils.isEmpty(headers)) {
				if (groovyEblExpressions.size() != headers.size()) {
					throw new ApplicationException("La cantidad de encabezados [" + headers.size() + "] no coincide con la cantidad de columnas [" + groovyEblExpressions.size() + "]");
				}
				String prependSep = "";
				for (String header : headers) {
					result.append(prependSep).append(header);
					prependSep = separator;
				}
				result.append(EOL);
			}

			while (iterator.hasNext()) {
				String prependSep = "";

				Object obj = iterator.next();
				ctx.entity = obj;

				if (obj instanceof ar.com.sdd.ebf.bo.document.Document) {
					ctx.doc = (ar.com.sdd.ebf.bo.document.Document) obj;
				} else if (obj instanceof DocumentData) {
					ctx.documentData = (DocumentData) obj;
				} else if (obj instanceof Settlement) {
					ctx.sett = (Settlement) obj;
				}

				for (String spec : groovyEblExpressions) {
					String expression = "G: " + spec;
					result.append(prependSep);
					try {
						result.append(eblParser.evalString(expression));
					} catch (Exception e) {
						log.error("Error evaluando [" + spec + "] para el objeto [" + obj + "]", e);
						result.append("[---ERROR!---]");
					}
					prependSep = separator;
				}
				result.append(EOL);

			}

			return result.toString();
		}
    	return null;
	}
     */

	public static Set<String> asSet(String accessGroup) {
		return new HashSet<>(Arrays.asList(split(accessGroup, ',')));
	}

	/**
	 * Applies the specified mask to the card number.
	 *
	 * @param cardNumber The card number in plain format
	 * @param maskChar The number mask pattern. Use # to include a digit from the
	 * card number at that position, use x to skip the digit at that position
	 *
	 * @return The masked card number
	 */
	public static String maskCardNumber(String cardNumber, char maskChar) {
		if (isEmptyNull(cardNumber)) return null;
		String s = cardNumber.replaceAll("\\D", "");
		int end = s.length() - 4;
		String overlay = StringUtils.repeat(maskChar, end);
		return StringUtils.overlay(s, overlay, 0, end);
	}

	// Los accessToken de Mercado Pago (circuito Money Transfer) tienen la siguiente cara:
    // APP_USR-3754192518131502-060920-811b942ded3bb52e59bf6c1843f64c04-77990944
	public static String maskMercadoPagoAccessToken(String accessToken) {
	    if (StringUtil.isEmpty(accessToken)) return accessToken;

        String result;
        int firstDashPos = accessToken.indexOf('-');
        if (firstDashPos > 0) {
            result = accessToken.substring(0, firstDashPos);
            int lastDashPos = accessToken.lastIndexOf('-');
            if (lastDashPos > 0 && lastDashPos != firstDashPos) {
                result += accessToken.substring(firstDashPos, lastDashPos).replaceAll("[A-Za-z0-9]", "*");
                result += accessToken.substring(lastDashPos);
            } else {
                result += accessToken.substring(firstDashPos).replaceAll("[A-Za-z0-9]", "*");
            }
        } else {
            result = accessToken;
        }

        return result;
    }

	public static String replaceCharacters(String value ,String regex, String replaceWith) {
	    value = value.replaceAll(regex, replaceWith);
	    return  value;
    }

    public static String removeAccents(String s) {
	    int ampIndex = s.indexOf("&");
	    int semicolonindex = s.indexOf(";");
        String letter;

	    while (ampIndex != -1 && semicolonindex != -1) {
	        letter =  s.substring(ampIndex + 1, ampIndex + 2);//Assign the first letter after the Ampersand
            String accent = s.substring(ampIndex, semicolonindex + 1);
            s = s.replaceAll(accent, letter);
            ampIndex = s.indexOf("&");
            semicolonindex = s.indexOf(";");
        }
	    return s;
    }

	/**
	 * Parte un string en dos partes: desde 0 a la posicion del index (exclusivo), y de index hasta el final
	 * Ej
	 * "tito" con index 0 = [], [tito]
	 * "tito" con index 1 = [t], [ito]
	 * "tito" con index 2 = [ti], [to]
	 * "tito" con index 3 = [tit], [o]
	 * "tito" con index 4 = IndexOutOfBoundsException
	 * "tito" con index -1 = IndexOutOfBoundsException
	 *
	 * @param s
	 * @param index
	 * @return
	 */
    public static String[] splitAtIndex(String s, int index) {
		if (s == null) return null;
		if (index >= s.length() || index < 0) throw new IndexOutOfBoundsException();
		return new String[] {s.substring(0, index), s.substring(index)};
	}

	public static String removeBOM(String text) {
    	if (text.charAt(0) == ByteOrderMark.UTF_BOM) {
			return text.substring(1);
		} else {
    		return text;
		}
	}

	/**
	 * Parte una linea en lineas de lengthToSplit largo, poniendo un \n al final de cada linea
	 * Ej "dabale_arroz_a_la_zorra_el_abad" con lengthToSplit = 5 produce:
	 * dabal
	 * e_arr
	 * oz_a_
	 * la_zo
	 * rra_e
	 * l_aba
	 * d
	 *
	 * @param line
	 * @param lengthToSplit
	 * @return
	 */
	public static String splitLineByLength(String line, int lengthToSplit) {
    	if (line == null) return null;
    	if (lengthToSplit == 0) return line;
    	StringBuilder result = new StringBuilder();
    	for (int i = 0; i < line.length(); i++) {
    		result.append(line.charAt(i));
    		//Parto la linea en el largo, salvo que sea el ultimo cararcter
    		if ((i + 1) % lengthToSplit == 0 && i != line.length() - 1) {
    			result.append("\n");
			}
		}
    	return result.toString();
	}

	/**
	 * Devuelve si un cuit es valido
	 * - No esta vacio
	 * - Es de 11 posiciones
	 * - Es numerico
	 * @param cuit
	 * @return
	 */
	public static boolean isValidCuit(String cuit) {
		if (StringUtil.isEmptyNull(cuit)) {
			return false;
		}

		cuit = StringUtil.replace(cuit, "-", "").trim();

		// Verificar la longitud del CUIT
		if (cuit.length() != 11) {
			return false;
		}

		// Verificar que todos los caracteres sean dígitos
		if (!StringUtils.isNumeric(cuit)) {
			return false;
		}

		// Esto son los prefijos validos
		//  20, 23, 24, 25, 26 y 27 para Personas Físicas
		//  30, 33 y 34 para Personas Jurídicas.
		String prefix = cuit.substring(0, 2);
		if (!StringUtil.in(prefix, "20", "23", "24", "25", "26", "27", "30", "33", "34")) {
			return false;
		}

		// Calcular el dígito verificador
		int[] coefficients = {5, 4, 3, 2, 7, 6, 5, 4, 3, 2};
		int sum = 0;
		for (int i = 0; i < coefficients.length; i++) {
			sum += (cuit.charAt(i) - '0') * coefficients[i];
		}
		int remainder = sum % 11;
		int verificador = remainder == 0 ? 0 : remainder == 1 ? 9 : 11 - remainder;

		// Comparar el dígito verificador calculado con el proporcionado
		int providedVerificador = cuit.charAt(10) - '0';
		return verificador == providedVerificador;
	}


	public static boolean isValidRut(String rut) {
		// Despejar Puntos
		String valor = StringUtil.replace(rut,".","");

		// Despejar Guion
		valor = StringUtil.replace(valor,"-","");

		// Si no cumple con el mínimo ej. (n.nnn.nnn)
		if(valor.length() < 8) {
			return false;
		}

		// Aislar Cuerpo y Dígito Verificador
		String cuerpo = valor.substring(0,valor.length()-1);
		String dv = valor.substring(valor.length()-1).toUpperCase();

		// Formatear RUN
		rut = cuerpo + "-"+ dv;


		// Calcular Digito Verificador
		long suma = 0;
		long  multiplo = 2;

		// Para cada digito del Cuerpo
		for(int i=1;i<=cuerpo.length();i++) {

			// Obtener su Producto con el Múltiplo Correspondiente
			long index = multiplo * Character.getNumericValue(valor.charAt(cuerpo.length() - i));

			// Sumar al Contador General
			suma = suma + index;

			// Consolidar Multiplo dentro del rango [2,7]
			if(multiplo < 7) { multiplo = multiplo + 1; } else { multiplo = 2; }

		}

		// Calcular Digito Verificador en base al Modulo 11
		long dvEsperado = 11 - (suma % 11);

		// Casos Especiales (0 y K)
		dv = dv.equals("K")?"10":dv;
		dv = dv.equals("0")?"11":dv;

		// Validar que el Cuerpo coincide con su Dígito Verificador
		if(dvEsperado != Long.parseLong(dv)) {
			return false;
		}

		// Si todo sale bien, eliminar errores (decretar que es válido)
		return true;
	}


	/*
	*  Saco el DNI de algo que pueda ser un CUIT o ya mismo un DNI
	*/
	public static String dniFromCuit(String cuit) {
		if (isEmptyNull(cuit)) return "";
		if (cuit.length() == 11) return cuit.substring(2,10);
		return cuit;
	}

	public static String formatCuit(String cuit) {
	    if (isEmptyNull(cuit)) return "";
	    if (cuit.length() == 11 && !cuit.contains("-")) return cuit.substring(0, 2) + "-" + cuit.substring(2, 10) + "-" + cuit.substring(10);
	    return cuit;
    }

	//Soporta una lista de formatos separdos por | y los aplica en orden
	static public String applyFormat(String format, String value, int  size) {
		if (StringUtil.isNotEmpty(format)) {
			for (String formatTag : StringUtil.listValues(format)) {
				String formatTagUpper=formatTag.toUpperCase();
				if (formatTagUpper.startsWith("PADR:")) {
					formatTag += ' '; // Para asegurarme que tengo el largo correcto, al menos un espacio
					char pad = formatTag.substring(5, 6).charAt(0);
					//size opcional despues del PADR:x:size
					if (formatTagUpper.length() > 7) {
						size = Integer.parseInt(formatTagUpper.substring(7));
					}
				value = StringUtil.padd(value, size, pad, StringUtil.PADD_RIGHT);
				} else if (formatTagUpper.startsWith("PADL:")) {
					formatTag += ' '; // Para asegurarme que tengo el largo correcto, al menos un espacio
					char pad = formatTag.substring(5, 6).charAt(0);
					//size opcional despues del PADR:x:size
					if (formatTagUpper.length() > 7) {
						size = Integer.parseInt(formatTagUpper.substring(7));
					}
				value = StringUtil.padd(value, size, pad, StringUtil.PADD_LEFT);
				} else if (formatTagUpper.startsWith("FILL_AT:")) {
					String formatSpecs = formatTag.substring("FILL_AT:".length());
					String[] formatSpecsParts = formatSpecs.split(",");
				Integer position = Integer.valueOf(formatSpecsParts[0]);
				char pad = formatSpecsParts[1].charAt(0);
				value = StringUtil.padd(value, size, pad, StringUtil.FILL_AT, position);
				} else if (formatTagUpper.startsWith("FROMTO:")) {
					String fromTo = formatTag.substring(7);
				value = StringUtil.fromToParser(value, fromTo);
				} else if (formatTagUpper.startsWith("TRIMZERO")) { //ojo, uso start, poner primer antes que TRIM
				value = StringUtil.trimLeadingSpacesAndZeroes(value);
				} else if (formatTagUpper.startsWith("TRIM:")) {
					value = StringUtil.trimAll(value, formatTag.substring("TRIM:".length()).charAt(0));
				} else if (formatTagUpper.startsWith("TRIM")) {
				value = value.trim();
				} else if (formatTagUpper.startsWith("LTRIM:")) { //ej, LTRIM:0
					value = StringUtil.trimLeading(value, formatTag.substring("LTRIM:".length()).charAt(0));
				} else if (formatTagUpper.startsWith("RTRIM:")) { //ej, LTRIM:0
					value = StringUtil.trimTrailing(value, formatTag.substring("RTRIM:".length()).charAt(0));
				} else if (formatTagUpper.startsWith("RIGHT:")) {
					value = StringUtils.right(value, Integer.parseInt(formatTag.substring("RIGHT:".length())));
				} else if (formatTagUpper.startsWith("LEFT:")) {
					value = StringUtils.left(value, Integer.parseInt(formatTag.substring("LEFT:".length())));
				} else if (formatTagUpper.startsWith("PRINTF:")) {
					value = String.format(formatTag.substring("PRINTF:".length()), value);
				} else if (formatTagUpper.startsWith("LOWER")) {
				value = value.toLowerCase();
				} else if (formatTagUpper.startsWith("UPPER")) {
				value = value.toUpperCase();
				} else if (formatTagUpper.startsWith("SANITIZE")) {

				value = sanitizeASCII(value).  //Todo lo no ASCII a _ y
						replaceAll("[\\\']", "_");  //Comillas simples(Escapada) a _  . Otras serian: "[\\\\/\\*\\?]"
				value = StringUtil.padd(value, size, ' ', StringUtil.PADD_RIGHT);
				} else if (formatTagUpper.startsWith("EXCELNUMBER")) {
					//Remplazo los .00 al final que pueen venir si es un numero visto como texto
					if (value.endsWith(".00")) value = value.substring(0, value.length() - 3);
				}
			}
		}
		return value;
	}
    public static String generateRandomNumberSixDigitsString() {
	    return generateRandomNumberSixDigitsString("%06d");
    }

    public static String generateRandomNumberSixDigitsString(String format) {
        // It will generate 6 digit random Number.
        // from 0 to 999999
        Random rnd = new Random();
        int number = rnd.nextInt(999999);

        // this will convert any number sequence into 6 character.
        return String.format(format, number);
    }

	public static String generateTokenUrlFormat() {
        //Genero un token
        byte[] randomBytes = new byte[100];
        Random random = ThreadLocalRandom.current();
        random.nextBytes(randomBytes);
        String encoded = Base64.getUrlEncoder().encodeToString(randomBytes);
        //Tomo los primeros 50
        return encoded.substring(0, 50);
    }

    public static String obfuscate(Long value) {
	    if (value == null) {
	        return null;
        } else if (value >= 0) {
	        return Obfuscate.obfuscate(value);
        } else {
            return "-" + Obfuscate.obfuscate(Math.abs(value));
        }
    }

    public static Long deobfuscate(String value) {
	    if (value == null) {
	        return null;
        } else if (value.startsWith("-")) {
            return Obfuscate.illuminate(value.substring(1)) * -1L;
        } else {
            return Obfuscate.illuminate(value);
        }
    }

    /**
     * Recibe un string que lo parte por los | y devuelve el que esta en la posicion index
     * Si index > cantidad de splits, devuelve string vacio
     * Ej: getSplit("tito|puente|asd", 0) = "tito"
     *     getSplit("tito|puente|asd", 2) = "asd"
     *     getSplit("tito|puente|asd", 3) = ""
     *     getSplit("", 0) = ""
     *
     * @param value
     * @param index
     * @return
     */
    public static String getSplit(String value, int index) {
	    if (StringUtil.isEmptyNull(value)) return "";
        List<String> values = listValues(value, LIST_SEPARATOR_CHAR);
        if (index >= 0 && index < values.size()) {
            return values.get(index);
        } else {
            return "";
        }
    }

    public static String getJAXBValue(JAXBElement<?> element) {
        if (element == null || element.isNil()) {
            return "";
        } else {
            return nonNull(element.getValue());
        }
    }

    public static boolean containsAll(String value, char character) {
        if (isEmpty(value)) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (c != character) {
                return false;
            }
        }
        return true;
    }

    /**
     * Devuelve los ultimos 'cant' caracteres de un String
     * Ej:
     * lastSubstring("pepe", 3) = "epe"
     * lastSubstring("pepe", 4) = "pepe"
     * lastSubstring("pepe", 0) = ""
     * lastSubstring("pepe", -1) = ""
     * lastSubstring("pepe", 5) = "pepe"
     * @param value
     * @param cant
     * @return
     */
    public static String lastSubstring(String value, int cant) {
        if (isEmpty(value)) {
            return value;
        }
        if (cant >= value.length()) {
            return value;
        } else if (cant > 0) {
             return value.substring(value.length() - cant);
        } else {
            return "";
        }
    }

	/**
	 * Evalua si un String es null o "", y en caso de que no lo sea se fija si es igual (equals) a algun String pasado como parametro
	 *
	 * @param str1          Texto a evaluar
	 * @param strsToCompare Textos contra los que comparar
	 */
    public static boolean isEmptyOrEquals(String str1, String... strsToCompare) {
    	if (isEmpty(str1)) return true;
    	for (String strToCompare : strsToCompare) {
    		if (str1.equals(strToCompare)) return true;
		}

    	return false;
    }

    /**
     * Evalua si str esta dentro de args.
     * Si str esta vacio (null o empty) devuelve false
     * Si args es null devuelve false
     *
     * @param str
     * @param args
     * @return
     */
    public static boolean in(String str, String... args) {
        if (isEmpty(str)) {
            return false;
        }
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (emptySafeEquals(str, arg)) {
                return true;
            }
        }
        return false;
    }

	/*
	*  Una forma algo mas comoda de tomar un valor para algo que esta entre cotas
	*       valor,  [desde, hasta, texto]...    devuelve texto si el valor es >=dede y <= hasta.  Desde null implica -infinito, hasta=null es infinito
	*
	*       todos los valores se interpretan como bigdecimal
	* */
	public static String mapInRanges(String value, String...rangeTexts) {
		if (isEmpty(value)) {
			return "";
		}
		BigDecimal val = new BigDecimal(value);
		//horrible
		BigDecimal from = null;
		BigDecimal to  = null;
		int i=0;
		for (String rangeText : rangeTexts) {
			switch (i%3)  {
				case 0: if (rangeText!=null) from=new BigDecimal(rangeText); break;
				case 1: if (rangeText!=null) to=new BigDecimal(rangeText); break;
				case 2: {
					if ( (from==null || NumberUtil.bigDecimalMenorOIgual(from, val))
						&& (to==null || NumberUtil.bigDecimalMenor(val, to))) {
						return rangeText;
					}	else {
						from = null;
						to   = null;
					}
				} break;
			}
			i++;
		}
		return "";
	}

	//Variantes comodas:
	public static String mapInRanges(Integer value, String...rangeTexts) {
		return mapInRanges(value.toString(), rangeTexts);
	}


	public static class Obfuscate {

        //adjust to suit:
        final static int feistelRounds = 4;
        final static int randRounds = 4;
        final static long seed = 69420;

        // modulus for half a string:
        final static long mod = 60466176; //36^5

        private static long f (long x) {
            // http://en.wikipedia.org/wiki/Linear_congruential_generator
            final long a = 12+1;
            final long c = 1361423303;
            x = (x + seed) % mod;
            int r = randRounds;
            while (r-- != 0) {
                x = (a*x+c) % mod;
            }
            return x;
        }

        public static String obfuscate (long i) {
            long a = i / mod;
            long b = i % mod;
            int r = feistelRounds;
            while (r-- != 0) {
                a = (a + f(b)) % mod;
                b = (b + f(a)) % mod;
            }
            return pad5(Long.toString(a, 36)) + pad5(Long.toString(b, 36));
        }

        public static long illuminate (String s) {
            long a = Long.valueOf(s.substring(0,5),36);
            long b = Long.valueOf(s.substring(5,10),36);
            int r = feistelRounds;
            while (r-- != 0) {
                b = (b - f(a)) % mod;
                a = (a - f(b)) % mod;
            }
            // make the modulus positive:
            a = (a + mod)%mod;
            b = (b + mod)%mod;

            return a*mod+b;
        }

        public static String pad5(String s) {
            return String.format("%5s", s).replace(' ', '0').toUpperCase(Locale.ENGLISH);
        }
    }

	public static boolean patternMatches(String emailAddress, String regexPattern) {
		return Pattern.compile(regexPattern)
				.matcher(emailAddress)
				.matches();
	}

	public static boolean isValidEmailAddress(String emailAddress) {
		return patternMatches(emailAddress, EMAIL_ADDRESS_VALIDATION_PATTERN);
	}
}