package ar.com.sdd.commons.util.converter;


import ar.com.sdd.commons.util.SynchronizedSimpleDateFormat;

import java.text.ParseException;
import java.util.Date;


/**
 * Convierte entre Fechas y Strings que representan fechas.
 */
public class StringToDateConverter implements DataConverter {

	private static StringToDateConverter instance  = null;
	private static final SynchronizedSimpleDateFormat formatter = new SynchronizedSimpleDateFormat("dd/MM/yyyy");
	private static final SynchronizedSimpleDateFormat alternateFormatter = new SynchronizedSimpleDateFormat("yyyy-MM-dd");


	//-------------------------------------------------------------------------//

	public StringToDateConverter() {}


	protected static StringToDateConverter getInstance() {
		if (instance == null) instance = new StringToDateConverter();
		return instance;
	}


	/**
	 * Obtiene una fecha a partir de un String.
	 */
	public static Date convertTo(String o) {
		return (Date) getInstance().convertDataTo(o);
	}


	/**
	 * Obtiene un String a partir de una fecha. Devuelve "" si la fecha es nula.
	 */
	public static String convertFrom(Date o) {
		String dateStr = (String) getInstance().convertFromData(o);
		return (dateStr != null) ? dateStr : "";
	}


	public Object convertDataTo(Object o) {

		if ((o == null) || ((String)o).equals("") || ((String)o).equals("null") )
			return null;

		if ( !(o instanceof String) )
			throw new IllegalArgumentException("El objeto no es String");

		Date fecha = null;
		try {
			fecha = formatter.parse((String) o);
		} catch (ParseException ex) {
			// Soporta un formato alternativo
			try {
				fecha = alternateFormatter.parse((String) o);
			} catch (ParseException ex2) {
				throw new IllegalArgumentException("Formato del string invalido: "
												 + "[" + ex.getMessage() + "]");
			}
		}

		return fecha;
	}


	public Object convertFromData(Object o) {

		if (o == null) return null;

		if ( !(o instanceof Date) ) {
			throw new IllegalArgumentException("El objeto a convertir no es Date: [" + o + "]");
		}

		Date fecha = (Date) o;
		return formatter.format(fecha);
	}

}

