/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.commons.util.Tuple;
import groovy.json.JsonSlurper;
import groovy.json.internal.LazyMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class StringUtil {
    public static final String LANG_ES = "es";
    public static final String LANG_EN = "en";
    public static final String PADD_LEFT = "PADD_LEFT";
    public static final String PADD_RIGHT = "PADD_RIGHT";
    public static final String FILL_AT = "FILL_AT";
    public static final char LIST_SEPARATOR_CHAR = '|';
    public static final char AT_SEPARATOR_CHAR = '@';
    public static final String LIST_SEPARATOR = String.valueOf('|');
    public static final String LIST_ANY = "*";
    public static final String LIST_NONE = "~";
    public static final String LIST_ANY_SEP = "|*|";
    private static final String LIST_NONE_SEP = "|~|";
    public static final String PAD_SPC = " ";
    public static final String VALID_UPPERS = "ABCDEFGHIJKLMNNOPQRSTUVWXYZ";
    public static final String VALID_LOWERS = "abcdefghijklmnnopqrstuvwxyz";
    public static final String EOL = System.getProperty("line.separator");
    public static final String EMAIL_ADDRESS_VALIDATION_PATTERN = "^(?=.{1,64}@)[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*@[^-][A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
    private static Logger log = LogManager.getLogger(StringUtil.class);
    private static Map<String, int[][]> substringFormatCache = new HashMap<String, int[][]>();
    static final Pattern patternNumberUnsigned = Pattern.compile("\\d+");
    static final Pattern patternNumberUnsignedDecimal = Pattern.compile("\\d+(\\.\\d+)?");
    static final Pattern patternNumberSigned = Pattern.compile("-?\\d+");
    static final Pattern patternNumberSignedDecimal = Pattern.compile("-?\\d+(\\.\\d+)?");

    public static String deleteChars(String chars, String str) {
        StringBuilder newStr = new StringBuilder();
        StringTokenizer strTok = new StringTokenizer(str, chars);
        while (strTok.hasMoreTokens()) {
            newStr.append(strTok.nextToken());
        }
        return newStr.toString();
    }

    public static String deleteLastChars(String str, int quantity) {
        if (!StringUtil.isEmpty(str)) {
            return str.substring(0, str.length() - quantity);
        }
        return str;
    }

    public static String trimLeading(String s, char fillerChar) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("^" + fillerChar + LIST_ANY, "");
    }

    public static String trimTrailing(String s, char fillerChar) {
        if (s == null) {
            return "";
        }
        return s.replaceAll(fillerChar + "*$", "");
    }

    public static String trimAll(String s) {
        return StringUtil.trimAll(s, ' ');
    }

    public static String trimAll(String s, char fillerChar) {
        String result = StringUtil.trimLeading(s, fillerChar);
        result = StringUtil.trimTrailing(result, fillerChar);
        return result;
    }

    public static String trimLeadingSpacesAndZeroes(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("^[ 0]*", "");
    }

    public static String trimLastNZeroes(String s, int n) {
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        return s.replaceAll("^(.*)(0{" + n + "})$", "$1");
    }

    public static String padd(String sourceString, int paddedStringLenght, char fillerChar, String paddingType) {
        return StringUtil.padd(sourceString, paddedStringLenght, fillerChar, paddingType, null);
    }

    public static String padd(String sourceString, int paddedStringLenght, char fillerChar, String paddingType, Integer position) {
        if (sourceString == null) {
            sourceString = "";
        }
        if (sourceString.length() >= paddedStringLenght) {
            if (PADD_LEFT.equals(paddingType)) {
                return sourceString.substring(sourceString.length() - paddedStringLenght);
            }
            return sourceString.substring(0, paddedStringLenght);
        }
        int paddingLenght = paddedStringLenght - sourceString.length();
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(fillerChar).repeat(Math.max(0, paddingLenght)));
        if (PADD_LEFT.equals(paddingType)) {
            buffer.append(sourceString);
            return buffer.toString();
        }
        if (PADD_RIGHT.equals(paddingType)) {
            buffer.insert(0, sourceString);
            return buffer.toString();
        }
        if (FILL_AT.equals(paddingType) && position != null) {
            buffer.insert(0, sourceString.substring(0, position));
            buffer.append(sourceString.substring(position));
            return buffer.toString();
        }
        return sourceString;
    }

    public static String spaces(int n) {
        return StringUtil.padd("", n, ' ', PADD_LEFT);
    }

    public static String padSpc(String value, int paddedStringLenght) {
        return StringUtil.padd(value, paddedStringLenght, ' ', PADD_RIGHT);
    }

    public static String padSpc(String value, int paddedStringLenght, String padd) {
        return StringUtil.padd(value, paddedStringLenght, ' ', padd);
    }

    public static String padNum(String value, int paddedStringLenght) {
        if (value == null) {
            value = "";
        }
        value = ((String)value).indexOf(45) == 0 ? "-" + StringUtil.padd(((String)value).substring(1), paddedStringLenght - 1, '0', PADD_LEFT) : StringUtil.padd((String)value, paddedStringLenght, '0', PADD_LEFT);
        return value;
    }

    public static String padNum(int value, int paddedStringLenght) {
        return StringUtil.padNum("" + value, paddedStringLenght);
    }

    public static String padNumToEven(String value) {
        if (value.length() % 2 != 0) {
            value = StringUtil.padNum(value, value.length() + 1);
        }
        return value;
    }

    public static String padNumToOdd(String value) {
        if (value.length() % 2 == 0) {
            value = StringUtil.padNum(value, value.length() + 1);
        }
        return value;
    }

    public static String padCustomLeft(String value, int paddedStringLenght, char paddObj) {
        return StringUtil.padd(value, paddedStringLenght, paddObj, PADD_LEFT);
    }

    public static String padCustomRight(String value, int paddedStringLenght, char paddObj) {
        return StringUtil.padd(value, paddedStringLenght, paddObj, PADD_RIGHT);
    }

    public static Collection<String> parseString(String str, String delimiters) {
        ArrayList<String> tokens = null;
        if (str != null) {
            tokens = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            if (tokens.isEmpty()) {
                tokens = null;
            }
        }
        return tokens;
    }

    public static Collection<Long> parseStringAsLong(String str, String delimiters) {
        ArrayList<Long> result = null;
        Collection<String> strings = StringUtil.parseString(str, delimiters);
        if (!CollectionUtils.isEmpty(strings)) {
            result = new ArrayList<Long>();
            for (String string : strings) {
                result.add(Long.valueOf(string.trim()));
            }
        }
        return result;
    }

    public static List<String> listValues(String text) {
        return StringUtil.listValues(text, '|');
    }

    public static Set<String> listValuesAsSet(String text) {
        return StringUtil.listValuesAsSet(text, '|');
    }

    public static Set<String> listValuesAsSet(String text, char separator) {
        HashSet<String> result = new HashSet<String>(StringUtil.listValues(text, separator));
        return result;
    }

    public static List<String> listValues(String text, char separator) {
        ArrayList<String> listValues = new ArrayList<String>();
        if (text == null) {
            return listValues;
        }
        String[] values = StringUtil.split(text, separator);
        listValues.addAll(Arrays.asList(values));
        return listValues;
    }

    public static String compactValues(Collection<String> values, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (!CollectionUtils.isEmpty(values)) {
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    result.append(separator);
                }
                result.append(value);
            }
        }
        return result.toString();
    }

    public static String compactValuesQuote(Collection<String> values, String separator, String begQuote, String endQuote) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (!CollectionUtils.isEmpty(values)) {
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    result.append(separator);
                }
                result.append(begQuote);
                result.append(value);
                result.append(endQuote);
            }
        }
        return result.toString();
    }

    public static String getProperyFromPipes(String pipedPropertyText, String key) {
        List<String> listValues = StringUtil.listValues(pipedPropertyText, '|');
        for (String keyPair : listValues) {
            if (!keyPair.startsWith(key)) continue;
            return keyPair.substring(keyPair.indexOf("[") + 1, keyPair.indexOf("]"));
        }
        return "";
    }

    public static Map<String, Object> getJsonMapFromJson(String jsonString) {
        if (StringUtil.isEmpty(jsonString)) {
            return null;
        }
        JsonSlurper slurper = new JsonSlurper();
        return (Map)slurper.parseText(jsonString);
    }

    public static List<Map<String, Object>> getJsonListFromJson(String jsonString) {
        if (StringUtil.isEmpty(jsonString)) {
            return null;
        }
        JsonSlurper slurper = new JsonSlurper();
        return (List)slurper.parseText(jsonString);
    }

    public static String getPropertyFromJson(String jsonText, String ... keys) {
        return StringUtil.getStringPropertyFromJsonMap(StringUtil.getJsonMapFromJson(jsonText), keys);
    }

    public static Long getLongPropertyFromJson(String jsonText, String ... keys) {
        return StringUtil.getPropertyFromJsonMap(Long.class, StringUtil.getJsonMapFromJson(jsonText), keys);
    }

    public static Integer getIntegerPropertyFromJson(String jsonText, String ... keys) {
        return StringUtil.getPropertyFromJsonMap(Integer.class, StringUtil.getJsonMapFromJson(jsonText), keys);
    }

    public static String getStringPropertyFromJsonMap(Map<String, Object> jsonSlurperMap, String ... keys) {
        return StringUtil.getPropertyFromJsonMap(String.class, jsonSlurperMap, keys);
    }

    public static <T> T getPropertyFromJsonMap(Class<T> returnType, Map<String, Object> jsonSlurperMap, String ... keys) {
        if (jsonSlurperMap == null) {
            return (T)(returnType.equals(String.class) ? "" : null);
        }
        Iterator keysIt = Arrays.stream(keys).iterator();
        while (keysIt.hasNext()) {
            Object result;
            String key = (String)keysIt.next();
            int arrayPos = 0;
            boolean isValueAnArray = false;
            if (key.contains("[")) {
                int openPos = key.indexOf("[");
                int closePos = key.indexOf("]");
                arrayPos = Integer.parseInt(key.substring(openPos + 1, closePos));
                isValueAnArray = true;
                key = key.substring(0, openPos);
            }
            if ((result = jsonSlurperMap.get(key)) == null) {
                return (T)(returnType.equals(String.class) ? "" : null);
            }
            if (isValueAnArray && result instanceof ArrayList) {
                result = ((ArrayList)result).get(arrayPos);
            }
            if (keysIt.hasNext() && result instanceof Map) {
                jsonSlurperMap = (Map)result;
                continue;
            }
            if (returnType.equals(String.class) && result instanceof Number) {
                return (T)result.toString();
            }
            if (returnType.equals(Double.class) && result instanceof String) {
                try {
                    return (T)Double.valueOf((String)result);
                }
                catch (NumberFormatException e) {
                    return (T)(returnType.equals(String.class) ? "" : null);
                }
            }
            if (returnType.equals(Long.class) && result instanceof String) {
                try {
                    return (T)Long.valueOf((String)result);
                }
                catch (NumberFormatException e) {
                    return (T)(returnType.equals(String.class) ? "" : null);
                }
            }
            return (T)result;
        }
        return (T)(returnType.equals(String.class) ? "" : null);
    }

    public static ArrayList<LazyMap> getArrayPropertyFromJsonMap(Map<String, Object> jsonSlurperMap, String ... keys) {
        if (jsonSlurperMap == null) {
            return null;
        }
        ArrayList keysConcat = new ArrayList();
        Iterator keysIterator = Arrays.stream(keys).iterator();
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            Object result = jsonSlurperMap.get(key);
            if (result == null) {
                log.debug("No se encotro la el value para la property json [" + String.join((CharSequence)".", keysConcat) + "]");
                return null;
            }
            if (result instanceof LazyMap) {
                jsonSlurperMap = (LazyMap)result;
                continue;
            }
            if (result instanceof ArrayList && !keysIterator.hasNext()) {
                return (ArrayList)result;
            }
            return null;
        }
        return null;
    }

    public static String getProperySufixed(Map<String, String> properties, String key, String ... tags) {
        String value = properties.get(key);
        Object tagList = "";
        for (String tag : tags) {
            String moreSpecificValue = properties.get(key + (String)(tagList = (String)tagList + "." + tag));
            if (StringUtil.isEmpty(moreSpecificValue)) continue;
            value = moreSpecificValue;
        }
        return value;
    }

    public static List<String> listValuesNotEmpty(String text) {
        return StringUtil.listValuesNotEmpty(text, '|');
    }

    public static <T> List<T> listValuesNotEmptyMapping(String text, Function<String, T> function) {
        return StringUtil.listValuesNotEmptyMapping(text, '|', function);
    }

    public static String listValuesNotEmpty(String text, int i) {
        List<String> values = StringUtil.listValuesNotEmpty(text, '|');
        if (values.size() <= i) {
            return null;
        }
        return values.get(i);
    }

    public static List<String> listValuesNotEmpty(String text, char separator) {
        return StringUtil.listValues(text, separator).stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
    }

    public static <T> List<T> listValuesNotEmptyMapping(String text, char separator, Function<String, T> function) {
        return StringUtil.listValues(text, separator).stream().filter(StringUtil::isNotEmpty).map(function).collect(Collectors.toList());
    }

    public static List<Long> listValuesAsLong(String str) {
        return StringUtil.listValuesAsLong(str, LIST_SEPARATOR);
    }

    public static List<Long> listValuesAsLong(String str, String delimiters) {
        ArrayList<Long> result = null;
        Collection<String> strings = StringUtil.parseString(str, delimiters);
        if (strings != null) {
            result = new ArrayList<Long>();
            for (String s : strings) {
                if (StringUtil.isEmpty(s)) continue;
                result.add(Long.valueOf(s.trim()));
            }
        }
        return result;
    }

    public static List<Long> listValuesAsLongNotEmpty(String str) {
        return StringUtil.listValuesAsLongNotEmpty(str, LIST_SEPARATOR);
    }

    public static List<Long> listValuesAsLongNotEmpty(String str, String delimiters) {
        ArrayList listValues = StringUtil.listValuesAsLong(str, delimiters);
        return listValues == null ? new ArrayList() : listValues;
    }

    public static int fromToCountLenght(String substringFormat) {
        String[] ranges = substringFormat.split(",");
        int count = 0;
        for (String s : ranges) {
            String[] range = s.split(":");
            int from = Integer.parseInt(range[0]);
            int to = Integer.parseInt(range[1]);
            count += Math.abs(to - from);
        }
        return count;
    }

    public static boolean isListAny(String listItems) {
        return listItems != null && (listItems.equals(LIST_ANY) || listItems.contains(LIST_ANY_SEP));
    }

    public static boolean isListNone(String listItems) {
        if (StringUtil.isEmpty(listItems)) {
            return true;
        }
        if (listItems.equals(LIST_NONE)) {
            return true;
        }
        return listItems.equals(LIST_NONE_SEP);
    }

    public static String getListFilterByRoles(String options, String roles) {
        if (StringUtil.isEmpty(options)) {
            return options;
        }
        Object result = "";
        String sep = "";
        List<String> lvs = StringUtil.listValues(options, '|');
        block0: for (String value : lvs) {
            if (StringUtil.isEmpty(value)) continue;
            List<String> optionsRoles = StringUtil.listValues(value, '@');
            String option = optionsRoles.get(0);
            if (optionsRoles.size() == 1) {
                result = (String)result + option + "|";
                continue;
            }
            for (int i = 1; i < optionsRoles.size(); ++i) {
                if (!StringUtil.isInList(roles, optionsRoles.get(i))) continue;
                result = (String)result + option + "|";
                continue block0;
            }
        }
        return result;
    }

    public static String calcIntersection(String grupoUno, String grupoDos) {
        Object result = "";
        boolean grupoUnoAny = false;
        boolean grupoDosAny = false;
        if (grupoUno == null || grupoDos == null) {
            return null;
        }
        if (StringUtil.isListAny(grupoUno)) {
            grupoUnoAny = true;
        }
        if (StringUtil.isListAny(grupoDos)) {
            grupoDosAny = true;
        }
        if (grupoUnoAny && grupoDosAny) {
            result = "";
        } else if (grupoUnoAny && !grupoDosAny) {
            result = grupoDos;
        } else if (!grupoUnoAny && grupoDosAny) {
            result = grupoUno;
        } else if (!grupoUnoAny && !grupoDosAny) {
            if (grupoUno.equals(grupoDos)) {
                result = grupoUno;
            } else {
                StringTokenizer stGrupoUno = new StringTokenizer(grupoUno, "|", false);
                while (stGrupoUno.hasMoreTokens()) {
                    String tokenGrupoUno = stGrupoUno.nextToken();
                    StringTokenizer stGrupoDos = new StringTokenizer(grupoDos, "|", false);
                    boolean encontrado = false;
                    while (stGrupoDos.hasMoreTokens() && !encontrado) {
                        String tokenGrupoDos = stGrupoDos.nextToken();
                        if (!tokenGrupoUno.equals(tokenGrupoDos)) continue;
                        result = (String)result + tokenGrupoUno + "|";
                        encontrado = true;
                    }
                }
                if (result != null && !((String)result).isEmpty()) {
                    result = "|" + (String)result;
                }
                if (result == null || ((String)result).isEmpty()) {
                    result = null;
                }
            }
        }
        return result;
    }

    public static boolean hasIntersection(String grupoUno, String grupoDos) {
        String intersection = StringUtil.calcIntersection(grupoUno, grupoDos);
        return intersection != null;
    }

    public static boolean isInList(String listItems, String item) {
        return StringUtil.isInList(listItems, item, false);
    }

    public static boolean isNotInList(String listItems, String item) {
        return !StringUtil.isInList(listItems, item);
    }

    public static String addToList(String listItems, String item) {
        if (!StringUtil.isInList((String)(listItems = StringUtil.nonNull((String)listItems)), item)) {
            listItems = (String)listItems + LIST_SEPARATOR + item;
        }
        return listItems;
    }

    public static String removeFromList(String listItems, String item) {
        if (StringUtil.isInList(listItems = StringUtil.nonNull(listItems), item)) {
            listItems = StringUtil.replace(listItems, item, "");
            if ((listItems = StringUtil.replace(listItems, LIST_SEPARATOR + LIST_SEPARATOR, LIST_SEPARATOR)).equals(LIST_SEPARATOR)) {
                listItems = "";
            }
        }
        return listItems;
    }

    public static boolean isInList(String listItems, String item, boolean allowPrefix) {
        boolean isInItems = false;
        if (listItems != null && item != null) {
            if (StringUtil.isListAny(listItems)) {
                isInItems = true;
            } else if (!listItems.contains(LIST_SEPARATOR)) {
                isInItems = allowPrefix ? item.startsWith(listItems) : item.equals(listItems);
            } else {
                StringTokenizer stDocTypes = new StringTokenizer(listItems, LIST_SEPARATOR, false);
                while (stDocTypes.hasMoreTokens() && !isInItems) {
                    String token = stDocTypes.nextToken();
                    isInItems = allowPrefix ? item.startsWith(token) : item.equals(token);
                }
            }
        }
        return isInItems;
    }

    public static String replaceChars(String text, char[] ori, char[] rep) {
        return StringUtil.replaceChars(text, ori, rep, null);
    }

    public static String replaceChars(String text, char[] ori, char[] rep, Charset encoding) {
        if (encoding != null) {
            text = new String(text.getBytes(), encoding);
        }
        for (int i = 0; i < ori.length; ++i) {
            if (text.indexOf(ori[i]) < 0) continue;
            text = text.replace(ori[i], rep[i]);
        }
        return text;
    }

    public static String replace(String original, String search, String replace) {
        if (StringUtil.isEmpty((String)original)) {
            return original;
        }
        int len = search.length();
        int replaceLen = replace.length();
        int position = ((String)original).indexOf(search);
        while (position >= 0) {
            original = ((String)original).substring(0, position) + replace + ((String)original).substring(position + len);
            position = ((String)original).indexOf(search, position + replaceLen);
        }
        return original;
    }

    public static char[] replaceCharsParser(String cadena, char sep) {
        String[] tokens = cadena.split("[" + sep + "]");
        char[] result = new char[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = tokens[i] != null && !"".equals(tokens[i]) ? tokens[i].charAt(0) : (char)32;
        }
        return result;
    }

    public static String sanitizeASCII(String cadena) {
        return StringUtil.sanitizeASCII(cadena, true);
    }

    public static String sanitizeASCII(String cadena, boolean encodeStringBeforeReplaceChars) {
        if (cadena == null) {
            return "";
        }
        char[] charsToBeReplaced = new char[]{'\u00e1', '\u00e9', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00c1', '\u00c9', '\u00cd', '\u00d3', '\u00da', '\u00d1', '\u00bf', '\u00ba', '\u00c3', '\u00f1', '\u00d1', '\u00e1', '\u00e9', '\u00ed', '\u00f3', '\u00fa', '\u00c1', '\u00c9', '\u00cd', '\u00d3', '\u00da', '\u00fc', '\u00dc', '\u00e7', '\u00c7', '\u00b0', '\u00ba', '\u00aa', '\u00bf', '\u00a6', '\u00e0', '\u00e8', '\u00ec', '\u00f2', '\u00f9', '\u00a3', '\u00a7', '\u00ef', '\u00a5', '\u00ff', '\u00d6', '\u00b2', '\u00c3', '\u00a0'};
        char[] replacementChars = new char[]{'a', 'e', 'i', 'o', 'u', 'n', 'A', 'E', 'I', 'O', 'U', 'N', '?', 'o', 'A', 'n', 'N', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', 'u', 'U', 'c', 'C', 'o', 'o', 'a', '?', ':', 'a', 'e', 'i', 'o', 'u', '$', '$', 'i', '$', 'y', 'O', '2', 'A', ' '};
        String res = encodeStringBeforeReplaceChars ? StringUtil.replaceChars(cadena, charsToBeReplaced, replacementChars, StandardCharsets.UTF_8) : StringUtil.replaceChars(cadena, charsToBeReplaced, replacementChars);
        return res.replaceAll("[^\\x20-\\x7E]", "_");
    }

    public static String fromToParser(String value, String substringFormat) {
        return StringUtil.fromToParser(value, substringFormat, null);
    }

    private static int[][] parseSubstringFormat(String substringFormat, int len, boolean padded) {
        int[][] result;
        StringBuilder keyBuild = new StringBuilder(padded ? "P" : "R").append(len).append('/').append(substringFormat);
        String key = keyBuild.toString();
        if (substringFormatCache.containsKey(key)) {
            result = substringFormatCache.get(key);
        } else {
            String[] ranges = substringFormat.split("[,;]");
            result = new int[ranges.length][2];
            for (int i = 0; i < ranges.length; ++i) {
                String[] range = ranges[i].split(":");
                int from = Integer.parseInt(range[0]);
                int to = Integer.parseInt(range[1].replace("+", ""));
                if (from < 0) {
                    from = len + from;
                }
                if (from < 0) {
                    from = 0;
                }
                if (from >= len && !padded) {
                    result = null;
                }
                if (to < 0) {
                    to = len + to;
                }
                if (to < 0) {
                    to = 0;
                }
                if (to == 0) {
                    to = len;
                }
                if (range[1].startsWith("+")) {
                    to = from + to;
                }
                if (to > len && !padded) {
                    result = null;
                }
                if (result == null) continue;
                result[i][0] = from;
                result[i][1] = to;
            }
            substringFormatCache.put(key, result);
        }
        return result;
    }

    public static String fromToParser(String value, String substringFormat, String pad) {
        if (value == null) {
            return null;
        }
        int[][] spec = StringUtil.parseSubstringFormat(substringFormat, value.length(), pad != null);
        if (spec == null) {
            return null;
        }
        if ("".equals(pad)) {
            throw new IllegalArgumentException("El Padding no puede ser vacio");
        }
        if (spec.length == 1 && value.length() >= spec[0][1]) {
            return value.substring(spec[0][0], spec[0][1]);
        }
        StringBuilder valorAEscribir = new StringBuilder();
        for (int i = 0; i < spec.length; ++i) {
            int from = spec[i][0];
            int to = spec[i][1];
            if (value.length() >= to) {
                valorAEscribir.append(value, from, to);
                continue;
            }
            if (from > value.length()) {
                valorAEscribir.append(String.valueOf(pad).repeat(Math.max(0, to - from)));
                continue;
            }
            valorAEscribir.append(value.substring(from));
            valorAEscribir.append(String.valueOf(pad).repeat(to - value.length()));
        }
        return valorAEscribir.toString();
    }

    public static String stringPermutation(String source) {
        Random random = new Random();
        StringBuilder temp = new StringBuilder(source);
        StringBuilder target = new StringBuilder();
        int index = 0;
        while (temp.length() > 0) {
            index = random.nextInt(Integer.MAX_VALUE) % temp.length();
            target.append(temp.charAt(index));
            temp.deleteCharAt(index);
        }
        return target.toString();
    }

    public static final boolean isEmpty(String st) {
        return st == null || st.isEmpty();
    }

    public static final boolean isEmpty(StringBuilder st) {
        return st == null || st.length() == 0;
    }

    public static final boolean isEmptyNull(String st) {
        return st == null || st.isEmpty() || st.trim().equalsIgnoreCase("null");
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    public static boolean isNotEmptyNull(String value) {
        return !StringUtil.isEmptyNull(value);
    }

    public static boolean isNotEmpty(StringBuilder st) {
        return !StringUtil.isEmpty(st);
    }

    public static boolean emptySafeEquals(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return StringUtil.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean emptySafeContains(String s1, String s2) {
        if (StringUtil.isEmpty(s1) || StringUtil.isEmpty(s2)) {
            return false;
        }
        return s1.contains(s2);
    }

    public static boolean emptySafeStartsWith(String s1, String s2) {
        if (StringUtil.isEmpty(s1) || StringUtil.isEmpty(s2)) {
            return false;
        }
        return s1.startsWith(s2);
    }

    public static boolean isTrue(String st) {
        if (st == null) {
            return false;
        }
        return (st = st.trim().toLowerCase()).equals("true") || st.equals("1") || st.equals("yes");
    }

    public static final boolean emptySafeEqualsIgnoreCase(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return StringUtil.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static final int emptySafeIndexOfIgnoreCase(String s1, String s2) {
        if (StringUtil.isEmpty(s1) || StringUtil.isEmpty(s2)) {
            return -1;
        }
        return s1.toLowerCase().indexOf(s2.toLowerCase());
    }

    public static final int safeCompareTo(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return 1;
        }
        if (StringUtil.isEmpty(s2)) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public static boolean emptySafeLenght(String s, int len) {
        return s != null && s.length() == len;
    }

    public static final StringBuilder safeAppend(StringBuilder appendTo, String appendElement) {
        return StringUtil.safeAppend(appendTo, appendElement, null);
    }

    public static final StringBuilder safeAppend(StringBuilder appendTo, String appendElement, String separator) {
        if (StringUtil.isEmpty(appendElement)) {
            return appendTo;
        }
        if (appendTo == null) {
            appendTo = new StringBuilder();
        } else if (!StringUtil.isEmpty(separator)) {
            appendTo.append(separator);
        }
        appendTo.append(appendElement);
        return appendTo;
    }

    public static String safeAppend(String appendTo, String appendElement, String separator) {
        if (StringUtil.isEmpty(appendTo)) {
            return appendElement;
        }
        if (StringUtil.isEmpty(appendElement)) {
            return appendTo;
        }
        StringBuilder returnValue = StringUtil.safeAppend(new StringBuilder(appendTo), appendElement, separator);
        if (returnValue != null) {
            return returnValue.toString();
        }
        return null;
    }

    public static String safeAppendNoRepeat(String appendTo, String appendElement, String separator) {
        if (StringUtil.isEmpty(appendTo)) {
            return appendElement;
        }
        if (StringUtil.isEmpty(appendElement)) {
            return appendTo;
        }
        boolean yaAgregado = appendTo.contains(appendElement);
        return yaAgregado ? appendTo : StringUtil.safeAppend(appendTo, appendElement, separator);
    }

    public static int calcEditDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = StringUtil.Minimo(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int Minimo(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public static String[] regexSplit(String srcString, String regexSplitExpression) {
        if (StringUtil.isNotEmpty(regexSplitExpression)) {
            return srcString.split(regexSplitExpression);
        }
        return new String[]{srcString};
    }

    public static String[] split(String value, char separator) {
        return StringUtil.split(value, separator, 0, false);
    }

    public static String[] splitNotEmpty(String value, char separator) {
        return StringUtil.split(value, separator, 0, true);
    }

    public static String[] split(String value, char separator, int sizeMinimo) {
        return StringUtil.split(value, separator, sizeMinimo, false);
    }

    public static String split0(String value, char separator) {
        if (value == null) {
            return null;
        }
        int pos = value.indexOf(separator);
        if (pos > 0) {
            return value.substring(0, pos);
        }
        return value;
    }

    public static String[] split(String value, char separator, int sizeMinimo, boolean removeEmpty) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (value == null) {
            if (sizeMinimo == 0) {
                return null;
            }
        } else {
            int valueLen = value.length();
            char[] valueArray = new char[valueLen + 1];
            value.getChars(0, valueLen, valueArray, 0);
            valueArray[valueLen] = separator;
            int n = valueArray.length;
            int lastSep = -1;
            boolean anyEscapeChar = false;
            for (int i = 0; i < n; ++i) {
                if (valueArray[i] != separator) continue;
                if (i > 0 && valueArray[i - 1] == '\\') {
                    anyEscapeChar = true;
                    continue;
                }
                String part = new String(valueArray, lastSep + 1, i - (lastSep + 1));
                if (!removeEmpty || !StringUtil.isEmptyNull(part)) {
                    if (anyEscapeChar) {
                        part = StringUtil.replace(part, "\\" + separator, "" + separator);
                        anyEscapeChar = false;
                    }
                    resultList.add(part);
                }
                lastSep = i;
            }
        }
        for (int f = resultList.size(); f < sizeMinimo; ++f) {
            resultList.add("");
        }
        String[] result = new String[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public static String plural(long value, String singular) {
        boolean terminaEnVocal;
        if (singular == null || singular.length() < 0) {
            return singular;
        }
        char ultimaLetra = singular.charAt(singular.length() - 1);
        boolean bl = terminaEnVocal = "aeiouAEIOU".indexOf(ultimaLetra) >= 0;
        String sufijo = value == 1L ? "" : (terminaEnVocal ? "s" : LANG_ES);
        return singular + (Character.isUpperCase(ultimaLetra) ? sufijo.toUpperCase() : sufijo);
    }

    public static String cardinal(long value, String singular) {
        return value + PAD_SPC + StringUtil.plural(value, singular);
    }

    public static void appendToHTMLStringBuilder(char character, StringBuilder buf) {
        if (character <= '\u001f' || character >= '\u007f') {
            buf.append("&#");
            buf.append((int)character);
            buf.append(';');
        } else {
            buf.append(character);
        }
    }

    public static String nonNull(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("null")) {
            return "";
        }
        return string;
    }

    public static String nonNull(Object obj) {
        if (obj == null) {
            return "";
        }
        return StringUtil.nonNull(obj.toString());
    }

    public static String nonEmpty(String string, String defaultValue) {
        if (StringUtil.isEmpty(string)) {
            return defaultValue;
        }
        return string;
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }

    public static String emptyToNull(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        return string;
    }

    public static String encodeToHTML(char character) {
        StringBuilder ret = new StringBuilder(6);
        StringUtil.appendToHTMLStringBuilder(character, ret);
        return ret.toString();
    }

    public static String encodeToHTML(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(string.length() * 4);
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            StringUtil.appendToHTMLStringBuilder(c, ret);
        }
        return ret.toString();
    }

    public static String[] internetAddressParse(String addresses, boolean force) {
        String[] retorno = null;
        try {
            InternetAddress[] ia = InternetAddress.parse((String)addresses, (boolean)force);
            retorno = new String[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                InternetAddress internetAddress = ia[i];
                retorno[i] = internetAddress.getAddress();
            }
        }
        catch (AddressException e) {
            log.error("Ha ocurrido un error", (Throwable)e);
        }
        return retorno;
    }

    public static boolean validateRepeatNumber(String text, int admitRepeat) {
        boolean returnValue = true;
        int cont = 0;
        int number = 0;
        for (int i = 0; i < text.length() && returnValue; ++i) {
            Character character = Character.valueOf(text.charAt(i));
            if (!Character.isDigit(character.charValue())) continue;
            try {
                number = Character.getNumericValue(character.charValue());
                for (int j = i + 1; j <= i + admitRepeat; ++j) {
                    if (i + admitRepeat >= text.length()) continue;
                    Character characterCompare = Character.valueOf(text.charAt(j));
                    try {
                        if (!Character.isDigit(characterCompare.charValue()) || number != Character.getNumericValue(characterCompare.charValue())) continue;
                        ++cont;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error1: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (cont >= admitRepeat) {
                    returnValue = false;
                }
                cont = 0;
                continue;
            }
            catch (Exception e) {
                log.error("Error2: " + e.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public static boolean validateRepeatCharacters(String text, int admitRepeat) {
        int cont = 0;
        boolean returnValue = true;
        for (int i = 0; i < text.length() && returnValue; ++i) {
            String character = text.substring(i, i + 1);
            if (!VALID_LOWERS.contains(character) && !VALID_UPPERS.contains(character)) continue;
            for (int j = i + 1; j <= i + admitRepeat; ++j) {
                String characterCompare;
                if (i + admitRepeat >= text.length() || !character.equals(characterCompare = text.substring(j, j + 1))) continue;
                ++cont;
            }
            if (cont >= admitRepeat) {
                returnValue = false;
            }
            cont = 0;
        }
        return returnValue;
    }

    public static String extractPipes(String value) {
        String val = null;
        if (value != null) {
            val = StringUtil.replace(value, "|", "");
        }
        return val;
    }

    public static String extractPipesAtInitAndEnd(String value) {
        if (StringUtil.isEmptyNull(value)) {
            return null;
        }
        if (value.charAt(0) == '|') {
            value = value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '|') {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static Collection<String> asArrayList(String ... items) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(items));
        return result;
    }

    public static String asList(Collection<String> items) {
        return StringUtil.asList(items, '|');
    }

    public static String asList(Collection<String> items, char separator) {
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            result.append(item).append(separator);
        }
        return result.toString();
    }

    public static String asList(String ... items) {
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            result.append(item).append('|');
        }
        return result.toString();
    }

    public static String toDebugString(Collection<?> items) {
        if (items == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        String sep = "";
        for (Object item : items) {
            result.append(sep).append(item);
            sep = ",";
            if (++i < 10) continue;
            result.append("...total:").append(items.size());
            break;
        }
        result.append("]");
        return result.toString();
    }

    public static List<Tuple<String, Map<String, String>>> getPipedStringsWithProperties(String pipedStrings) {
        ArrayList<Tuple<String, Map<String, String>>> result = new ArrayList<Tuple<String, Map<String, String>>>();
        if (pipedStrings != null) {
            for (String encodedStringProps : pipedStrings.split("[|]")) {
                result.add(StringUtil.getStringWithProperties(encodedStringProps));
            }
        }
        return result;
    }

    public static Tuple<String, Map<String, String>> getStringWithProperties(String stringWithProperties) {
        String string;
        if (stringWithProperties == null) {
            return null;
        }
        HashMap<String, String> props = null;
        int posicionSeparador = stringWithProperties.indexOf(":");
        if (posicionSeparador > -1) {
            string = stringWithProperties.substring(0, posicionSeparador);
            String encodedProps = stringWithProperties.substring(posicionSeparador + 1);
            props = new HashMap<String, String>();
            for (String prop : encodedProps.split(";")) {
                int equalsPos = prop.indexOf(61);
                if (equalsPos == -1) {
                    log.error("Propiedad mal formada en string [" + string + "]. Falta el '='. La cadena completa pasada al metodo [" + stringWithProperties + "]");
                    continue;
                }
                String key = prop.substring(0, equalsPos).trim();
                String value = prop.substring(equalsPos + 1);
                props.put(key, value);
            }
        } else {
            string = stringWithProperties;
        }
        return new Tuple<String, Object>(string, props);
    }

    public static Map<String, Map<String, String>> getPipedStringsWithPropertiesToMap(String pipedStrings) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        List<Tuple<String, Map<String, String>>> tuples = StringUtil.getPipedStringsWithProperties(pipedStrings);
        if (!CollectionUtils.isEmpty(tuples)) {
            for (Tuple<String, Map<String, String>> tuple : tuples) {
                result.put(tuple.getFirst(), tuple.getSecond());
            }
        }
        return result;
    }

    public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression) {
        return StringUtil.splitToMapUsingRegex(srcString, regexSplitExpression, '=', null);
    }

    public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression, Map<String, String> targetMap) {
        return StringUtil.splitToMapUsingRegex(srcString, regexSplitExpression, '=', targetMap);
    }

    public static Map<String, String> splitToMapUsingRegex(String srcString, String regexSplitExpression, char keyValueSeparator, Map<String, String> targetMap) {
        return StringUtil.arrayToMap(StringUtil.regexSplit(srcString, regexSplitExpression), keyValueSeparator, targetMap);
    }

    public static Map<String, String> arrayToMap(String[] srcArray) {
        return StringUtil.arrayToMap(srcArray, '=', null);
    }

    public static Map<String, String> arrayToMap(String[] srcArray, Map<String, String> targetMap) {
        return StringUtil.arrayToMap(srcArray, '=', targetMap);
    }

    public static Map<String, String> arrayToMap(String[] srcArray, char keyValueSeparator, Map<String, String> targetMap) {
        if (targetMap == null) {
            targetMap = new HashMap<String, String>();
        }
        if (ArrayUtils.isNotEmpty((Object[])srcArray)) {
            for (String src : srcArray) {
                if (!src.contains(String.valueOf(keyValueSeparator))) continue;
                Pair<String, String> keyValue = StringUtil.toKeyValue(src, keyValueSeparator);
                targetMap.put((String)keyValue.getKey(), (String)keyValue.getValue());
            }
        }
        return targetMap;
    }

    public static Map<String, String> splitToMapSameOrder(String value, char separator) {
        return StringUtil.splitToMap(value, separator, new LinkedHashMap<String, String>());
    }

    public static Map<String, String> splitToMap(String value, char separator) {
        return StringUtil.splitToMap(value, separator, null);
    }

    private static Map<String, String> splitToMap(String value, char separator, Map<String, String> mapImplementation) {
        return StringUtil.arrayToMap(StringUtil.split(value, separator), mapImplementation);
    }

    public static String joinFromMap(Map<String, String> map) {
        return StringUtil.joinFromMap(map, '|');
    }

    public static String joinFromMap(Map<String, String> map, char separator) {
        if (map != null) {
            return map.keySet().stream().map(key -> key + "=" + (String)map.get(key)).collect(Collectors.joining(String.valueOf(separator)));
        }
        return null;
    }

    public static String updateKeyValueStringMap(String keyValueMap, String key, String value) {
        if (keyValueMap == null && key == null) {
            return null;
        }
        if (keyValueMap == null) {
            keyValueMap = "";
        }
        Map<String, String> map = StringUtil.splitToMapSameOrder(keyValueMap, '|');
        if (value != null) {
            map.put(key, value);
        } else {
            map.remove(key);
        }
        return StringUtil.joinFromMap(map);
    }

    public static String getValueFromKeyValueStringMap(String keyValueMap, String key) {
        if (keyValueMap == null || key == null) {
            return keyValueMap;
        }
        Map<String, String> map = StringUtil.splitToMapSameOrder(keyValueMap, '|');
        return map.get(key);
    }

    public static Pair<String, String> toKeyValue(String keyValue) {
        return StringUtil.toKeyValue(keyValue, '=');
    }

    public static Pair<String, String> toKeyValue(String keyValue, char sep) {
        int pos;
        if (keyValue != null && (pos = keyValue.indexOf(sep)) > 0) {
            return new ImmutablePair((Object)keyValue.substring(0, pos), (Object)keyValue.substring(pos + 1));
        }
        return null;
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        if (!StringUtil.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String generateLikeFromMask(String value, String mask) {
        if (StringUtil.isEmpty(value) || StringUtil.isEmpty(mask)) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        int posValue = 0;
        block5: for (char maskChar : mask.toCharArray()) {
            switch (maskChar) {
                case '%': {
                    result.append(maskChar);
                    continue block5;
                }
                case '_': {
                    result.append(maskChar);
                    ++posValue;
                    continue block5;
                }
                case '.': {
                    if (posValue >= value.length()) {
                        throw new IllegalArgumentException("La mascara [" + mask + "] es mas larga que el value [" + value + "] (sin contar los %)");
                    }
                    result.append(value.charAt(posValue));
                    ++posValue;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Caracter [" + maskChar + "] no reconocido en la mascara [" + mask + "] para el value [" + value + "]");
                }
            }
        }
        return result.toString();
    }

    public static String nvl(String ... datos) {
        for (String dato : datos) {
            if (StringUtil.isEmpty(dato)) continue;
            return dato;
        }
        return "";
    }

    public static String nvlNull(String ... datos) {
        for (String dato : datos) {
            if (StringUtil.isEmptyNull(dato)) continue;
            return dato;
        }
        return "";
    }

    public static boolean isNumber(String number, boolean couldHaveDecimalPoint, boolean couldHaveMinus) {
        if (StringUtil.isEmpty(number)) {
            return false;
        }
        Pattern pattern = couldHaveMinus ? (couldHaveDecimalPoint ? patternNumberSignedDecimal : patternNumberSigned) : (couldHaveDecimalPoint ? patternNumberUnsignedDecimal : patternNumberUnsigned);
        return pattern.matcher(number).matches();
    }

    public static boolean isNumber(String number) {
        return StringUtil.isNumber(number, false, false);
    }

    public static String join(String[] splitted, String joinString) {
        if (joinString == null) {
            joinString = "";
        }
        if (splitted != null) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String split : splitted) {
                if (split == null) continue;
                if (first) {
                    result.append(split);
                    first = false;
                    continue;
                }
                result.append(joinString).append(split);
            }
            return result.toString();
        }
        return null;
    }

    public static String join(String joinString, String ... toJoin) {
        return StringUtil.join(toJoin, joinString);
    }

    public static String flatten(String value) {
        return StringUtil.flatten(value, "");
    }

    public static String flatten(String value, String replaceNewLines) {
        if (value == null) {
            return null;
        }
        return value.replace("\r\n", replaceNewLines).replace("\n\r", replaceNewLines).replace("\n", replaceNewLines).replace("\r", replaceNewLines);
    }

    public static String removeCDATA(String cdata) {
        if (cdata != null) {
            cdata = cdata.replace("<![CDATA[", "").replace("]]>", "");
        }
        return cdata;
    }

    public static Map<String, String> asMap(String ... args) {
        if (args == null) {
            return null;
        }
        if (args.length % 2 != 0) {
            throw new ApplicationException("Los argumentos tienen que ser pares");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        return result;
    }

    public static Map<String, String> asMap(ArrayList<String> args) {
        if (args == null) {
            return null;
        }
        if (args.size() % 2 != 0) {
            throw new ApplicationException("Los argumentos tienen que ser pares");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < args.size(); i += 2) {
            result.put(args.get(i), args.get(i + 1));
        }
        return result;
    }

    public static String toXML(JAXBElement<?> element) {
        if (element == null) {
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{element.getValue().getClass()});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(element, (OutputStream)baos);
            return baos.toString();
        }
        catch (Exception e) {
            log.error("Error al convertir a XML el elemento [" + element + "]", (Throwable)e);
            return "";
        }
    }

    public static String trunc(String input, int length) {
        if (input == null) {
            return null;
        }
        return input.substring(0, Math.min(input.length(), length));
    }

    public static String getFormattedXML(String xml) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(is);
            return StringUtil.getXMLFromDoc(doc, true, false);
        }
        catch (Exception e) {
            throw new ApplicationException("Error al formatear XML", e);
        }
    }

    public static String getXMLFromDoc(Document doc, boolean indent, boolean removeRootElementAndHeader) {
        try {
            DOMSource domSource = new DOMSource(doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (removeRootElementAndHeader) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "ISO-8859-1");
            }
            if (indent) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
            }
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            String result = sw.toString();
            if (removeRootElementAndHeader && !StringUtil.isEmpty(result)) {
                String eol = indent ? EOL : "";
                int finPrimerTag = result.indexOf(">" + eol);
                result = result.substring(finPrimerTag + 1 + eol.length());
                int comUltimoTag = result.lastIndexOf(eol + "<");
                result = result.substring(0, comUltimoTag + eol.length());
            }
            return result;
        }
        catch (Exception e) {
            throw new ApplicationException("Error al formatear XML", e);
        }
    }

    public static String addToMap(Map<String, String> propertiesMap, String actualProperties, char listSeparatorChar) {
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            return actualProperties;
        }
        Map<String, String> actualPropertiesMap = StringUtil.splitToMap(actualProperties, listSeparatorChar);
        actualPropertiesMap.putAll(propertiesMap);
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : actualPropertiesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            result.append(sep).append(entry.getKey()).append("=").append(entry.getValue());
            sep = String.valueOf(listSeparatorChar);
        }
        return result.toString();
    }

    public static Set<String> asSet(String accessGroup) {
        return new HashSet<String>(Arrays.asList(StringUtil.split(accessGroup, ',')));
    }

    public static String maskCardNumber(String cardNumber, char maskChar) {
        if (StringUtil.isEmptyNull(cardNumber)) {
            return null;
        }
        String s = cardNumber.replaceAll("\\D", "");
        int end = s.length() - 4;
        String overlay = StringUtils.repeat((char)maskChar, (int)end);
        return StringUtils.overlay((String)s, (String)overlay, (int)0, (int)end);
    }

    public static String maskMercadoPagoAccessToken(String accessToken) {
        Object result;
        if (StringUtil.isEmpty(accessToken)) {
            return accessToken;
        }
        int firstDashPos = accessToken.indexOf(45);
        if (firstDashPos > 0) {
            result = accessToken.substring(0, firstDashPos);
            int lastDashPos = accessToken.lastIndexOf(45);
            if (lastDashPos > 0 && lastDashPos != firstDashPos) {
                result = (String)result + accessToken.substring(firstDashPos, lastDashPos).replaceAll("[A-Za-z0-9]", LIST_ANY);
                result = (String)result + accessToken.substring(lastDashPos);
            } else {
                result = (String)result + accessToken.substring(firstDashPos).replaceAll("[A-Za-z0-9]", LIST_ANY);
            }
        } else {
            result = accessToken;
        }
        return result;
    }

    public static String replaceCharacters(String value, String regex, String replaceWith) {
        value = value.replaceAll(regex, replaceWith);
        return value;
    }

    public static String removeAccents(String s) {
        int ampIndex = s.indexOf("&");
        int semicolonindex = s.indexOf(";");
        while (ampIndex != -1 && semicolonindex != -1) {
            String letter = s.substring(ampIndex + 1, ampIndex + 2);
            String accent = s.substring(ampIndex, semicolonindex + 1);
            s = s.replaceAll(accent, letter);
            ampIndex = s.indexOf("&");
            semicolonindex = s.indexOf(";");
        }
        return s;
    }

    public static String[] splitAtIndex(String s, int index) {
        if (s == null) {
            return null;
        }
        if (index >= s.length() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{s.substring(0, index), s.substring(index)};
    }

    public static String removeBOM(String text) {
        if (text.charAt(0) == '\ufeff') {
            return text.substring(1);
        }
        return text;
    }

    public static String splitLineByLength(String line, int lengthToSplit) {
        if (line == null) {
            return null;
        }
        if (lengthToSplit == 0) {
            return line;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            result.append(line.charAt(i));
            if ((i + 1) % lengthToSplit != 0 || i == line.length() - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static boolean isValidCuit(String cuit) {
        if (StringUtil.isEmptyNull(cuit)) {
            return false;
        }
        if ((cuit = StringUtil.replace(cuit, "-", "").trim()).length() != 11) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)cuit)) {
            return false;
        }
        String prefix = cuit.substring(0, 2);
        if (!StringUtil.in(prefix, "20", "23", "24", "25", "26", "27", "30", "33", "34")) {
            return false;
        }
        int[] coefficients = new int[]{5, 4, 3, 2, 7, 6, 5, 4, 3, 2};
        int sum = 0;
        for (int i = 0; i < coefficients.length; ++i) {
            sum += (cuit.charAt(i) - 48) * coefficients[i];
        }
        int remainder = sum % 11;
        int verificador = remainder == 0 ? 0 : (remainder == 1 ? 9 : 11 - remainder);
        int providedVerificador = cuit.charAt(10) - 48;
        return verificador == providedVerificador;
    }

    public static boolean isValidRut(String rut) {
        String valor = StringUtil.replace((String)rut, ".", "");
        if ((valor = StringUtil.replace(valor, "-", "")).length() < 8) {
            return false;
        }
        String cuerpo = valor.substring(0, valor.length() - 1);
        String dv = valor.substring(valor.length() - 1).toUpperCase();
        rut = cuerpo + "-" + dv;
        long suma = 0L;
        long multiplo = 2L;
        for (int i = 1; i <= cuerpo.length(); ++i) {
            long index = multiplo * (long)Character.getNumericValue(valor.charAt(cuerpo.length() - i));
            suma += index;
            if (multiplo < 7L) {
                ++multiplo;
                continue;
            }
            multiplo = 2L;
        }
        long dvEsperado = 11L - suma % 11L;
        dv = dv.equals("K") ? "10" : dv;
        String string = dv = dv.equals("0") ? "11" : dv;
        return dvEsperado == Long.parseLong(dv);
    }

    public static String dniFromCuit(String cuit) {
        if (StringUtil.isEmptyNull(cuit)) {
            return "";
        }
        if (cuit.length() == 11) {
            return cuit.substring(2, 10);
        }
        return cuit;
    }

    public static String formatCuit(String cuit) {
        if (StringUtil.isEmptyNull(cuit)) {
            return "";
        }
        if (cuit.length() == 11 && !cuit.contains("-")) {
            return cuit.substring(0, 2) + "-" + cuit.substring(2, 10) + "-" + cuit.substring(10);
        }
        return cuit;
    }

    public static String applyFormat(String format, String value, int size) {
        if (StringUtil.isNotEmpty(format)) {
            for (String string : StringUtil.listValues(format)) {
                String formatTagUpper = string.toUpperCase();
                if (formatTagUpper.startsWith("PADR:")) {
                    String string2 = string + PAD_SPC;
                    char pad = string2.substring(5, 6).charAt(0);
                    if (formatTagUpper.length() > 7) {
                        size = Integer.parseInt(formatTagUpper.substring(7));
                    }
                    value = StringUtil.padd(value, size, pad, PADD_RIGHT);
                    continue;
                }
                if (formatTagUpper.startsWith("PADL:")) {
                    String string3 = string + PAD_SPC;
                    char pad = string3.substring(5, 6).charAt(0);
                    if (formatTagUpper.length() > 7) {
                        size = Integer.parseInt(formatTagUpper.substring(7));
                    }
                    value = StringUtil.padd(value, size, pad, PADD_LEFT);
                    continue;
                }
                if (formatTagUpper.startsWith("FILL_AT:")) {
                    String formatSpecs = string.substring("FILL_AT:".length());
                    String[] formatSpecsParts = formatSpecs.split(",");
                    Integer position = Integer.valueOf(formatSpecsParts[0]);
                    char pad = formatSpecsParts[1].charAt(0);
                    value = StringUtil.padd(value, size, pad, FILL_AT, position);
                    continue;
                }
                if (formatTagUpper.startsWith("FROMTO:")) {
                    String fromTo = string.substring(7);
                    value = StringUtil.fromToParser(value, fromTo);
                    continue;
                }
                if (formatTagUpper.startsWith("TRIMZERO")) {
                    value = StringUtil.trimLeadingSpacesAndZeroes(value);
                    continue;
                }
                if (formatTagUpper.startsWith("TRIM:")) {
                    value = StringUtil.trimAll(value, string.substring("TRIM:".length()).charAt(0));
                    continue;
                }
                if (formatTagUpper.startsWith("TRIM")) {
                    value = value.trim();
                    continue;
                }
                if (formatTagUpper.startsWith("LTRIM:")) {
                    value = StringUtil.trimLeading(value, string.substring("LTRIM:".length()).charAt(0));
                    continue;
                }
                if (formatTagUpper.startsWith("RTRIM:")) {
                    value = StringUtil.trimTrailing(value, string.substring("RTRIM:".length()).charAt(0));
                    continue;
                }
                if (formatTagUpper.startsWith("RIGHT:")) {
                    value = StringUtils.right((String)value, (int)Integer.parseInt(string.substring("RIGHT:".length())));
                    continue;
                }
                if (formatTagUpper.startsWith("LEFT:")) {
                    value = StringUtils.left((String)value, (int)Integer.parseInt(string.substring("LEFT:".length())));
                    continue;
                }
                if (formatTagUpper.startsWith("PRINTF:")) {
                    value = String.format(string.substring("PRINTF:".length()), value);
                    continue;
                }
                if (formatTagUpper.startsWith("LOWER")) {
                    value = value.toLowerCase();
                    continue;
                }
                if (formatTagUpper.startsWith("UPPER")) {
                    value = value.toUpperCase();
                    continue;
                }
                if (formatTagUpper.startsWith("SANITIZE")) {
                    value = StringUtil.sanitizeASCII(value).replaceAll("[\\']", "_");
                    value = StringUtil.padd(value, size, ' ', PADD_RIGHT);
                    continue;
                }
                if (!formatTagUpper.startsWith("EXCELNUMBER") || !value.endsWith(".00")) continue;
                value = value.substring(0, value.length() - 3);
            }
        }
        return value;
    }

    public static String generateRandomNumberSixDigitsString() {
        return StringUtil.generateRandomNumberSixDigitsString("%06d");
    }

    public static String generateRandomNumberSixDigitsString(String format) {
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        return String.format(format, number);
    }

    public static String generateTokenUrlFormat() {
        byte[] randomBytes = new byte[100];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        random.nextBytes(randomBytes);
        String encoded = Base64.getUrlEncoder().encodeToString(randomBytes);
        return encoded.substring(0, 50);
    }

    public static String obfuscate(Long value) {
        if (value == null) {
            return null;
        }
        if (value >= 0L) {
            return Obfuscate.obfuscate(value);
        }
        return "-" + Obfuscate.obfuscate(Math.abs(value));
    }

    public static Long deobfuscate(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("-")) {
            return Obfuscate.illuminate(value.substring(1)) * -1L;
        }
        return Obfuscate.illuminate(value);
    }

    public static String getSplit(String value, int index) {
        if (StringUtil.isEmptyNull(value)) {
            return "";
        }
        List<String> values = StringUtil.listValues(value, '|');
        if (index >= 0 && index < values.size()) {
            return values.get(index);
        }
        return "";
    }

    public static String getJAXBValue(JAXBElement<?> element) {
        if (element == null || element.isNil()) {
            return "";
        }
        return StringUtil.nonNull(element.getValue());
    }

    public static boolean containsAll(String value, char character) {
        if (StringUtil.isEmpty(value)) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (c == character) continue;
            return false;
        }
        return true;
    }

    public static String lastSubstring(String value, int cant) {
        if (StringUtil.isEmpty(value)) {
            return value;
        }
        if (cant >= value.length()) {
            return value;
        }
        if (cant > 0) {
            return value.substring(value.length() - cant);
        }
        return "";
    }

    public static boolean isEmptyOrEquals(String str1, String ... strsToCompare) {
        if (StringUtil.isEmpty(str1)) {
            return true;
        }
        for (String strToCompare : strsToCompare) {
            if (!str1.equals(strToCompare)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(String str, String ... args) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (!StringUtil.emptySafeEquals(str, arg)) continue;
            return true;
        }
        return false;
    }

    public static String mapInRanges(String value, String ... rangeTexts) {
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        BigDecimal val = new BigDecimal(value);
        BigDecimal from = null;
        BigDecimal to = null;
        int i = 0;
        for (String rangeText : rangeTexts) {
            switch (i % 3) {
                case 0: {
                    if (rangeText == null) break;
                    from = new BigDecimal(rangeText);
                    break;
                }
                case 1: {
                    if (rangeText == null) break;
                    to = new BigDecimal(rangeText);
                    break;
                }
                case 2: {
                    if ((from == null || NumberUtil.bigDecimalMenorOIgual(from, val)) && (to == null || NumberUtil.bigDecimalMenor(val, to))) {
                        return rangeText;
                    }
                    from = null;
                    to = null;
                }
            }
            ++i;
        }
        return "";
    }

    public static String mapInRanges(Integer value, String ... rangeTexts) {
        return StringUtil.mapInRanges(value.toString(), rangeTexts);
    }

    public static boolean patternMatches(String emailAddress, String regexPattern) {
        return Pattern.compile(regexPattern).matcher(emailAddress).matches();
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        return StringUtil.patternMatches(emailAddress, EMAIL_ADDRESS_VALIDATION_PATTERN);
    }

    public static class Obfuscate {
        static final int feistelRounds = 4;
        static final int randRounds = 4;
        static final long seed = 69420L;
        static final long mod = 60466176L;

        private static long f(long x) {
            long a = 13L;
            long c = 1361423303L;
            x = (x + 69420L) % 60466176L;
            int r = 4;
            while (r-- != 0) {
                x = (13L * x + 1361423303L) % 60466176L;
            }
            return x;
        }

        public static String obfuscate(long i) {
            long a = i / 60466176L;
            long b = i % 60466176L;
            int r = 4;
            while (r-- != 0) {
                a = (a + Obfuscate.f(b)) % 60466176L;
                b = (b + Obfuscate.f(a)) % 60466176L;
            }
            return Obfuscate.pad5(Long.toString(a, 36)) + Obfuscate.pad5(Long.toString(b, 36));
        }

        public static long illuminate(String s) {
            long a = Long.valueOf(s.substring(0, 5), 36);
            long b = Long.valueOf(s.substring(5, 10), 36);
            int r = 4;
            while (r-- != 0) {
                b = (b - Obfuscate.f(a)) % 60466176L;
                a = (a - Obfuscate.f(b)) % 60466176L;
            }
            a = (a + 60466176L) % 60466176L;
            b = (b + 60466176L) % 60466176L;
            return a * 60466176L + b;
        }

        public static String pad5(String s) {
            return String.format("%5s", s).replace(' ', '0').toUpperCase(Locale.ENGLISH);
        }
    }
}

