/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.commons.util.mapper.ValueMapper;
import java.util.ArrayList;

public class SubstringMapper
extends ValueMapper {
    private ArrayList mapSpecs = new ArrayList();

    public SubstringMapper(String decode) {
        String[] terms = decode.split(";");
        for (int i = 0; i < terms.length; ++i) {
            this.mapSpecs.add(new MapSpec(terms[i]));
        }
    }

    @Override
    public String map(String source) {
        for (MapSpec spec : this.mapSpecs) {
            if (!spec.matches(source)) continue;
            return spec.map(source);
        }
        return null;
    }

    private class MapSpec {
        String valueSpec;
        String valueCompare;
        String resultSpec;

        public MapSpec(String spec) {
            String[] term = spec.split("[|]");
            String condition = term[0];
            this.resultSpec = term[1];
            if (condition.equals("*")) {
                this.valueCompare = null;
                this.valueSpec = null;
            } else {
                String[] conditionTerms = condition.split("=");
                this.valueSpec = conditionTerms[0];
                this.valueCompare = conditionTerms[1];
            }
        }

        public boolean matches(String value) {
            if (this.valueSpec == null) {
                return true;
            }
            String valueTest = StringUtil.fromToParser(value, this.valueSpec);
            return valueTest.equals(this.valueCompare);
        }

        public String map(String value) {
            return StringUtil.fromToParser(value, this.resultSpec);
        }
    }
}

