package ar.com.sdd.commons.util.mapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * 	Esta clase sirve de soporte en procesos de parsing, reemplazando valores.
 *  El formato que recibe es:
 *
 *      [=]input[|output];input[|output];....
 *
 *  Reemplaza todas las apariciones de cada uno de los input por su correspondiente output.
 *  Si el formato comienza con "=" entonces solo hace el reemplazo de la primer expresion que
 *  matchee, y si no logra hacer ningun reemplazo devuelve null.
 *  Si en alguna de las expresiones falta el "output", reemplaza todo el string por el primer
 *  grupo matcheado (el primer grupo es toda la expresion o la subexpresion reconocida por el
 *  primer parentesis que aparece)
 *  Tips:
 *     - Para buscar ignore-case:
 *         =(?i)
 *
 *  @author sfreue
 */
public class ReplaceMapper extends ValueMapper {

	private LinkedHashMap<Pattern, String> replacePairs = new LinkedHashMap<Pattern, String>();
	private boolean replaceFirstMatching = false;
	public final static String ESCAPE_PIPE = "_ESCPIPE_";
    public final static String ESCAPE_SEMICOLON = "_ESCPYC_";

	public final static String ECHO = "=^(.*)$|$1";

	public ReplaceMapper( String replaceSpec ) {
		replaceFirstMatching = replaceSpec.startsWith( "=" );
		if ( replaceFirstMatching )
			replaceSpec = replaceSpec.substring( 1 );
		String specs[] = replaceSpec.split( ";" );
		for ( int i = 0; i < specs.length; i++ ) {
            specs[ i ] = specs[ i ].replace(ESCAPE_SEMICOLON, ";");

			String spec[] = specs[ i ].split( "[|]" );
            spec[ 0 ] = spec[ 0 ].replace(ESCAPE_PIPE, "|");
            if (spec.length == 1) {
                replacePairs.put( Pattern.compile(spec[ 0 ]), null );
            } else {
                spec[ 1 ] = spec[ 1 ].replace(ESCAPE_PIPE, "|");
                replacePairs.put( Pattern.compile(spec[ 0 ]), spec[ 1 ] );
            }


		}
	}

	public String map( String source ) {
		if (source == null) {
			return null;
		}
		boolean didReplacement = false;
		for ( Map.Entry<Pattern, String> spec : replacePairs.entrySet() ) {
			Matcher matcher = spec.getKey().matcher( source );
			try {
				String replacement = spec.getValue();
				if ( replacement == null ) {
					replacement="";
				}
				String oldSource = source;
				source = matcher.replaceAll( replacement );
				if (!source.equals(oldSource)) {
					didReplacement = true;
				} else {
					//Hay algunos pocos casos en que el replace fue exactamente por el mismo
					//source. Quiero poder identificarlos, pero sin penalizar la ejecucion
					//haciendo este test en todos los casos
					matcher.reset();
					if (matcher.find()) {
						didReplacement = true;
					}
				}
			} catch (RuntimeException e) {
				// Esto solo deberia ocurrir cuando no hay un match, con lo que
				// seria adecuado no hacer ningun cambio
			}
			if ( didReplacement && replaceFirstMatching )
				break;
		}
		return (!replaceFirstMatching || didReplacement)? source: null;
	}

	public static String map(String decode,String source){
		ReplaceMapper map = new ReplaceMapper(decode);
		return map.map(source);
	}

}
