/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.util.xml;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;

public class XMLTag
extends DefaultMutableTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nsUri = null;
    private String name = null;
    private String data = null;
    private List<String> nsDeclarations = new ArrayList<String>();
    private Properties properties = new Properties();
    private Properties propertiesNsUri = new Properties();

    public XMLTag(String name) {
        this(name, new Properties(), null);
    }

    public XMLTag(String name, Properties properties) {
        this(name, properties, null);
    }

    public XMLTag(String name, String data) {
        this(name, new Properties(), data);
    }

    public XMLTag(String name, Properties properties, String data) {
        this.setName(name);
        this.setProperties(properties);
        this.setData(data);
    }

    public XMLTag(XMLTag copyFrom) {
        this(copyFrom.getName());
        this.setNsUri(copyFrom.getNsUri());
        this.setData(copyFrom.getData());
        for (String string : copyFrom.getProperties().keySet()) {
            this.setProperty(copyFrom.getPropertyNsUri(string), string, copyFrom.getProperty(string));
        }
        Enumeration<TreeNode> enumeration = copyFrom.children();
        while (enumeration.hasMoreElements()) {
            XMLTag child = (XMLTag)enumeration.nextElement();
            XMLTag clonedChild = new XMLTag(child);
            this.add(clonedChild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.propertiesNsUri = new Properties();
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String def) {
        return this.properties.getProperty(name, def);
    }

    public String getPropertyNsUri(String name) {
        return this.propertiesNsUri.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.setProperty("", name, value);
    }

    public void setProperty(String nsUri, String name, String value) {
        this.properties.setProperty(name, value);
        this.propertiesNsUri.setProperty(name, nsUri);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
        this.propertiesNsUri.remove(name);
    }

    public String getData(String dflt) {
        return this.data == null || "".equals(this.data) ? dflt : this.data;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void appendToData(String moreData) {
        this.data = this.data != null ? this.data + moreData : moreData;
    }

    public void saveToStringBuilder(StringBuilder builder) {
        String tabs = "\t".repeat(Math.max(0, this.getLevel() - 1));
        builder.append(tabs).append("<").append(this.getName());
        if (this.getProperties().size() > 0) {
            Enumeration<Object> names = this.getProperties().keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                builder.append(" ").append(name).append(" =\"").append(this.getProperty(name)).append("\"");
            }
        }
        for (String ns : this.nsDeclarations) {
            builder.append(ns);
        }
        if (this.getChildCount() > 0) {
            builder.append(">\n");
            Enumeration<TreeNode> childs = this.children();
            while (childs.hasMoreElements()) {
                XMLTag tag = (XMLTag)childs.nextElement();
                tag.saveToStringBuilder(builder);
            }
            builder.append(tabs).append("</").append(this.getName()).append(">\n");
        } else if (StringUtils.isNotEmpty((CharSequence)this.getData())) {
            builder.append(">").append(this.getData()).append("</").append(this.getName()).append(">\n");
        } else {
            builder.append("/>\n");
        }
    }

    public void saveToStream(PrintStream out) {
        this.saveToStream(new PrintWriter(out));
    }

    public void saveToStream(PrintWriter out) {
        Object tabs = "";
        for (int i = 0; i < this.getLevel(); ++i) {
            tabs = (String)tabs + "\t";
        }
        out.print((String)tabs + "<" + this.getName());
        if (this.getProperties().size() > 0) {
            Enumeration<Object> names = this.getProperties().keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                out.print(" " + name + "=\"" + this.getProperty(name) + "\"");
            }
        }
        for (String ns : this.nsDeclarations) {
            out.print(ns);
        }
        if (this.getChildCount() > 0) {
            out.println(">");
            Enumeration<TreeNode> childs = this.children();
            while (childs.hasMoreElements()) {
                XMLTag tag = (XMLTag)childs.nextElement();
                tag.saveToStream(out);
            }
            out.println((String)tabs + "</" + this.getName() + ">");
        } else if (this.getData() != null && this.getData().length() > 0) {
            out.println(">" + this.getData() + "</" + this.getName() + ">");
        } else {
            out.println("/>");
        }
    }

    public XMLTag getItem(String name) {
        ArrayList<XMLTag> v = this.getItems(name, true);
        return v.size() > 0 ? v.get(0) : null;
    }

    public XMLTag getItem(String name, boolean recursive) {
        ArrayList<XMLTag> v = this.getItems(name, recursive);
        return v.size() > 0 ? v.get(0) : null;
    }

    public XMLTag getOptionalItem(String name) {
        ArrayList<XMLTag> v = this.getItems(name);
        return v != null && v.size() > 0 ? v.get(0) : null;
    }

    public ArrayList<XMLTag> getFirstLevelItems(String name) {
        ArrayList<XMLTag> items = new ArrayList<XMLTag>();
        if (this.getChildCount() > 0) {
            Enumeration<TreeNode> childs = this.children();
            while (childs.hasMoreElements()) {
                XMLTag tag = (XMLTag)childs.nextElement();
                if (name != null && !tag.getName().equalsIgnoreCase(name)) continue;
                items.add(tag);
            }
        }
        return items;
    }

    public ArrayList<XMLTag> getItems(String name) {
        return this.getItems(name, true);
    }

    public ArrayList<XMLTag> getItems(String name, boolean recursive) {
        return this.getItems(null, name, recursive);
    }

    public ArrayList<XMLTag> getItems(String nsUri, String name, boolean recursive) {
        ArrayList<XMLTag> items = new ArrayList<XMLTag>();
        if (this.getChildCount() > 0) {
            Enumeration<TreeNode> childs = this.children();
            while (childs.hasMoreElements()) {
                XMLTag tag = (XMLTag)childs.nextElement();
                if (name.equalsIgnoreCase(tag.getName()) && (nsUri == null || tag.getNsUri() != null && tag.getNsUri().equals(nsUri))) {
                    items.add(tag);
                }
                if (!recursive) continue;
                items.addAll(tag.getItems(nsUri, name, recursive));
            }
        }
        return items;
    }

    public List<XMLTag> getFirstLevelChildren() {
        ArrayList<XMLTag> result = new ArrayList<XMLTag>();
        Enumeration<TreeNode> childs = this.children();
        if (childs != null) {
            while (childs.hasMoreElements()) {
                XMLTag tag = (XMLTag)childs.nextElement();
                result.add(tag);
            }
        }
        return result;
    }

    public XMLTag getFirstLevelChild() {
        XMLTag result = null;
        Enumeration<TreeNode> childs = this.children();
        if (childs != null && childs.hasMoreElements()) {
            result = (XMLTag)childs.nextElement();
        }
        return result;
    }

    public XMLTag getParentTag() {
        return this.getParent() != null && this.getParent() instanceof XMLTag ? (XMLTag)this.getParent() : null;
    }

    public String getNamePath() {
        String namePath = this.getName() + "[";
        for (Object key : this.getProperties().keySet()) {
            namePath = namePath + (String)key + "=" + this.getProperty((String)key) + ";";
        }
        namePath = namePath + "]";
        XMLTag parentTag = this.getParentTag();
        if (parentTag != null) {
            namePath = parentTag.getNamePath() + "/" + namePath;
        }
        return namePath;
    }

    @Override
    public String toString() {
        return this.toString('\n');
    }

    public String toString(char sep) {
        StringBuilder retr = new StringBuilder();
        retr.append("<").append(this.getName()).append(sep);
        Enumeration<Object> keys = this.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            retr.append(key).append("=").append(this.getProperty(key)).append(sep);
        }
        retr.append(">\n");
        retr.append(this.getData()).append("\n");
        retr.append("</").append(this.getName()).append(">");
        return retr.toString();
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public void setNsUri(String nsUri) {
        this.nsUri = nsUri;
    }

    public XMLTag deepClone() {
        XMLTag result = new XMLTag(this.getName());
        result.setNsUri(this.getNsUri());
        result.setData(this.getData());
        for (String string : this.getProperties().keySet()) {
            result.setProperty(this.getPropertyNsUri(string), string, this.getProperty(string));
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            XMLTag child = (XMLTag)enumeration.nextElement();
            XMLTag clonedChild = child.deepClone();
            result.add(clonedChild);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLTag other = (XMLTag)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nsDeclarations == null ? other.nsDeclarations != null : !this.nsDeclarations.equals(other.nsDeclarations)) {
            return false;
        }
        if (this.nsUri == null ? other.nsUri != null : !this.nsUri.equals(other.nsUri)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.propertiesNsUri == null ? other.propertiesNsUri != null : !this.propertiesNsUri.equals(other.propertiesNsUri));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nsDeclarations == null ? 0 : this.nsDeclarations.hashCode());
        result = 31 * result + (this.nsUri == null ? 0 : this.nsUri.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.propertiesNsUri == null ? 0 : this.propertiesNsUri.hashCode());
        return result;
    }

    public List<String> getNsDeclarations() {
        return this.nsDeclarations;
    }
}

