package ar.com.sdd.commons.util;

import java.util.*;

public class ObjectUtil {
	
	static public boolean safeEquals( Object o1, Object o2 ) {
		return
			o1 == null && o2 == null ||
			o1 != null && o2 != null && o1.equals( o2 );
	}
    
    static public String safeToString( Object o ) {
        return safeToString( o, null );
    }
    
    static public String safeToString( Object o, String defaultValue ) {
        return o == null? defaultValue: o.toString();
    }

    static public void initializeArray( Object[] array, Object value ) {
        for(int i=0;i<array.length; i++) {
        	array[i]=value;
        }
    }
    
    static public <E> List<E> arraySet(List<E> array, String indexId, E o) {
    	Integer index = null;
    	if (!StringUtil.isEmpty(indexId)) {
    		index = Integer.valueOf(indexId);
    	}
    	return arraySet(array, index, o);
    }
    static public <E> List<E> arraySet(List<E> array, Integer indexId, E o) {
        int index = 0;
    	if (indexId!=null) {
    		index = indexId;
    	} else {
    		index = array.size(); 
    	}
    	//Me aseguro de poner los huecos necesarios, si los parametros no vienen ordenados
    	while (index >= array.size()) {
    		array.add(null);
    	}
    	array.set(index, o);
    	return array;
    	
    }
	public static <T> Collection<T> deleteDuplicates(Collection<T> items){
		Collection<T> aux = new ArrayList<>();
		Set<T> set = new HashSet<>();
		set.addAll(items);
		aux.addAll(set);
		return aux;
	}



}
