package ar.com.sdd.commons.util.mapper;

import ar.com.sdd.commons.util.StringUtil;

import java.util.HashMap;
import java.util.Map;

/*
 * 	Esta clase sirve de soporte en procesos de parsing, mapeando pares de valores.
 *  El formato que recibe es:
 *      input|output;input|output;....;default
 *
 *  Cuando el input matchea por equals, devuelve el output.
 *  Si ninguno matchea, devuelve default, que puede ser null.
 *  Como caso especia, si default vale "$ECHO", devuelve el valor original
 *
 *         map(a, "a|1;b|2;3)     -> 1
 *         map(c, "a|1;b|2;3)     -> 3
 *         map(c, "a|1;b|2)       -> null
 *         map(c, "a|1;b|2;$ECHO) -> c
 *
 *  @dachcar
 */
public class DecodeMapper extends ValueMapper {

	private final Map<String, String> pairs;

	public final static String ESCAPE_PIPE = "_ESCPIPE_";
	public final static String ESCAPE_SEMICOLON = "_ESCPYC_";
	public final static String ESCAPE_ENTER = "_ESCPENTER_";

	/*
	 *  Recibe el criterio de mapeo en forma de un string del tipo source|target;source|target;default
	 */
	public DecodeMapper(String decode){
        pairs = new HashMap<>();
		String[] maps = StringUtil.split(decode, ';');
        for (String map : maps) {
            addMap(map.replace(ESCAPE_SEMICOLON, ";").replace(ESCAPE_ENTER, "\\n"));
        }
	}

	/*
	 *  Debe agregarse posteriormente los criterios con addMap(source|target) o addMap(default);
	 */
	public DecodeMapper(){
        pairs = new HashMap<>();
	}

	public DecodeMapper addMap(String map){
        String[] token = StringUtil.split(map, '|');
        if (token.length > 1) {
            pairs.put(token[0].replace(ESCAPE_PIPE, "|"), token[1].replace(ESCAPE_PIPE, "|"));
        } else {
            pairs.put("default", token[0].replace(ESCAPE_PIPE, "|"));
        }
		return this;
	}

	/*
	 *  Dado un cierto source devuelve su correspondiente target. Si este no pertence al criterio de mapeo
	 *  devuelve el valor por default
	 */
    public String map(String source) {
        if (pairs.containsKey(source))
            return pairs.get(source);
        else {
            String defaultValue = pairs.get("default");
            if ("$ECHO".equals(defaultValue)) {
                return source;
            } else {
                return defaultValue;
            }
        }
    }

    public static String map(String decode, String source) {
        DecodeMapper map = new DecodeMapper(decode);
        return map.map(source);
    }
}