package ar.com.sdd.commons.util.reflection;

import java.util.Objects;

public class TestObject {

    private final int intValue;
    private final String stringValue;
    private final Object objectValue;
    private final TestObject testObjectValue;

    public TestObject(int intValue, String stringValue, Object objectValue, TestObject testObjectValue) {
        this.intValue = intValue;
        this.stringValue = stringValue;
        this.objectValue = objectValue;
        this.testObjectValue = testObjectValue;
    }

    @Override
    public String toString() {
        return "TestObject [" +
                "intValue=" + intValue + ", " +
                ((stringValue != null) ? "stringValue='" + stringValue + "', " : "") +
                ((objectValue != null) ? "objectValue=" + objectValue + ", " : "") +
                ((testObjectValue != null) ? "testObjectValue=" + testObjectValue + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TestObject that = (TestObject) o;
        return intValue == that.intValue && Objects.equals(stringValue, that.stringValue) && Objects.equals(objectValue, that.objectValue) && Objects.equals(testObjectValue, that.testObjectValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(intValue, stringValue, objectValue, testObjectValue);
    }
}