package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.Meta;
import ar.com.sdd.creditosimple.entity.galicia.Error;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OrdenResponse {

    private Meta meta;
    private OrdenDataResponse data;
    private List<Error> errors;

    public Meta getMeta() {
        return meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public OrdenDataResponse getData() {
        return data;
    }

    public void setData(OrdenDataResponse data) {
        this.data = data;
    }

    public List<Error> getErrors() {
        return errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    @Override
    public String toString() {
        return "OrdenResponse ["
                + ((meta != null) ? "meta=" + meta + ", " : "")
                + ((data != null) ? "data=" + data + ", " : "")
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrdenResponse that = (OrdenResponse) o;

        if (meta != null ? !meta.equals(that.meta) : that.meta != null) return false;
        if (data != null ? !data.equals(that.data) : that.data != null) return false;
        return errors != null ? errors.equals(that.errors) : that.errors == null;
    }

    @Override
    public int hashCode() {
        int result = meta != null ? meta.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
