package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.Error;
import ar.com.sdd.creditosimple.entity.galicia.Meta;
import ar.com.sdd.creditosimple.entity.galicia.Simulacion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SimulacionResponse {

    private Meta meta;
    private Simulacion data;
    private List<Error> errors;

    public Meta getMeta() {
        return meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Simulacion getData() {
        return data;
    }

    public void setData(Simulacion data) {
        this.data = data;
    }

    public List<Error> getErrors() {
        return errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    @Override
    public String toString() {
        return "SimulacionResponse ["
                + ((meta != null) ? "meta=" + meta + ", " : "")
                + ((data != null) ? "data=" + data + ", " : "")
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SimulacionResponse response = (SimulacionResponse) o;

        if (meta != null ? !meta.equals(response.meta) : response.meta != null) return false;
        if (data != null ? !data.equals(response.data) : response.data != null) return false;
        return errors != null ? errors.equals(response.errors) : response.errors == null;
    }

    @Override
    public int hashCode() {
        int result = meta != null ? meta.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
