package ar.com.sdd.creditosimple.core.galicia;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.creditosimple.io.galicia.ConveniosResponse;
import ar.com.sdd.creditosimple.io.galicia.ErrorResponse;
import ar.com.sdd.creditosimple.io.galicia.OrdenRequest;
import ar.com.sdd.creditosimple.io.galicia.OrdenResponse;
import ar.com.sdd.creditosimple.io.galicia.OrdenesResponse;
import ar.com.sdd.creditosimple.io.galicia.SimulacionRequest;
import ar.com.sdd.creditosimple.io.galicia.SimulacionResponse;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.HashMap;
import java.util.Map;

public class CreditoSimpleGaliciaConnector implements RestSecurityManager {

    private static final Logger log = Logger.getLogger(CreditoSimpleGaliciaConnector.class);

    private final RestConnector restConnector;
    private final String appId;
    private final String appKey;


    public CreditoSimpleGaliciaConnector(CreditoSimpleGaliciaConnectorContext context) {
        String baseUrl = context.getBaseUrl();
        appId = context.getAppId();
        appKey = context.getAppKey();

        log.debug("Creando conector para CreditoSimple Galicia con baseUrl [" + baseUrl + "], appId [" + appId + "], appKey [" + appKey + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        restConnector = new RestConnector(environment, this);

    }

    /**
     * Valida un cuit y devuelve solo 200 si esta bien
     * Si esta erroneo, devueve 500 y el ResponseError.class lleno
     *
     * @param cuit
     * @throws RestConnectorException
     */
    public void getValidarCuit(String cuit) throws RestConnectorException {
        log.debug("[getValidarCuit] Request GET validar con cuit [" + cuit + "]");
        Map<String, Object> templateParameters = new HashMap<>();
        templateParameters.put("cuit", cuit);
        restConnector.genericGetTextResponse(null, null, "/v1/validar/{cuit}", templateParameters);
        log.debug("[getValidarCuit] Response GET validar [OK]");
    }


    public ConveniosResponse getConvenios()  throws RestConnectorException {
        log.debug("[getConvenios] Request GET convenios sin parametros");
        ConveniosResponse response = restConnector.genericGet(null, ConveniosResponse.class, ErrorResponse.class, "/v1/convenios");
        log.debug("[getConvenios] Response GET convenios [" + response + "]");
        return response;
    }

    public ConveniosResponse getConvenio(String idEmpresa) throws RestConnectorException {
        log.debug("[getConvenio] Request GET convenio con idEmpresa [" + idEmpresa + "]");
        ConveniosResponse response = restConnector.genericGet(null, ConveniosResponse.class, ErrorResponse.class, "/v1/convenios/{id_empresa}", "id_empresa", idEmpresa);
        log.debug("[getConvenio] Response GET convenio [" + response + "]");
        return response;
    }

    public SimulacionResponse postSimulacion(SimulacionRequest simulacionRequest) throws RestConnectorException {
        log.debug("[postSimulacion] Request POST simulacion [" + simulacionRequest + "]");
        SimulacionResponse response = restConnector.genericPost(simulacionRequest, SimulacionResponse.class, ErrorResponse.class, "/v1/simulacion");
        log.debug("[postSimulacion] Response POST simulacion [" + response + "]");
        return response;
    }

    public OrdenResponse postOrden(OrdenRequest ordenRequest) throws RestConnectorException {
        log.debug("[postOrden] Request POST orden [" + ordenRequest + "]");
        OrdenResponse response = restConnector.genericPost(ordenRequest, OrdenResponse.class, ErrorResponse.class, "/v1/orders");
        log.debug("[postOrden] Response POST orden [" + response + "]");
        return response;
    }

    public OrdenesResponse getOrdenes() throws RestConnectorException {
        log.debug("[getOrdenes] Request GET ordenes sin parametros");
        OrdenesResponse response = restConnector.genericGet(null, OrdenesResponse.class, ErrorResponse.class, "/v1/orders");
        log.debug("[getOrdenes] Response GET ordenes [" + response + "]");
        return response;
    }

    public OrdenesResponse getOrden(String idOrden) throws RestConnectorException {
        log.debug("[getOrden] Request GET orden con idOrden [" + idOrden + "]");
        OrdenesResponse response = restConnector.genericGet(null, OrdenesResponse.class, ErrorResponse.class, "/v1/orders/{id_orden}", "id_orden", idOrden);
        log.debug("[getOrden] Response GET orden [" + response + "]");
        return response;
    }



    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        builder.header("app_id", appId);
        builder.header("app_key", appKey);
        return builder;
    }
}
