package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Convenio {

    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    private String id;

    @JsonProperty("cantidad_cuotas")
    private Integer cantidadCuotas;

    @JsonProperty("fecha_primer_vencimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaPrimerVencimiento;

    @JsonProperty("tna_productor")
    private BigDecimal tnaProductor;

    @JsonProperty("periodo_meses")
    private Integer periodoMeses;

    @JsonProperty("tipo_financiacion")
    private String tipoFinanciacion;

    @JsonProperty("id_empresa")
    private String idEmpresa;

    //NO eliminar
    public String getDescription() {
        StringBuilder result = new StringBuilder(tipoFinanciacion);
        if (cantidadCuotas != null) {
            result.append(" cuotas:").append(cantidadCuotas);
        }
        if (fechaPrimerVencimiento != null) {
            result.append(" 1er venc:").append(sdf.format(fechaPrimerVencimiento));
        }
        if (periodoMeses != null) {
            result.append(" meses:").append(sdf.format(periodoMeses));
        }
        if (tnaProductor != null) {
            result.append(" tna:").append(tnaProductor);
        }
        return result.toString();
    }



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCantidadCuotas() {
        return cantidadCuotas;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        this.cantidadCuotas = cantidadCuotas;
    }

    public Date getFechaPrimerVencimiento() {
        return fechaPrimerVencimiento;
    }

    public void setFechaPrimerVencimiento(Date fechaPrimerVencimiento) {
        this.fechaPrimerVencimiento = fechaPrimerVencimiento;
    }

    public BigDecimal getTnaProductor() {
        return tnaProductor;
    }

    public void setTnaProductor(BigDecimal tnaProductor) {
        this.tnaProductor = tnaProductor;
    }

    public Integer getPeriodoMeses() {
        return periodoMeses;
    }

    public void setPeriodoMeses(Integer periodoMeses) {
        this.periodoMeses = periodoMeses;
    }

    public String getTipoFinanciacion() {
        return tipoFinanciacion;
    }

    public void setTipoFinanciacion(String tipoFinanciacion) {
        this.tipoFinanciacion = tipoFinanciacion;
    }

    public String getIdEmpresa() {
        return idEmpresa;
    }

    public void setIdEmpresa(String idEmpresa) {
        this.idEmpresa = idEmpresa;
    }


    @Override
    public String toString() {
        return "Convenio ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((cantidadCuotas != null) ? "cantidadCuotas=" + cantidadCuotas + ", " : "")
                + ((fechaPrimerVencimiento != null) ? "fechaPrimerVencimiento=" + fechaPrimerVencimiento + ", " : "")
                + ((tnaProductor != null) ? "tnaProductor=" + tnaProductor + ", " : "")
                + ((periodoMeses != null) ? "periodoMeses=" + periodoMeses + ", " : "")
                + ((tipoFinanciacion != null) ? "tipoFinanciacion=" + tipoFinanciacion + ", " : "")
                + ((idEmpresa != null) ? "idEmpresa=" + idEmpresa : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Convenio convenio = (Convenio) o;

        if (id != null ? !id.equals(convenio.id) : convenio.id != null) return false;
        if (cantidadCuotas != null ? !cantidadCuotas.equals(convenio.cantidadCuotas) : convenio.cantidadCuotas != null) return false;
        if (fechaPrimerVencimiento != null ? !fechaPrimerVencimiento.equals(convenio.fechaPrimerVencimiento) : convenio.fechaPrimerVencimiento != null) return false;
        if (tnaProductor != null ? !tnaProductor.equals(convenio.tnaProductor) : convenio.tnaProductor != null) return false;
        if (periodoMeses != null ? !periodoMeses.equals(convenio.periodoMeses) : convenio.periodoMeses != null) return false;
        if (tipoFinanciacion != null ? !tipoFinanciacion.equals(convenio.tipoFinanciacion) : convenio.tipoFinanciacion != null) return false;
        return idEmpresa != null ? idEmpresa.equals(convenio.idEmpresa) : convenio.idEmpresa == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (cantidadCuotas != null ? cantidadCuotas.hashCode() : 0);
        result = 31 * result + (fechaPrimerVencimiento != null ? fechaPrimerVencimiento.hashCode() : 0);
        result = 31 * result + (tnaProductor != null ? tnaProductor.hashCode() : 0);
        result = 31 * result + (periodoMeses != null ? periodoMeses.hashCode() : 0);
        result = 31 * result + (tipoFinanciacion != null ? tipoFinanciacion.hashCode() : 0);
        result = 31 * result + (idEmpresa != null ? idEmpresa.hashCode() : 0);
        return result;
    }
}

