package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.Convenio;
import ar.com.sdd.creditosimple.entity.galicia.Error;
import ar.com.sdd.creditosimple.entity.galicia.Meta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ConveniosResponse {

    private Meta meta;
    private List<Convenio> data;
    private List<Error> errors;

    public Meta getMeta() {
        return meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public List<Convenio> getData() {
        return data;
    }

    public void setData(List<Convenio> data) {
        this.data = data;
    }

    public List<Error> getErrors() {
        return errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    @Override
    public String toString() {
        return "ConveniosResponse ["
                + ((meta != null) ? "meta=" + meta + ", " : "")
                + ((data != null) ? "data=" + Arrays.toString(data.toArray()) + ", " : "")
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConveniosResponse that = (ConveniosResponse) o;

        if (meta != null ? !meta.equals(that.meta) : that.meta != null) return false;
        if (data != null ? !data.equals(that.data) : that.data != null) return false;
        return errors != null ? errors.equals(that.errors) : that.errors == null;
    }

    @Override
    public int hashCode() {
        int result = meta != null ? meta.hashCode() : 0;
        result = 31 * result + (data != null ? data.hashCode() : 0);
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
