package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName("informacion_desembolso")
public class InformacionDesembolso {

    @JsonProperty("monto_contrato_prestamo")
    private BigDecimal montoContratoPrestamo;

    @JsonProperty("fecha_desembolso")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private Date fechaDesembolso;

    private List<Retencion> retenciones;

    public BigDecimal getMontoContratoPrestamo() {
        return montoContratoPrestamo;
    }

    public void setMontoContratoPrestamo(BigDecimal montoContratoPrestamo) {
        this.montoContratoPrestamo = montoContratoPrestamo;
    }

    public Date getFechaDesembolso() {
        return fechaDesembolso;
    }

    public void setFechaDesembolso(Date fechaDesembolso) {
        this.fechaDesembolso = fechaDesembolso;
    }

    public List<Retencion> getRetenciones() {
        return retenciones;
    }

    public void setRetenciones(List<Retencion> retenciones) {
        this.retenciones = retenciones;
    }

    @Override
    public String toString() {
        return "InformacionDesembolso ["
                + ((montoContratoPrestamo != null) ? "montoContratoPrestamo=" + montoContratoPrestamo + ", " : "")
                + ((fechaDesembolso != null) ? "fechaDesembolso=" + fechaDesembolso + ", " : "")
                + ((retenciones != null) ? "retenciones=" + Arrays.toString(retenciones.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        InformacionDesembolso that = (InformacionDesembolso) o;

        if (montoContratoPrestamo != null ? !montoContratoPrestamo.equals(that.montoContratoPrestamo) : that.montoContratoPrestamo != null) return false;
        if (fechaDesembolso != null ? !fechaDesembolso.equals(that.fechaDesembolso) : that.fechaDesembolso != null) return false;
        return retenciones != null ? retenciones.equals(that.retenciones) : that.retenciones == null;
    }

    @Override
    public int hashCode() {
        int result = montoContratoPrestamo != null ? montoContratoPrestamo.hashCode() : 0;
        result = 31 * result + (fechaDesembolso != null ? fechaDesembolso.hashCode() : 0);
        result = 31 * result + (retenciones != null ? retenciones.hashCode() : 0);
        return result;
    }
}

