package ar.com.sdd.creditosimple.io.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SimulacionRequest {

    private String cuit;

    @JsonProperty("id_convenio")
    private String idConvenio;

    private BigDecimal monto;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getIdConvenio() {
        return idConvenio;
    }

    public void setIdConvenio(String idConvenio) {
        this.idConvenio = idConvenio;
    }

    public BigDecimal getMonto() {
        return monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    @Override
    public String toString() {
        return "SimulacionRequest ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((idConvenio != null) ? "idConvenio=" + idConvenio + ", " : "")
                + ((monto != null) ? "monto=" + monto : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SimulacionRequest that = (SimulacionRequest) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (idConvenio != null ? !idConvenio.equals(that.idConvenio) : that.idConvenio != null) return false;
        return monto != null ? monto.equals(that.monto) : that.monto == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (idConvenio != null ? idConvenio.hashCode() : 0);
        result = 31 * result + (monto != null ? monto.hashCode() : 0);
        return result;
    }
}

