/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.creditosimple.core.galicia;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.creditosimple.core.galicia.CreditoSimpleGaliciaConnectorContext;
import ar.com.sdd.creditosimple.io.galicia.ConveniosResponse;
import ar.com.sdd.creditosimple.io.galicia.ErrorResponse;
import ar.com.sdd.creditosimple.io.galicia.OrdenRequest;
import ar.com.sdd.creditosimple.io.galicia.OrdenesResponse;
import ar.com.sdd.creditosimple.io.galicia.SimulacionRequest;
import ar.com.sdd.creditosimple.io.galicia.SimulacionResponse;
import java.util.HashMap;
import javax.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class CreditoSimpleGaliciaConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(CreditoSimpleGaliciaConnector.class);
    private final RestConnector restConnector;
    private final String appId;
    private final String appKey;

    public CreditoSimpleGaliciaConnector(CreditoSimpleGaliciaConnectorContext context) {
        String baseUrl = context.getBaseUrl();
        this.appId = context.getAppId();
        this.appKey = context.getAppKey();
        log.debug((Object)("Creando conector para CreditoSimple Galicia con baseUrl [" + baseUrl + "], appId [" + this.appId + "], appKey [" + this.appKey + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public void getValidarCuit(String cuit) throws RestConnectorException {
        log.debug((Object)("[getValidarCuit] Request GET validar con cuit [" + cuit + "]"));
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        templateParameters.put("cuit", cuit);
        this.restConnector.genericGetTextResponse(null, ErrorResponse.class, "/v1/validar/{cuit}", templateParameters);
        log.debug((Object)"[getValidarCuit] Response GET validar [OK]");
    }

    public ConveniosResponse getConvenios() throws RestConnectorException {
        log.debug((Object)"[getConvenios] Request GET convenios sin parametros");
        ConveniosResponse response = (ConveniosResponse)this.restConnector.genericGet(null, ConveniosResponse.class, ErrorResponse.class, "/v1/convenios");
        log.debug((Object)("[getConvenios] Response GET convenios [" + response + "]"));
        return response;
    }

    public ConveniosResponse getConvenio(String idEmpresa) throws RestConnectorException {
        log.debug((Object)("[getConvenio] Request GET convenio con idEmpresa [" + idEmpresa + "]"));
        ConveniosResponse response = (ConveniosResponse)this.restConnector.genericGet(null, ConveniosResponse.class, ErrorResponse.class, "/v1/convenios/{id_empresa}", "id_empresa", idEmpresa);
        log.debug((Object)("[getConvenio] Response GET convenio [" + response + "]"));
        return response;
    }

    public SimulacionResponse postSimulacion(SimulacionRequest simulacionRequest) throws RestConnectorException {
        log.debug((Object)("[postSimulacion] Request POST simulacion [" + simulacionRequest + "]"));
        SimulacionResponse response = (SimulacionResponse)this.restConnector.genericPost((Object)simulacionRequest, SimulacionResponse.class, ErrorResponse.class, "/v1/simulacion");
        log.debug((Object)("[postSimulacion] Response POST simulacion [" + response + "]"));
        return response;
    }

    public OrdenesResponse postOrden(OrdenRequest ordenRequest) throws RestConnectorException {
        log.debug((Object)("[postOrden] Request POST orden [" + ordenRequest + "]"));
        OrdenesResponse response = (OrdenesResponse)this.restConnector.genericPost((Object)ordenRequest, OrdenesResponse.class, ErrorResponse.class, "/v1/orders");
        log.debug((Object)("[postOrden] Response POST orden [" + response + "]"));
        return response;
    }

    public OrdenesResponse getOrdenes() throws RestConnectorException {
        log.debug((Object)"[getOrdenes] Request GET ordenes sin parametros");
        OrdenesResponse response = (OrdenesResponse)this.restConnector.genericGet(null, OrdenesResponse.class, ErrorResponse.class, "/v1/orders");
        log.debug((Object)("[getOrdenes] Response GET ordenes [" + response + "]"));
        return response;
    }

    public OrdenesResponse getOrden(String idOrden) throws RestConnectorException {
        log.debug((Object)("[getOrden] Request GET orden con idOrden [" + idOrden + "]"));
        OrdenesResponse response = (OrdenesResponse)this.restConnector.genericGet(null, OrdenesResponse.class, ErrorResponse.class, "/v1/orders/{id_orden}", "id_orden", idOrden);
        log.debug((Object)("[getOrden] Response GET orden [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        builder.header("app_id", (Object)this.appId);
        builder.header("app_key", (Object)this.appKey);
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

