package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AccountV2 implements Serializable {

    @JsonProperty("number")
    private String number;

    @JsonProperty("cbu")
    private String cbu;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("type")
    private String type;

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "AccountV2 [" +
                ((number != null) ? "number='" + number + "', " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccountV2 accountV2 = (AccountV2) o;
        return Objects.equals(number, accountV2.number) && Objects.equals(cbu, accountV2.cbu) && Objects.equals(currency, accountV2.currency) && Objects.equals(type, accountV2.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, cbu, currency, type);
    }
}