package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AgreementV2 implements Serializable {

    @JsonProperty("tna_farmer")
    private BigDecimal tnaFarmer;
    
    @JsonProperty("interest_period_months")
    private Integer interestPeriodMonths;
    
    @JsonProperty("subsidy")
    private BigDecimal subsidy;

    @JsonProperty("first_expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT-03:00")
    private Date firstExpirationDate;

    @JsonProperty("description")
    private String description;
    
    @JsonProperty("loan_to_value_ratio")
    private BigDecimal loanToValueRatio;
    
    @JsonProperty("quantity_of_quotas")
    private Integer quantityOfQuotas;
    
    @JsonProperty("capital_period_months")
    private Integer capitalPeriodMonths;
    
    @JsonProperty("loan_type")
    private String loanType;
    
    @JsonProperty("periodicity")
    private String periodicity;
    
    @JsonProperty("fee")
    private BigDecimal fee;

    public BigDecimal getTnaFarmer() {
        return tnaFarmer;
    }

    public void setTnaFarmer(BigDecimal tnaFarmer) {
        this.tnaFarmer = tnaFarmer;
    }

    public Integer getInterestPeriodMonths() {
        return interestPeriodMonths;
    }

    public void setInterestPeriodMonths(Integer interestPeriodMonths) {
        this.interestPeriodMonths = interestPeriodMonths;
    }

    public BigDecimal getSubsidy() {
        return subsidy;
    }

    public void setSubsidy(BigDecimal subsidy) {
        this.subsidy = subsidy;
    }

    public Date getFirstExpirationDate() {
        return firstExpirationDate;
    }

    public void setFirstExpirationDate(Date firstExpirationDate) {
        this.firstExpirationDate = firstExpirationDate;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getLoanToValueRatio() {
        return loanToValueRatio;
    }

    public void setLoanToValueRatio(BigDecimal loanToValueRatio) {
        this.loanToValueRatio = loanToValueRatio;
    }

    public Integer getQuantityOfQuotas() {
        return quantityOfQuotas;
    }

    public void setQuantityOfQuotas(Integer quantityOfQuotas) {
        this.quantityOfQuotas = quantityOfQuotas;
    }

    public Integer getCapitalPeriodMonths() {
        return capitalPeriodMonths;
    }

    public void setCapitalPeriodMonths(Integer capitalPeriodMonths) {
        this.capitalPeriodMonths = capitalPeriodMonths;
    }

    public String getLoanType() {
        return loanType;
    }

    public void setLoanType(String loanType) {
        this.loanType = loanType;
    }

    public String getPeriodicity() {
        return periodicity;
    }

    public void setPeriodicity(String periodicity) {
        this.periodicity = periodicity;
    }

    public BigDecimal getFee() {
        return fee;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    @Override
    public String toString() {
        return "AgreementV2 [" +
                ((tnaFarmer != null) ? "tnaFarmer=" + tnaFarmer + ", " : "") +
                ((interestPeriodMonths != null) ? "interestPeriodMonths=" + interestPeriodMonths + ", " : "") +
                ((subsidy != null) ? "subsidy=" + subsidy + ", " : "") +
                ((firstExpirationDate != null) ? "firstExpirationDate=" + firstExpirationDate + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((loanToValueRatio != null) ? "loanToValueRatio=" + loanToValueRatio + ", " : "") +
                ((quantityOfQuotas != null) ? "quantityOfQuotas=" + quantityOfQuotas + ", " : "") +
                ((capitalPeriodMonths != null) ? "capitalPeriodMonths=" + capitalPeriodMonths + ", " : "") +
                ((loanType != null) ? "loanType='" + loanType + "', " : "") +
                ((periodicity != null) ? "periodicity='" + periodicity + "', " : "") +
                ((fee != null) ? "fee=" + fee + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AgreementV2 that = (AgreementV2) o;
        return Objects.equals(tnaFarmer, that.tnaFarmer) && Objects.equals(interestPeriodMonths, that.interestPeriodMonths) && Objects.equals(subsidy, that.subsidy) && Objects.equals(firstExpirationDate, that.firstExpirationDate) && Objects.equals(description, that.description) && Objects.equals(loanToValueRatio, that.loanToValueRatio) && Objects.equals(quantityOfQuotas, that.quantityOfQuotas) && Objects.equals(capitalPeriodMonths, that.capitalPeriodMonths) && Objects.equals(loanType, that.loanType) && Objects.equals(periodicity, that.periodicity) && Objects.equals(fee, that.fee);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tnaFarmer, interestPeriodMonths, subsidy, firstExpirationDate, description, loanToValueRatio, quantityOfQuotas, capitalPeriodMonths, loanType, periodicity, fee);
    }
}