package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProductV2 implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("product_key_name")
    private String productKeyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProductKeyName() {
        return productKeyName;
    }

    public void setProductKeyName(String productKeyName) {
        this.productKeyName = productKeyName;
    }

    @Override
    public String toString() {
        return "ProductV2 [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((productKeyName != null) ? "productKeyName='" + productKeyName + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductV2 productV2 = (ProductV2) o;
        return Objects.equals(id, productV2.id) && Objects.equals(name, productV2.name) && Objects.equals(productKeyName, productV2.productKeyName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, productKeyName);
    }
}