package ar.com.sdd.creditosimple.entity.galicia;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SimulacionV1 {
    /* Sample:
    "id_simulacion": "63ac7b2fe4d8335446530116",
    "informacion_financiera": { },
    "informacion_desembolso": { },
    "cuotas": [
        {
            "numero": 1,
            "monto": 270.62,
            "fecha_vencimiento": "28/01/2023"
        },
        {
            "numero": 2,
            "monto": 270.62,
            "fecha_vencimiento": "28/02/2023"
        }
        ],
        "codigo_moneda": "01",
        "descripcion_moneda": "Pesos Argentinos",
        "tipo_financiacion": "Mensual Con Subsidio"
        }
    */
    @JsonProperty("id_simulacion")
    private String idSimulacion;

    @JsonProperty("informacion_financiera")
    private InformacionFinancieraV1 informacionFinanciera;

    @JsonProperty("informacion_desembolso")
    private InformacionDesembolsoV1 informacionDesembolso;

    private List<CuotaV1> cuotas;

    @JsonProperty("codigo_moneda")
    private String codigoMoneda;

    @JsonProperty("descripcion_moneda")
    private String descripcionMoneda;

    @JsonProperty("tipo_financiacion")
    private String tipoFinanciacion;

    public String getIdSimulacion() {
        return idSimulacion;
    }

    public void setIdSimulacion(String idSimulacion) {
        this.idSimulacion = idSimulacion;
    }

    public InformacionFinancieraV1 getInformacionFinanciera() {
        return informacionFinanciera;
    }

    public void setInformacionFinanciera(InformacionFinancieraV1 informacionFinanciera) {
        this.informacionFinanciera = informacionFinanciera;
    }

    public InformacionDesembolsoV1 getInformacionDesembolso() {
        return informacionDesembolso;
    }

    public void setInformacionDesembolso(InformacionDesembolsoV1 informacionDesembolso) {
        this.informacionDesembolso = informacionDesembolso;
    }

    public List<CuotaV1> getCuotas() {
        return cuotas;
    }

    public void setCuotas(List<CuotaV1> cuotas) {
        this.cuotas = cuotas;
    }

    public String getCodigoMoneda() {
        return codigoMoneda;
    }

    public void setCodigoMoneda(String codigoMoneda) {
        this.codigoMoneda = codigoMoneda;
    }

    public String getDescripcionMoneda() {
        return descripcionMoneda;
    }

    public void setDescripcionMoneda(String descripcionMoneda) {
        this.descripcionMoneda = descripcionMoneda;
    }

    public String getTipoFinanciacion() {
        return tipoFinanciacion;
    }

    public void setTipoFinanciacion(String tipoFinanciacion) {
        this.tipoFinanciacion = tipoFinanciacion;
    }

    @Override
    public String toString() {
        return "Simulacion ["
                + ((idSimulacion != null) ? "idSimulacion=" + idSimulacion + ", " : "")
                + ((informacionFinanciera != null) ? "informacionFinanciera=" + informacionFinanciera + ", " : "")
                + ((informacionDesembolso != null) ? "informacionDesembolso=" + informacionDesembolso + ", " : "")
                + ((cuotas != null) ? "cuotas=" + Arrays.toString(cuotas.toArray()) + ", " : "")
                + ((codigoMoneda != null) ? "codigoMoneda=" + codigoMoneda + ", " : "")
                + ((descripcionMoneda != null) ? "descripcionMoneda=" + descripcionMoneda + ", " : "")
                + ((tipoFinanciacion != null) ? "tipoFinanciacion=" + tipoFinanciacion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SimulacionV1 that = (SimulacionV1) o;

        if (idSimulacion != null ? !idSimulacion.equals(that.idSimulacion) : that.idSimulacion != null) return false;
        if (informacionFinanciera != null ? !informacionFinanciera.equals(that.informacionFinanciera) : that.informacionFinanciera != null) return false;
        if (informacionDesembolso != null ? !informacionDesembolso.equals(that.informacionDesembolso) : that.informacionDesembolso != null) return false;
        if (cuotas != null ? !cuotas.equals(that.cuotas) : that.cuotas != null) return false;
        if (codigoMoneda != null ? !codigoMoneda.equals(that.codigoMoneda) : that.codigoMoneda != null) return false;
        if (descripcionMoneda != null ? !descripcionMoneda.equals(that.descripcionMoneda) : that.descripcionMoneda != null) return false;
        return tipoFinanciacion != null ? tipoFinanciacion.equals(that.tipoFinanciacion) : that.tipoFinanciacion == null;
    }

    @Override
    public int hashCode() {
        int result = idSimulacion != null ? idSimulacion.hashCode() : 0;
        result = 31 * result + (informacionFinanciera != null ? informacionFinanciera.hashCode() : 0);
        result = 31 * result + (informacionDesembolso != null ? informacionDesembolso.hashCode() : 0);
        result = 31 * result + (cuotas != null ? cuotas.hashCode() : 0);
        result = 31 * result + (codigoMoneda != null ? codigoMoneda.hashCode() : 0);
        result = 31 * result + (descripcionMoneda != null ? descripcionMoneda.hashCode() : 0);
        result = 31 * result + (tipoFinanciacion != null ? tipoFinanciacion.hashCode() : 0);
        return result;
    }
}

