package ar.com.sdd.creditosimple.io.galicia;

import ar.com.sdd.creditosimple.entity.galicia.AgreementV2;
import ar.com.sdd.creditosimple.entity.galicia.FarmerV2;
import ar.com.sdd.creditosimple.entity.galicia.MerchantV2;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreditCalculationV2Request implements Serializable {

    @JsonProperty("partner_key_name")
    private String partnerKeyName;
    
    @JsonProperty("product_key_name")
    private String productKeyName;

    @JsonProperty("farmer")
    private FarmerV2 farmer;

    @JsonProperty("merchant")
    private MerchantV2 merchant;

    @JsonProperty("agreement")
    private AgreementV2 agreement;

    @JsonProperty("farmer_cuit")
    private BigDecimal amount;
    
    public String getPartnerKeyName() {
        return partnerKeyName;
    }

    public void setPartnerKeyName(String partnerKeyName) {
        this.partnerKeyName = partnerKeyName;
    }

    public String getProductKeyName() {
        return productKeyName;
    }

    public void setProductKeyName(String productKeyName) {
        this.productKeyName = productKeyName;
    }

    public FarmerV2 getFarmer() {
        return farmer;
    }

    public void setFarmer(FarmerV2 farmer) {
        this.farmer = farmer;
    }

    public MerchantV2 getMerchant() {
        return merchant;
    }

    public void setMerchant(MerchantV2 merchant) {
        this.merchant = merchant;
    }

    public AgreementV2 getAgreement() {
        return agreement;
    }

    public void setAgreement(AgreementV2 agreement) {
        this.agreement = agreement;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return "CreditCalculationV2Request [" +
                ((partnerKeyName != null) ? "partnerKeyName='" + partnerKeyName + "', " : "") +
                ((productKeyName != null) ? "productKeyName='" + productKeyName + "', " : "") +
                ((farmer != null) ? "farmer=" + farmer + ", " : "") +
                ((merchant != null) ? "merchant=" + merchant + ", " : "") +
                ((agreement != null) ? "agreement=" + agreement + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreditCalculationV2Request that = (CreditCalculationV2Request) o;
        return Objects.equals(partnerKeyName, that.partnerKeyName) && Objects.equals(productKeyName, that.productKeyName) && Objects.equals(farmer, that.farmer) && Objects.equals(merchant, that.merchant) && Objects.equals(agreement, that.agreement) && Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partnerKeyName, productKeyName, farmer, merchant, agreement, amount);
    }
}